/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    private ClassLoader classLoader;

    public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    protected Class resolveProxyClass(String[] signatures) throws ClassNotFoundException {
        Class[] classes = new Class[signatures.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                classes[i] = Class.forName(signatures[i], true, this.getClassLoader());
                continue;
            }
            catch (ClassNotFoundException e) {
                Class cls = (Class)primClasses.get(signatures[i]);
                if (cls != null) {
                    classes[i] = cls;
                    continue;
                }
                throw e;
            }
        }
        return Proxy.getProxyClass(this.getClassLoader(), classes);
    }

    public Class resolveClass(ObjectStreamClass type) throws IOException, ClassNotFoundException {
        String name = type.getName();
        try {
            return Class.forName(name, true, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Class cls = (Class)primClasses.get(name);
            if (cls != null) {
                return cls;
            }
            throw e;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object resolveObject(Object obj) throws IOException {
        return super.resolveObject(obj);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

