/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ejb;

import com.evermind.ejb.EJBUser;
import com.evermind.ejb.EJBUserManager;
import com.evermind.security.Group;
import com.evermind.security.User;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

class EJBUserWrapper
implements User {
    protected EJBUserManager manager;
    protected String name;
    protected EJBUser user;

    public EJBUserWrapper(EJBUserManager manager, String name, EJBUser user) {
        this.manager = manager;
        this.name = name;
        this.user = user;
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.user.getDescription();
            }
            catch (RemoteException e) {
                throw new RuntimeException("RemoteException: " + e.getMessage());
            }
        }
        return this.name;
    }

    public String getDescription() {
        try {
            return this.user.getDescription();
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void setDescription(String description) {
        try {
            this.user.setDescription(description);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public Locale getLocale() {
        try {
            return this.user.getLocale();
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void setLocale(Locale locale) {
        try {
            this.user.setLocale(locale);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public boolean hasPermission(Permission permission) {
        Group group;
        Set groups = this.manager.getDefaultGroups();
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            if (!group.hasPermission(permission)) continue;
            return true;
        }
        try {
            if (this.user.hasPermission(permission)) {
                return true;
            }
            groups = this.user.getGroups();
            iterator = groups.iterator();
            while (iterator.hasNext()) {
                group = this.manager.getGroup(iterator.next().toString());
                if (group == null || !group.hasPermission(permission)) continue;
                return true;
            }
            return false;
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public boolean authenticate(String password) {
        try {
            return this.user.authenticate(password);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public boolean isMemberOf(Group group) {
        if (this.manager.getDefaultGroups().contains(group)) {
            return true;
        }
        try {
            Set groups = this.user.getGroups();
            return groups != null && groups.contains(group.getName());
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void setPassword(String password) {
        try {
            this.user.setPassword(password);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public BigInteger getCertificateSerial() {
        try {
            return this.user.getCertificateSerial();
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public String getCertificateIssuerDN() {
        try {
            return this.user.getCertificateIssuerDN();
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void setCertificate(String issuerDN, BigInteger serial) {
        try {
            this.user.setCertificate(issuerDN, serial);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void setCertificate(X509Certificate cert) {
        try {
            this.user.setCertificate(cert);
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void addToGroup(Group group) {
        if (this.manager.getDefaultGroups() != null && this.manager.getDefaultGroups().contains(group)) {
            return;
        }
        try {
            this.user.addToGroup(group.getName());
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public void removeFromGroup(Group group) {
        try {
            this.user.removeFromGroup(group.getName());
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public String getPassword() {
        try {
            return this.user.getPassword();
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }

    public Set getGroups() {
        HashSet<Group> response = new HashSet<Group>();
        try {
            Set groups = this.user.getGroups();
            if (groups != null) {
                Iterator iterator = groups.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (next instanceof String) {
                        Group group = this.manager.getGroup((String)next);
                        if (group == null) continue;
                        response.add(group);
                        continue;
                    }
                    if (next == null) {
                        throw new NullPointerException("EJB groups set contained null instance");
                    }
                    response.add((Group)next);
                }
            }
            return response;
        }
        catch (RemoteException e) {
            throw new RuntimeException("RemoteException: " + e.getMessage());
        }
    }
}

