/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class CompiledObject {
    private String name;
    private String filename;
    private byte[] data;

    public CompiledObject(String name, byte[] data) {
        this.name = name;
        this.data = data;
        this.filename = null;
    }

    public CompiledObject(String name, byte[] data, String filename) {
        this.name = name;
        this.data = data;
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() throws IOException {
        if (this.data == null && this.filename != null) {
            File file = new File(this.filename);
            FileInputStream in = null;
            in = new FileInputStream(file);
            this.data = new byte[(int)file.length()];
            in.read(this.data);
            in.close();
        }
        return this.data;
    }

    public String getFilename() {
        return this.filename;
    }

    public void clean() {
        File file;
        if (this.filename != null && (file = new File(this.filename)) != null) {
            file.delete();
            this.filename = null;
        }
        this.data = null;
    }
}

