/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandBase;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.AdminCommandParser;
import com.evermind.client.orion.AdminCommandUsage;
import com.evermind.client.orion.AdminCommandUtils;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.util.OC4JRuntimeProperties;
import com.evermind.util.ServerProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.as.j2ee.transaction.tpc.OfflineTransactionLogTool;
import oracle.j2ee.rmi.RMIInitialContextFactory;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.sql.config.ConvertLegacyConfig;

public class Oc4jAdminConsole {
    public static void main(String[] args) {
        if (args == null || args.length == 0 || args[0].equals("-help")) {
            System.out.println(AdminCommandUsage.getUsage());
            System.exit(9);
        }
        try {
            Oc4jAdminConsole.executeCommand(args);
        }
        catch (AdminCommandException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(e.getReturnCode());
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public static boolean execute(String[] args) {
        try {
            Oc4jAdminConsole.executeCommand(args);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void executeCommand(String[] args) throws AdminCommandException {
        if (args == null || args.length == 0 || args[0].equals("-help")) {
            throw new AdminCommandException("Missing command", 9);
        }
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        String ormiUrl = null;
        String userName = null;
        String password = null;
        String commandName = "";
        if (arguments.get(0).equals("-convertDataSourceConfiguration") || arguments.get(0).equals("-analyzeTransactionLogs") || arguments.get(0).equals("-updateTransactionLogs")) {
            commandName = (String)arguments.get(0);
        }
        if (commandName.equals("") && arguments.size() >= 4 && (arguments.get(3).equals("-convertDataSourceConfiguration") || arguments.get(3).equals("-analyzeTransactionLogs") || arguments.get(3).equals("-updateTransactionLogs"))) {
            arguments.remove(0);
            arguments.remove(0);
            arguments.remove(0);
            commandName = (String)arguments.get(0);
            System.out.println("Ignoring connection arguments for offline command.");
        }
        if (commandName.equalsIgnoreCase("-convertDataSourceConfiguration")) {
            Oc4jAdminConsole.convertDataSourceConfiguration(arguments);
        } else if (commandName.equalsIgnoreCase("-analyzeTransactionLogs")) {
            new OfflineTransactionLogTool(arguments).analyzeTransactionLogs();
        } else if (commandName.equalsIgnoreCase("-updateTransactionLogs")) {
            new OfflineTransactionLogTool(arguments).updateTransactionLogs();
        } else {
            AdminCommandBase command;
            ormiUrl = AdminCommandUtils.getNextArgument(arguments, "<ormi-url>");
            if (!AdminCommandUtils.isValidOrmiUrl(ormiUrl)) {
                throw new AdminCommandException("Missing ormi[s]://<host>:<port>");
            }
            boolean isLocalHost = AdminCommandUtils.isLocalHost(ormiUrl);
            userName = AdminCommandUtils.getNextArgument(arguments, "username");
            password = AdminCommandUtils.getNextArgument(arguments, "password");
            if (AdminCommandUsage.isExistingCommand(password)) {
                try {
                    String command2 = password;
                    password = AdminCommandUtils.queryPasswordFromUser();
                    arguments.add(0, command2);
                }
                catch (IOException e) {
                    throw new AdminCommandException("Error reading password from the standard input.");
                }
                catch (AdminCommandException ace) {
                    throw ace;
                }
            }
            Hashtable<String, String> environment = new Hashtable<String, String>();
            boolean opmnFlag = ServerProperties.getRunningInIAS();
            if (opmnFlag) {
                environment.put("OPMN", "true");
                userName = "admin";
                try {
                    String oracleHome = OC4JRuntimeProperties.getOracleHome();
                    password = Oc4jAdminConsole.readFormFactor(oracleHome);
                }
                catch (IOException e) {
                    throw new AdminCommandException("Password unavailable for OPMN flag on");
                }
            }
            environment.put("java.naming.provider.url", ormiUrl);
            environment.put("java.naming.security.principal", userName);
            environment.put("java.naming.security.credentials", password);
            environment.put("java.naming.factory.initial", "com.evermind.server.rmi.RMIInitialContextFactory");
            ApplicationServerAdministrator administrator = null;
            try {
                Context context = new RMIInitialContextFactory().getInitialContext((Hashtable)environment);
                administrator = (ApplicationServerAdministrator)context.lookup("java:comp/ServerAdministrator");
            }
            catch (CommunicationException e) {
                throw Oc4jAdminConsole.createCannotConnectException(e);
            }
            catch (NamingException e) {
                AdminCommandException ace = null;
                if (e.getRootCause() != null) {
                    if (e.getRootCause() instanceof ConnectException) {
                        ace = Oc4jAdminConsole.createCannotConnectException(e.getRootCause());
                    } else if (e.getRootCause() instanceof IOException) {
                        ace = new AdminCommandException(e.getRootCause(), "IOException communicating with the remote server: " + e.getRootCause().getMessage());
                        ace.setReturnCode(3);
                    } else {
                        ace = new AdminCommandException(e.getRootCause(), "Unexpected error during lookup : " + e.getMessage());
                    }
                } else {
                    ace = new AdminCommandException((Throwable)e, "Unable to find java:comp/ServerAdministrator: " + e.getMessage());
                }
                throw ace;
            }
            try {
                command = AdminCommandParser.parse(arguments);
            }
            catch (AdminCommandException ace) {
                if (ace.getReturnCode() != 0) {
                    throw ace;
                }
                System.out.println(ace.getMessage());
                return;
            }
            command.setIsLocalHost(isLocalHost);
            command.execute(administrator);
        }
    }

    private static AdminCommandException createCannotConnectException(Throwable e) {
        AdminCommandException ace = new AdminCommandException(e, "Could not connect to the remote server. Please check if the server is down or the client is using invalid host, ORMI port or password to connect: " + e.getMessage());
        ace.setReturnCode(2);
        return ace;
    }

    private static String readFormFactor(String oraclehome) throws IOException {
        int len;
        FileInputStream fis = null;
        String formfactor = null;
        String fname = oraclehome + File.separator + "opmn" + File.separator + "conf" + File.separator + ".formfactor";
        try {
            fis = new FileInputStream(fname);
        }
        catch (Exception e) {
            throw new IOException("Unable to open formfactor file " + fname);
        }
        try {
            byte[] buffer = new byte[48];
            len = fis.read(buffer);
            if (len > 0) {
                formfactor = new String(buffer, 0, len);
            }
            fis.close();
        }
        catch (IOException e) {
            if (e.getMessage().equals("End of stream encountered")) {
                throw new IOException("No entry found in formfactor file " + fname);
            }
            throw new IOException("I/O error encountered reading formfactor file " + fname);
        }
        if (len <= 0) {
            throw new IOException("No entry found in formfactor file " + fname);
        }
        return formfactor;
    }

    private static void convertDataSourceConfiguration(List arguments) throws AdminCommandException {
        block2: {
            try {
                AdminCommandUtils.getNextArgument(arguments, "<-convertDataSourceConfiguration>");
                String legacyFileName = AdminCommandUtils.getNextArgument(arguments, "<legacy file name>");
                String convertedFileName = AdminCommandUtils.getNextArgument(arguments, "<converted file name>");
                new ConvertLegacyConfig(legacyFileName, convertedFileName);
                System.out.println("Conversion was successful.  Please review the converted file (" + convertedFileName + ") and remove any unwanted entries.");
            }
            catch (ConfigException e) {
                System.out.println("Conversion failed.  Reason: " + e.getMessage());
                if (e.getCause() == null) break block2;
                System.out.println("Root cause: " + e.getCause());
            }
        }
    }
}

