/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassPoolEntry;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.CodeAttribute;
import com.evermind.bytecode.ExceptionRegion;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public class RawCodeAttribute
implements Attribute {
    protected ByteString code;
    protected Attribute[] attributes;
    protected short maxLocals;
    protected short maxStack;
    protected ExceptionRegion[] exceptions;

    public RawCodeAttribute(ClassSerialization type, DataInputStream in) throws IOException {
        short attributesLength;
        this.maxStack = in.readShort();
        this.maxLocals = in.readShort();
        int codeLength = in.readInt();
        byte[] data = new byte[codeLength];
        in.readFully(data);
        this.code = new ByteString(data);
        short exceptionsLength = in.readShort();
        if (exceptionsLength > 0) {
            this.exceptions = new ExceptionRegion[exceptionsLength];
            for (int i = 0; i < this.exceptions.length; ++i) {
                short from = in.readShort();
                short to = in.readShort();
                short handler = in.readShort();
                short typeID = in.readShort();
                ByteString typeName = typeID > 0 ? type.getUTF8Entry(((ClassPoolEntry)type.getPoolEntry((int)typeID)).classNameIndex) : null;
                this.exceptions[i] = new ExceptionRegion(from, to, handler, typeName);
            }
        }
        if ((attributesLength = in.readShort()) > 0) {
            this.attributes = new Attribute[attributesLength];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = type.readAttribute(in);
            }
        }
    }

    public ByteString getName() {
        return ClassSerialization.CODE;
    }

    public void write(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        out.writeShort(type.getPoolIndex(ClassSerialization.CODE));
        int lengthPos = out.getPos();
        out.writeInt(0);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.code.length);
        out.write(this.code.data, this.code.offset, this.code.length);
        if (this.exceptions == null) {
            out.writeShort(0);
        } else {
            CodeAttribute.writeExceptions(type, Arrays.asList(this.exceptions), out);
        }
        ClassData.writeAttributes(type, this.attributes, this.attributes.length, out);
        int newPos = out.getPos();
        out.setPos(lengthPos);
        out.writeInt(newPos - (lengthPos + 4));
        out.setPos(newPos);
    }

    public ByteString getCode() {
        return this.code;
    }

    public ExceptionRegion[] getExceptionRegions() {
        return this.exceptions;
    }

    public short getMaxLocals() {
        return this.maxLocals;
    }

    public short getMaxStack() {
        return this.maxStack;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }
}

