/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.FieldData;
import com.evermind.bytecode.FieldPoolEntry;
import com.evermind.bytecode.InterfaceMethodPoolEntry;
import com.evermind.bytecode.LineNumberTableAttribute;
import com.evermind.bytecode.MethodData;
import com.evermind.bytecode.MethodPoolEntry;
import com.evermind.bytecode.NameAndTypePoolEntry;
import com.evermind.bytecode.Opcode;
import com.evermind.bytecode.PoolEntry;
import com.evermind.bytecode.RawCodeAttribute;
import com.evermind.bytecode.StringPoolEntry;
import com.evermind.util.ByteString;
import com.evermind.util.StringUtils;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class ClassPrinter {
    public static void main(String[] args) throws Throwable {
        if (!args[0].endsWith(".class")) {
            args[0] = args[0] + ".class";
        }
        ClassSerialization serialization = new ClassSerialization();
        PrintWriter out = args.length > 1 ? new PrintWriter(new FileOutputStream(args[1], true)) : new PrintWriter(System.out, true);
        ClassData data = serialization.read(args[0], new DataInputStream(new FileInputStream(args[0])), out, 3, false);
        new ClassPrinter().print(serialization, data, out);
        out.close();
    }

    public void print(ClassSerialization type, ClassData data, PrintWriter out) {
        out.println("Name: " + data.name);
        out.println("Super: " + data.superClassName);
        out.println("Attributes:");
        ClassPrinter.printAttributes(type, data.attributes, data.attributeCount, out);
        out.println();
        out.println("Methods:");
        ClassPrinter.printMethods(type, data.methods, data.methodCount, out);
        out.println();
        out.println("Fields:");
        ClassPrinter.printFields(type, data.fields, data.fieldCount, out);
    }

    public static void printAttributes(ClassSerialization type, Attribute[] attributes, int count, PrintWriter out) {
        if (attributes == null) {
            out.println("<none>");
        } else {
            for (int i = 0; i < count; ++i) {
                ClassPrinter.printAttribute(type, attributes[i], out);
            }
        }
    }

    protected static int getShort(byte[] data, int pos) {
        return (short)(((char)data[pos++] & 0xFF) << 8) + ((char)data[pos++] & 0xFF);
    }

    protected static int getByte(byte[] data, int pos) {
        return (char)data[pos++] & 0xFF;
    }

    public static void printCode(ClassSerialization type, ByteString code, PrintWriter out, LineNumberTableAttribute lines) {
        int pos;
        int start = pos = code.offset;
        byte[] data = code.data;
        int end = code.getEnd();
        boolean lastWasWide = false;
        Opcode[] opcodes = new Opcode[end - start];
        while (pos < end) {
            Opcode opcode;
            int x = pos - start;
            int opcodeID = (char)data[pos] & 0xFF;
            opcodes[x] = opcode = new Opcode();
            opcode.name = "Unknown";
            try {
                switch (opcodeID) {
                    case 9: {
                        opcode.name = "lconst_0";
                        break;
                    }
                    case 10: {
                        opcode.name = "lconst_1";
                        break;
                    }
                    case 2: {
                        opcode.name = "iconst_m1";
                        break;
                    }
                    case 3: {
                        opcode.name = "iconst_0";
                        break;
                    }
                    case 4: {
                        opcode.name = "iconst_1";
                        break;
                    }
                    case 5: {
                        opcode.name = "iconst_2";
                        break;
                    }
                    case 6: {
                        opcode.name = "iconst_3";
                        break;
                    }
                    case 7: {
                        opcode.name = "iconst_4";
                        break;
                    }
                    case 8: {
                        opcode.name = "iconst_5";
                        break;
                    }
                    case 42: {
                        opcode.name = "aload_0";
                        break;
                    }
                    case 43: {
                        opcode.name = "aload_1";
                        break;
                    }
                    case 44: {
                        opcode.name = "aload_2";
                        break;
                    }
                    case 45: {
                        opcode.name = "aload_3";
                        break;
                    }
                    case 75: {
                        opcode.name = "astore_0";
                        break;
                    }
                    case 76: {
                        opcode.name = "astore_1";
                        break;
                    }
                    case 77: {
                        opcode.name = "astore_2";
                        break;
                    }
                    case 78: {
                        opcode.name = "astore_3";
                        break;
                    }
                    case 177: {
                        opcode.name = "return";
                        break;
                    }
                    case 176: {
                        opcode.name = "areturn";
                        break;
                    }
                    case 172: {
                        opcode.name = "ireturn";
                        break;
                    }
                    case 11: {
                        opcode.name = "fconst_0";
                        break;
                    }
                    case 12: {
                        opcode.name = "fconst_1";
                        break;
                    }
                    case 13: {
                        opcode.name = "fconst_2";
                        break;
                    }
                    case 167: {
                        opcode.name = "goto";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        opcodes[x].jumpsTo = index += x;
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 168: 
                    case 198: 
                    case 199: {
                        opcode.name = "generic if";
                        switch (opcodeID) {
                            case 168: {
                                opcodes[x].name = "jsr";
                                break;
                            }
                            case 153: {
                                opcodes[x].name = "ifeq";
                                break;
                            }
                            case 154: {
                                opcodes[x].name = "ifne";
                                break;
                            }
                            case 165: {
                                opcodes[x].name = "if_acmpeq";
                                break;
                            }
                            case 166: {
                                opcodes[x].name = "if_acmpne";
                                break;
                            }
                            case 159: {
                                opcodes[x].name = "if_icmpeq";
                                break;
                            }
                            case 162: {
                                opcodes[x].name = "if_icmpge";
                                break;
                            }
                            case 163: {
                                opcodes[x].name = "if_icmpgt";
                                break;
                            }
                            case 164: {
                                opcodes[x].name = "if_icmple";
                                break;
                            }
                            case 161: {
                                opcodes[x].name = "if_icmplt";
                                break;
                            }
                            case 160: {
                                opcodes[x].name = "if_icmpne";
                                break;
                            }
                            case 198: {
                                opcodes[x].name = "ifnull";
                                break;
                            }
                            case 199: {
                                opcodes[x].name = "ifnonnull";
                            }
                        }
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        opcodes[x].jumpsTo = index += x;
                        break;
                    }
                    case 194: {
                        opcode.name = "monitorenter";
                        break;
                    }
                    case 195: {
                        opcode.name = "monitorexit";
                        break;
                    }
                    case 191: {
                        opcode.name = "athrow";
                        break;
                    }
                    case 87: {
                        opcode.name = "pop";
                        break;
                    }
                    case 88: {
                        opcode.name = "pop2";
                        break;
                    }
                    case 145: {
                        opcode.name = "i2b";
                        break;
                    }
                    case 26: {
                        opcode.name = "iload_0";
                        break;
                    }
                    case 27: {
                        opcode.name = "iload_1";
                        break;
                    }
                    case 28: {
                        opcode.name = "iload_2";
                        break;
                    }
                    case 29: {
                        opcode.name = "iload_3";
                        break;
                    }
                    case 21: 
                    case 25: 
                    case 54: 
                    case 58: 
                    case 169: {
                        int index;
                        opcode.name = "generic X";
                        switch (opcodeID) {
                            case 169: {
                                opcodes[x].name = "ret";
                                break;
                            }
                            case 58: {
                                opcodes[x].name = "astore";
                                break;
                            }
                            case 25: {
                                opcodes[x].name = "aload";
                                break;
                            }
                            case 54: {
                                opcodes[x].name = "istore";
                                break;
                            }
                            case 21: {
                                opcodes[x].name = "iload";
                            }
                        }
                        if (lastWasWide) {
                            index = ClassPrinter.getShort(data, pos + 1 - start);
                            pos += 2;
                        } else {
                            index = ClassPrinter.getByte(data, pos + 1 - start);
                            ++pos;
                        }
                        opcodes[x].extraInfo = "#" + index;
                        break;
                    }
                    case 83: {
                        opcode.name = "aastore";
                        break;
                    }
                    case 84: {
                        opcode.name = "bastore";
                        break;
                    }
                    case 79: {
                        opcode.name = "iastore";
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        int index;
                        String string = opcode.name = opcodeID == 18 ? "ldc" : "ldc2_w";
                        if (opcodeID == 19) {
                            opcode.name = "ldc_w";
                        }
                        if (lastWasWide || opcodeID != 18) {
                            index = ClassPrinter.getShort(data, pos + 1 - start);
                            pos += 2;
                        } else {
                            index = ClassPrinter.getByte(data, pos + 1 - start);
                            ++pos;
                        }
                        PoolEntry entry = type.getPoolEntry(index);
                        if (opcodeID == 20 && type.getPoolEntry(index + 1) != entry) {
                            throw new ClassFormatError("Bad ldc2_w pointer: " + index);
                        }
                        if (entry instanceof StringPoolEntry) {
                            String string2 = type.getUTF8Entry(((StringPoolEntry)entry).index).toString();
                            if (string2.length() > 40) {
                                string2 = string2.substring(0, 38) + "...";
                            }
                            string2 = StringUtils.replace(string2, '\n', "\\n");
                            string2 = StringUtils.replace(string2, '\r', "\\r");
                            string2 = StringUtils.replace(string2, '\t', "\\t");
                            opcodes[x].extraInfo = '\"' + string2 + '\"';
                            break;
                        }
                        opcodes[x].extraInfo = entry.toString();
                        break;
                    }
                    case 180: {
                        opcode.name = "getfield";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        FieldPoolEntry entry = type.getFieldEntry(index);
                        ByteString classEntry = type.getClassEntry(entry.classDataIndex);
                        NameAndTypePoolEntry nameAndTypeEntry = type.getNameAndTypeEntry(entry.nameAndTypeIndex);
                        opcodes[x].extraInfo = classEntry + "." + type.getUTF8Entry(nameAndTypeEntry.nameIndex) + " (" + type.getUTF8Entry(nameAndTypeEntry.typeIndex) + ")";
                        break;
                    }
                    case 181: {
                        opcode.name = "putfield";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        FieldPoolEntry entry = type.getFieldEntry(index);
                        ByteString classEntry = type.getClassEntry(entry.classDataIndex);
                        NameAndTypePoolEntry nameAndTypeEntry = type.getNameAndTypeEntry(entry.nameAndTypeIndex);
                        opcodes[x].extraInfo = classEntry + "." + type.getUTF8Entry(nameAndTypeEntry.nameIndex) + " (" + type.getUTF8Entry(nameAndTypeEntry.typeIndex) + ")";
                        break;
                    }
                    case 178: {
                        opcode.name = "getstatic";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        FieldPoolEntry entry = type.getFieldEntry(index);
                        ByteString classEntry = type.getClassEntry(entry.classDataIndex);
                        NameAndTypePoolEntry nameAndTypeEntry = type.getNameAndTypeEntry(entry.nameAndTypeIndex);
                        opcodes[x].extraInfo = classEntry + "." + type.getUTF8Entry(nameAndTypeEntry.nameIndex) + " (" + type.getUTF8Entry(nameAndTypeEntry.typeIndex) + ")";
                        break;
                    }
                    case 179: {
                        opcode.name = "putstatic";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        FieldPoolEntry entry = type.getFieldEntry(index);
                        ByteString classEntry = type.getClassEntry(entry.classDataIndex);
                        NameAndTypePoolEntry nameAndTypeEntry = type.getNameAndTypeEntry(entry.nameAndTypeIndex);
                        opcodes[x].extraInfo = classEntry + "." + type.getUTF8Entry(nameAndTypeEntry.nameIndex) + " (" + type.getUTF8Entry(nameAndTypeEntry.typeIndex) + ")";
                        break;
                    }
                    case 193: {
                        opcode.name = "instanceof";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        ByteString classEntry = type.getClassEntry(index);
                        opcodes[x].extraInfo = classEntry.toString();
                        break;
                    }
                    case 189: {
                        opcode.name = "anewarray";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        ByteString classEntry = type.getClassEntry(index);
                        opcodes[x].extraInfo = classEntry.toString();
                        break;
                    }
                    case 187: {
                        opcode.name = "new";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        ByteString classEntry = type.getClassEntry(index);
                        opcodes[x].extraInfo = classEntry.toString();
                        break;
                    }
                    case 1: {
                        opcode.name = "aconst_null";
                        break;
                    }
                    case 192: {
                        opcode.name = "checkcast";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        ByteString classEntry = type.getClassEntry(index);
                        opcodes[x].extraInfo = classEntry.toString();
                        break;
                    }
                    case 183: {
                        opcode.name = "invokespecial";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        MethodPoolEntry method = type.getMethodEntry(index);
                        ByteString className = type.getClassEntry(method.classDataIndex);
                        NameAndTypePoolEntry nameAndType = type.getNameAndTypeEntry(method.nameAndTypeIndex);
                        opcodes[x].extraInfo = className + "." + type.getUTF8Entry(nameAndType.nameIndex) + type.getUTF8Entry(nameAndType.typeIndex);
                        break;
                    }
                    case 182: {
                        opcode.name = "invokevirtual";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        MethodPoolEntry method = type.getMethodEntry(index);
                        ByteString className = type.getClassEntry(method.classDataIndex);
                        NameAndTypePoolEntry nameAndType = type.getNameAndTypeEntry(method.nameAndTypeIndex);
                        opcodes[x].extraInfo = className + "." + type.getUTF8Entry(nameAndType.nameIndex) + type.getUTF8Entry(nameAndType.typeIndex);
                        break;
                    }
                    case 184: {
                        opcode.name = "invokestatic";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        pos += 2;
                        MethodPoolEntry method = type.getMethodEntry(index);
                        ByteString className = type.getClassEntry(method.classDataIndex);
                        NameAndTypePoolEntry nameAndType = type.getNameAndTypeEntry(method.nameAndTypeIndex);
                        opcodes[x].extraInfo = className + "." + type.getUTF8Entry(nameAndType.nameIndex) + type.getUTF8Entry(nameAndType.typeIndex);
                        break;
                    }
                    case 185: {
                        opcode.name = "invokeinterface";
                        int index = ClassPrinter.getShort(data, pos + 1 - start);
                        int count = ClassPrinter.getByte(data, (pos += 2) + 1);
                        pos += 2;
                        InterfaceMethodPoolEntry method = type.getInterfaceMethodEntry(index);
                        ByteString className = type.getClassEntry(method.classDataIndex);
                        NameAndTypePoolEntry nameAndType = type.getNameAndTypeEntry(method.nameAndTypeIndex);
                        opcodes[x].extraInfo = className + "." + type.getUTF8Entry(nameAndType.nameIndex) + type.getUTF8Entry(nameAndType.typeIndex) + " (count " + count + ")";
                        break;
                    }
                    case 89: {
                        opcode.name = "dup";
                        break;
                    }
                    case 0: {
                        opcode.name = "nop";
                        break;
                    }
                    case 17: {
                        opcode.name = "sipush";
                        opcodes[x].extraInfo = String.valueOf(ClassPrinter.getShort(data, pos + 1));
                        pos += 2;
                        break;
                    }
                    case 16: {
                        opcode.name = "sipush";
                        opcodes[x].extraInfo = String.valueOf(ClassPrinter.getByte(data, pos + 1));
                        ++pos;
                        break;
                    }
                    default: {
                        opcode.name = "************* Unsupported: " + Integer.toHexString((char)data[pos] & 0xFF);
                    }
                }
                if (opcodes[x] != null && lines != null) {
                    opcodes[x].sourceLine = lines.getLineNumber(pos);
                }
            }
            catch (Throwable t) {
                if (opcodes[x] == null) {
                    opcode.name = "error";
                }
                opcodes[x].extraInfo = t.toString();
            }
            ++pos;
        }
        int lastSourceLine = -1;
        for (int i = 0; i < opcodes.length; ++i) {
            if (opcodes[i] == null) continue;
            if (opcodes[i].sourceLine > 0 && lastSourceLine != opcodes[i].sourceLine) {
                lastSourceLine = opcodes[i].sourceLine;
                out.print(ClassPrinter.getPadded(opcodes[i].sourceLine) + " ");
            } else {
                out.print("     ");
            }
            out.print(ClassPrinter.getPadded(i) + " ");
            out.print(opcodes[i].name);
            if (opcodes[i].extraInfo != null) {
                out.print(" " + opcodes[i].extraInfo);
            }
            if (opcodes[i].jumpsTo != -1) {
                out.print(" -> " + opcodes[i].jumpsTo);
                if (opcodes[i].jumpsTo >= opcodes.length || opcodes[i].jumpsTo < 0 || opcodes[opcodes[i].jumpsTo] == null) {
                    out.print(" * INVALID JUMP TARGET *");
                }
            }
            out.println();
        }
    }

    public static String getPadded(int number) {
        if (number < 10) {
            return "   " + number;
        }
        if (number < 100) {
            return "  " + number;
        }
        if (number < 1000) {
            return " " + number;
        }
        return "" + number;
    }

    public static void printAttribute(ClassSerialization type, Attribute attribute, PrintWriter out) {
        if (attribute instanceof RawCodeAttribute) {
            RawCodeAttribute codeAttribute = (RawCodeAttribute)attribute;
            out.println("Code: Max locals: " + codeAttribute.maxLocals + ", Max stack: " + codeAttribute.maxStack);
            out.println("Code attributes:");
            if (codeAttribute.attributes != null) {
                ClassPrinter.printAttributes(type, codeAttribute.attributes, codeAttribute.attributes.length, out);
            }
            LineNumberTableAttribute lines = null;
            if (codeAttribute.attributes != null) {
                for (int i = 0; i < codeAttribute.attributes.length; ++i) {
                    if (!(codeAttribute.attributes[i] instanceof LineNumberTableAttribute)) continue;
                    lines = (LineNumberTableAttribute)codeAttribute.attributes[i];
                }
            }
            ClassPrinter.printCode(type, codeAttribute.code, out, lines);
        } else {
            out.println("Name: " + attribute.getName());
        }
    }

    public static void printMethods(ClassSerialization type, MethodData[] methods, int methodCount, PrintWriter out) {
        if (methods == null) {
            out.println("<none>");
        } else {
            for (int i = 0; i < methodCount; ++i) {
                ClassPrinter.printMethod(type, methods[i], out);
                out.println();
            }
        }
    }

    public static void printMethod(ClassSerialization type, MethodData method, PrintWriter out) {
        out.println("Name: " + method.name);
        out.println("Signature: " + method.descriptor);
        out.println("Attributes:");
        ClassPrinter.printAttributes(type, method.attributes, method.attributes.length, out);
    }

    public static void printFields(ClassSerialization type, FieldData[] fields, int fieldCount, PrintWriter out) {
        if (fields == null) {
            out.println("<none>");
        } else {
            for (int i = 0; i < fieldCount; ++i) {
                ClassPrinter.printField(type, fields[i], out);
                out.println();
            }
        }
    }

    public static void printField(ClassSerialization type, FieldData field, PrintWriter out) {
        out.println("Name: " + field.name);
        out.println("Type: " + field.descriptor);
        out.println("Attributes:");
        if (field.attributes != null) {
            ClassPrinter.printAttributes(type, field.attributes, field.attributes.length, out);
        }
    }
}

