/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.ClassFormatException;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.NameAndTypePoolEntry;
import com.evermind.bytecode.PoolEntry;
import com.evermind.bytecode.Verifier;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;

public class ClassPoolEntry
extends PoolEntry {
    public short classNameIndex;

    public ClassPoolEntry(short classNameIndex) {
        this.classNameIndex = classNameIndex;
    }

    public void write(InteractiveByteArrayOutputStream out) throws IOException {
        out.write(7);
        out.writeShort(this.classNameIndex);
    }

    public String toString() {
        return "class " + this.classNameIndex;
    }

    public void verify(ClassSerialization serialization) throws ClassFormatException {
        ByteString name = serialization.getUTF8Entry(this.classNameIndex);
        if (name.charAt(0) == '[') {
            int pos = NameAndTypePoolEntry.verifySignaturePart(name, 0, false);
            if (pos != name.length()) {
                throw new ClassFormatException("Trash at end of classname: " + name);
            }
        } else {
            for (int i = 0; i < name.length(); ++i) {
                if (Verifier.isValidEncodedIdentifier(name.charAt(i), i == 0)) continue;
                throw new ClassFormatException("Invalid classname: " + name);
            }
        }
    }
}

