/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public abstract class DirectoryWalker {
    protected String rootDir;
    private HashSet extensions = new HashSet();
    private FilenameFilter fileFilter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setRootDirectory(String dirName) {
        this.rootDir = dirName;
    }

    public String getRootDirectory() {
        return this.rootDir;
    }

    protected abstract void processFile(String var1, String var2, String var3, int var4) throws IOException;

    protected boolean processDir(String name, String fqName, String dirName, int depth) throws IOException {
        return true;
    }

    public void process() throws IOException, IllegalArgumentException {
        if (!$assertionsDisabled && this.rootDir == null) {
            throw new AssertionError();
        }
        this.walkDir(this.rootDir, 0);
    }

    public void addAcceptedExtension(String extension) {
        this.extensions.add(extension);
    }

    public void clearAcceptedExtensions() {
        this.extensions.clear();
    }

    public boolean removeAcceptedExtension(String extension) {
        return this.extensions.remove(extension);
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.fileFilter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this.fileFilter;
    }

    private void walkDir(String dirName, int depth) throws IOException {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory.");
        }
        if (!dir.canRead()) {
            return;
        }
        String[] files = dir.list();
        if (files == null) {
            throw new IllegalArgumentException("Unable to get file list for directory " + dirName);
        }
        block0: for (int i = 0; i < files.length; ++i) {
            String name = files[i];
            String fqName = dirName + File.separatorChar + name;
            File file = new File(fqName);
            if (file.isDirectory()) {
                if (!this.processDir(name, fqName, dirName, depth + 1)) continue;
                this.walkDir(fqName, depth + 1);
                continue;
            }
            if (this.fileFilter != null && !this.fileFilter.accept(dir, name)) continue;
            if (this.extensions.isEmpty()) {
                this.processFile(name, fqName, dirName, depth);
                continue;
            }
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                String extension = (String)iterator.next();
                if (!name.endsWith(extension)) continue;
                this.processFile(name, fqName, dirName, depth);
                continue block0;
            }
        }
    }

    static {
        $assertionsDisabled = !DirectoryWalker.class.desiredAssertionStatus();
    }
}

