/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import oracle.jsp.parse.DependencyFile;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.OracleJsp2Java;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspCompiler;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtimev2.JspPageCompiler;
import oracle.jsp.util.JspUtil;

public class TagFileCompiler {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    private OracleJsp2Java pageTranslator;
    private JspCompiler javaCompiler;
    private ServletConfig config;
    private String encoding;
    public static final String EXCLUDE_FILE_EXT_IN_CLASSNAME = "exclude_file_ext_in_classname";
    protected JspResourceProvider tagFileRepository;

    public TagFileCompiler() {
        this.pageTranslator = new OracleJsp2Java();
        this.encoding = "ISO-8859-1";
    }

    public TagFileCompiler(ServletConfig config, String appEncoding) {
        this.config = config;
        this.encoding = appEncoding == null ? "ISO-8859-1" : appEncoding;
        this.pageTranslator = new OracleJsp2Java();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compileTagFile(String tagFileName, String path, TagLibraryInfo tlib, JspParseState st, String jarName, boolean xmlStyleSrc) throws FileNotFoundException, IOException, IllegalAccessException, ServletException, JspParseException, JspEncodingException, JspCompileException {
        int language = 0;
        int length = path.length();
        if (path == null || length == 0) {
            return;
        }
        String tagHandlerClassName = JspUtil.getTagHandlerClassName(path);
        String fullClassName = JspUtil.getFullClassNameFromURL(tagHandlerClassName);
        String className = JspUtil.getClassNameFromURL(tagHandlerClassName);
        String packageName = fullClassName.substring(0, fullClassName.length() - className.length());
        packageName = packageName.length() == 0 ? packageName : packageName.substring(0, packageName.length() - 1);
        String javaClassFilePath = JspUtil.encodeToJavaIdentifier(JspUtil.stripTarget(tagHandlerClassName).toLowerCase(), '/') + "/" + className + ".class";
        String auxFileName = JspUtil.replaceTargetExtension(javaClassFilePath, ".jpa");
        Jsp2JavaParms parmNames = null;
        CharArrayWriter caWriter = null;
        String newEncoding = null;
        while (true) {
            try {
                PrintWriter writeS;
                block23: {
                    parmNames = (Jsp2JavaParms)st.parms.clone();
                    parmNames.packageName = packageName;
                    parmNames.className = className;
                    parmNames.pagePath = JspUtil.stripTarget(path) + "/";
                    parmNames.extend = "javax.servlet.jsp.tagext.SimpleTagSupport";
                    parmNames.staticTextInBytes = false;
                    parmNames.sourceFileName = path;
                    parmNames.xmlStyleSrc = xmlStyleSrc;
                    parmNames.tagFileName = tagFileName;
                    parmNames.tlib = tlib;
                    parmNames.tagClassName = fullClassName;
                    parmNames.jarName = jarName;
                    if (parmNames.currentTagFileStack == null) {
                        parmNames.currentTagFileStack = new Stack();
                    }
                    parmNames.isXML = null;
                    parmNames.elIgnored = false;
                    parmNames.scriptingInvalid = false;
                    parmNames.includePrelude = new ArrayList();
                    parmNames.includeCoda = new ArrayList();
                    this.encoding = xmlStyleSrc ? "UTF-8" : (newEncoding == null ? this.encoding : newEncoding);
                    parmNames.encoding = this.encoding;
                    InputStreamReader readS = null;
                    if (!xmlStyleSrc) {
                        readS = this.fromReader(st.parms.resourceProvider, path, this.encoding, null, jarName);
                    }
                    caWriter = new CharArrayWriter();
                    writeS = new PrintWriter(caWriter);
                    try {
                        parmNames.currentTagFileStack.push(parmNames.jarName == null ? parmNames.sourceFileName : parmNames.jarName + parmNames.sourceFileName);
                        language = this.pageTranslator.transform(parmNames, readS, (Writer)writeS, null, 2);
                        parmNames.currentTagFileStack.pop();
                        Object var22_21 = null;
                        if (readS == null) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var22_22 = null;
                        if (readS != null) {
                            readS.close();
                        }
                        if (writeS != null) {
                            writeS.close();
                        }
                        throw throwable;
                    }
                    readS.close();
                }
                if (writeS == null) break;
                writeS.close();
            }
            catch (JspEncodingException e) {
                newEncoding = e.getSpecifiedEncoding();
                continue;
            }
            break;
        }
        String javaPage = JspUtil.replaceTargetExtension(javaClassFilePath, ".java");
        String jdkEncoding = JspUtil.convIANAtoJavaEncoding(this.encoding, true);
        if (jdkEncoding == null) {
            throw new IOException(MessageFormat.format(msgs.getString("bad_page_encoding"), this.encoding, path));
        }
        PrintWriter srcFileWriter = st.parms.tagFileRepository.toPrintWriter(javaPage, jdkEncoding);
        try {
            srcFileWriter.write(caWriter.toCharArray());
        }
        finally {
            srcFileWriter.close();
        }
        OutputStream auxOut = st.parms.tagFileRepository.toStream(auxFileName);
        ObjectOutputStream oos = new ObjectOutputStream(auxOut);
        try {
            oos.writeObject(parmNames.auxObj);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        long modified = st.parms.javaCompiler.compile(javaPage, language, jdkEncoding, st.parms.tagFileRepository, st.parms.resourceProvider, parmNames);
        DependencyFile[] dependentFiles = parmNames.auxObj.dependentFiles;
        int i = 0;
        while (true) {
            if (i >= dependentFiles.length) {
                JspPageCompiler.addSMAP(parmNames.gensmap, parmNames.className, javaClassFilePath, parmNames.tagFileRepository, parmNames.lineMap);
                return;
            }
            if (!dependentFiles[i].fileName.equals("oracle_partially_parsed_file_marker")) {
                st.dependencies.addIncludedFile(dependentFiles[i].fileName, dependentFiles[i].lastModified);
            }
            ++i;
        }
    }

    private InputStreamReader fromReader(JspResourceProvider rp, String resource, String enc, HttpServletRequest req, String jarName) throws FileNotFoundException, IOException {
        if (jarName == null) {
            return rp.fromReader(resource, enc);
        }
        return this.fromReader(XMLUtil.getTagFileFromJarFile(rp, resource, jarName), enc);
    }

    private InputStreamReader fromReader(InputStream resource, String enc) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (enc != null) {
            return new InputStreamReader(resource, enc);
        }
        return new InputStreamReader(resource);
    }

    public TagInfo getTagInfoValue() {
        if (this.pageTranslator != null) {
            return this.pageTranslator.getTagInfo();
        }
        return null;
    }
}

