/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.JspInterface;
import com.evermind.server.http.deployment.OjspInitDescriptor;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.parse.tldcache.ApplicationTldCacheImpl;
import oracle.jsp.parse.tldcache.GlobalTldCacheImpl;
import oracle.jsp.parse.tldcache.TldCache;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtime.JspAnnotatedTagsMgr;
import oracle.jsp.runtime.JspAnnotationFactory;
import oracle.jsp.runtimev2.JspPageTable;
import oracle.jsp.runtimev2.JspReportUtil;
import oracle.jsp.util.JspVersion;

public class JspServlet
extends HttpServlet
implements JspInterface {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    public static final String DEFAULT_PAGE_PATH = "/_pages";
    public static final String DEFAULT_TAG_PATH = "/_tagfiles";
    public static final String PAGE_REPOSITORY = "page_repository";
    public static final String PAGE_REPOSITORY_ROOT = "page_repository_root";
    public static final String TAGFILE_REPOSITORY_ROOT = "tagfile_repository_root";
    public static final String DEFAULT_PAGE_REPOSITORY = "oracle.jsp.provider.JspFilesystemResource";
    public static final String PAGE_PROVIDER_ROOT = "page_provider_root";
    public static final String PAGE_PROVIDER = "page_provider";
    public static final String DEFAULT_PAGE_PROVIDER = "oracle.jsp.provider.JspFSServletContextResource";
    public static final String MAIN_MODE_PARAM = "main_mode";
    public static final String GENERIC_SERVLET_MODE = "generic_servlet_mode";
    public static final String[] MAIN_MODE_VALUES = new String[]{"recompile", "reload", "justrun"};
    public static final String[] GENERIC_SERVLET_VALUES = new String[]{"shared", "single", "none"};
    private static final int MAIN_MODE_UNDEFINED = -1;
    private static final int MAIN_MODE_RECOMPILE = 0;
    private static final int MAIN_MODE_RELOAD = 1;
    private static final int MAIN_MODE_JUSTRUN = 2;
    private int mode = -1;
    private int gen_mode = -1;
    private static final int GENERIC_SERVLET_SHARED = 0;
    private static final int GENERIC_SERVLET_SINGLE = 1;
    private static final int GENERIC_SERVLET_NONE = 2;
    public static final String FACTORY_CLASS_NAME_PARAM = "page_factory";
    public static final String ORION_FACTORY_CLASS_NAME = "com.evermind.server.http.EvermindJSPFactory";
    public static final String OJSP_FACTORY_CLASS_NAME = "oracle.jsp.runtime.OracleJspFactory";
    public static final String TAGS_REUSE_DEFAULT_PARAM = "tags_reuse_default";
    public static final String TAGS_REUSE_DEFAULT_ATTR_NAME = "oracle.jsp.tags.reuse.default";
    public static final String TIMESTAMP_CACHE_DELAY_PARAM = "timestamp_cache_delay";
    public static final String CHECK_PAGE_SCOPE_PARAM = "check_page_scope";
    public static final String CHECK_PAGE_SCOPE_ATTR_NAME = "oracle.jsp.check.page.scope";
    public static final String ANNOTATED_TAGS_MGR = "oracle.jsp.annotation.mgr";
    public static final String DEBUG_PARAM = "debug_mode";
    public static final String CHECK_PRECOMPILE_PARAM = "precompile_check";
    protected HttpApplication happ = null;
    private boolean defaultProvider = false;
    private boolean requestURINeedToBeChecked = false;
    private TldCache tldCache;
    public static boolean DMS_GATE;
    private NounIntf parentNoun;
    private PhaseEventIntf processJspRequestPhase;
    private boolean OJSP_DMS_INIT = false;
    private ServletConfig config;
    private ServletContext sc;
    private String pageClassRepoRoot;
    private String tagFileRepoRoot;
    private Class pageRepositoryClass;
    private Class pageProviderClass;
    private JspResourceProvider pageProvider;
    private JspPageTable pageTable;
    private long cacheDelay = 1000L;
    private boolean debugMode = false;
    private boolean checkPrecompile = false;
    private Vector extraImports = null;

    public void init(ServletConfig config) throws ServletException {
        String cn;
        Class selectedFactoryClass;
        super.init(config);
        this.config = config;
        this.sc = config.getServletContext();
        this.sc.setAttribute("oracle.jsp.versionNumber", (Object)"Oracle Containers for J2EE 10g (10.1.3.4.0)");
        String factoryClassName = config.getInitParameter(FACTORY_CLASS_NAME_PARAM);
        if (factoryClassName == null) {
            factoryClassName = ORION_FACTORY_CLASS_NAME;
        }
        try {
            selectedFactoryClass = JspServlet.loadClass(factoryClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServletException(cnfe.toString());
        }
        try {
            JspFactory f = (JspFactory)selectedFactoryClass.newInstance();
            if (JspFactory.getDefaultFactory() == null) {
                JspFactory.setDefaultFactory((JspFactory)f);
            }
        }
        catch (Exception e) {
            throw new ServletException(e.toString());
        }
        String modeStr = config.getInitParameter(MAIN_MODE_PARAM);
        if (modeStr != null) {
            this.validateAndSetMainMode(modeStr);
        } else {
            this.mode = 0;
        }
        String genServletStr = config.getInitParameter(GENERIC_SERVLET_MODE);
        if (genServletStr != null) {
            int i;
            genServletStr = genServletStr.trim();
            for (i = 0; i < GENERIC_SERVLET_VALUES.length && !genServletStr.equals(GENERIC_SERVLET_VALUES[i]); ++i) {
            }
            if (i != GENERIC_SERVLET_VALUES.length) {
                this.gen_mode = i;
            }
        } else {
            this.gen_mode = -1;
        }
        if (JspVersion.getServletVersion(this.sc) == 1) {
            String msg = "Must be servlet 2.1 or above";
            this.sc.log(msg);
            throw new ServletException(msg);
        }
        if (JspVersion.getServletVersion(this.sc) > 1) {
            this.sc.setAttribute("oracle.jsp.versionNumber", (Object)"Oracle Containers for J2EE 10g (10.1.3.4.0)");
        }
        if ((cn = config.getInitParameter(PAGE_REPOSITORY)) == null) {
            cn = DEFAULT_PAGE_REPOSITORY;
        }
        try {
            this.pageRepositoryClass = JspServlet.loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(e.toString());
        }
        if (this.sc instanceof HttpApplication) {
            this.happ = (HttpApplication)this.sc;
        } else {
            try {
                this.happ = (HttpApplication)ThreadState.getCurrentState().contextContainer;
            }
            catch (Throwable e) {
                JspMessages.logWarning("Unable to retrieve HttpApp object through ThreadState too");
            }
        }
        if (this.happ != null) {
            this.requestURINeedToBeChecked = this.happ.getConfig().isJspPropertyGroupDefined() || !this.happ.getConfig().getSimpleJspMapping();
        }
        String path = config.getInitParameter(PAGE_REPOSITORY_ROOT);
        String tagfilepath = config.getInitParameter(TAGFILE_REPOSITORY_ROOT);
        if (path == null || tagfilepath == null) {
            File workDir = null;
            if (this.happ != null && workDir == null) {
                workDir = this.happ.getJSPCacheFile();
            }
            if (workDir == null) {
                workDir = (File)this.sc.getAttribute("javax.servlet.context.tempdir");
            }
            if (workDir != null) {
                try {
                    String canonicalPath = workDir.getCanonicalPath();
                    if (tagfilepath == null) {
                        tagfilepath = canonicalPath + DEFAULT_TAG_PATH.replace('/', File.separatorChar);
                    }
                    if (path == null) {
                        path = canonicalPath + DEFAULT_PAGE_PATH.replace('/', File.separatorChar);
                    }
                }
                catch (IOException e) {
                    throw new ServletException(e.toString());
                }
            }
        }
        this.pageClassRepoRoot = path;
        this.tagFileRepoRoot = tagfilepath;
        cn = config.getInitParameter(TAGS_REUSE_DEFAULT_PARAM);
        if (cn != null && cn.equalsIgnoreCase("runtime")) {
            this.sc.setAttribute(TAGS_REUSE_DEFAULT_ATTR_NAME, (Object)cn);
        }
        if ((cn = config.getInitParameter(TIMESTAMP_CACHE_DELAY_PARAM)) != null) {
            this.cacheDelay = Integer.parseInt(cn);
        }
        if ((cn = config.getInitParameter(CHECK_PAGE_SCOPE_PARAM)) != null && cn.equalsIgnoreCase("true")) {
            this.sc.setAttribute(CHECK_PAGE_SCOPE_ATTR_NAME, (Object)cn);
        }
        if ((cn = config.getInitParameter(DEBUG_PARAM)) != null) {
            this.debugMode = Boolean.valueOf(cn);
        }
        if ((cn = config.getInitParameter(CHECK_PRECOMPILE_PARAM)) != null) {
            this.checkPrecompile = Boolean.valueOf(cn);
        }
        if (this.happ != null) {
            this.applyOjspInitValues(this.happ.getConfig().getOjspInitDescriptor());
        }
        if ((cn = config.getInitParameter(PAGE_PROVIDER)) == null) {
            cn = DEFAULT_PAGE_PROVIDER;
            this.defaultProvider = true;
        }
        if (this.mode == 0 || !this.defaultProvider) {
            try {
                this.pageProviderClass = JspServlet.loadClass(cn);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException(e.toString());
            }
        }
        if (this.defaultProvider) {
            this.initPageTable(null);
        }
        if (!this.OJSP_DMS_INIT && DMS_GATE) {
            this.initializeDMS();
        }
        this.scanAnnotations(this.happ);
    }

    private void scanAnnotations(HttpApplication hApp) {
        if (hApp == null || !hApp.processAnnotations()) {
            return;
        }
        try {
            JspAnnotatedTagsMgr annotationMgr = JspAnnotationFactory.getAnnotatedTagsMgr();
            if (annotationMgr == null) {
                throw new JspException("InternalError: Null anotationMgr.");
            }
            annotationMgr.scanForAnnotatedTags(hApp);
            this.getServletContext().setAttribute(ANNOTATED_TAGS_MGR, (Object)annotationMgr);
        }
        catch (Exception e) {
            JspMessages.warningAnnotationScanningFailure(e);
        }
    }

    private void validateAndSetMainMode(String modeStr) throws ServletException {
        int i;
        if (modeStr == null) {
            this.mode = 0;
            return;
        }
        modeStr = modeStr.trim();
        for (i = 0; i < MAIN_MODE_VALUES.length && !modeStr.equals(MAIN_MODE_VALUES[i]); ++i) {
        }
        if (i == MAIN_MODE_VALUES.length) {
            ServletException se = new ServletException(MessageFormat.format(msgs.getString("undefined_main_mode"), modeStr));
            JspMessages.warningInvalidMainModeValue(modeStr, se);
            throw se;
        }
        this.mode = i;
    }

    private void applyOjspInitValues(OjspInitDescriptor ojspInit) throws ServletException {
        if (ojspInit == null) {
            return;
        }
        String val = ojspInit.getMainMode();
        this.validateAndSetMainMode(val);
        val = ojspInit.getPrecompileCheck();
        this.checkPrecompile = val != null ? Boolean.valueOf(val) : false;
        val = ojspInit.getDebugMode();
        this.debugMode = val != null ? Boolean.valueOf(val) : false;
        val = ojspInit.getTagsReuse();
        if (val != null && val.equals("RUNTIME")) {
            this.sc.setAttribute(TAGS_REUSE_DEFAULT_ATTR_NAME, (Object)val);
        }
    }

    private synchronized void initializeDMS() {
        if (this.happ != null) {
            NounIntf contextNoun = this.happ.getNoun();
            this.createParentNoun(contextNoun);
            this.createProcessJspPhaseEvent();
            this.sc.setAttribute("dms.JSP_PARENT_NOUN", (Object)this.parentNoun);
            this.OJSP_DMS_INIT = true;
        } else {
            DMS_GATE = false;
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.internalService(request, response);
        }
        catch (Throwable th) {
            if (th instanceof ServletException) {
                throw (ServletException)th;
            }
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            JspReportUtil.reportException(th, this, request, response, this.getServletContext(), this.debugMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void internalService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.OJSP_DMS_INIT && DMS_GATE) {
            this.initializeDMS();
        }
        long processJspTok = 0L;
        try {
            String servletpath;
            if (DMS_GATE) {
                processJspTok = ApplicationServer.phaseEventFactory().getToken();
                if (this.processJspRequestPhase != null) {
                    processJspTok = this.processJspRequestPhase.start();
                }
            }
            if (!this.defaultProvider) {
                this.prepareTable(request);
            }
            if (request instanceof EvermindHttpServletRequest) {
                EvermindHttpServletRequest e_req = (EvermindHttpServletRequest)request;
                servletpath = this.requestURINeedToBeChecked ? JspPageTable.getRequestURI(e_req) : JspPageTable.getServletPath(e_req);
            } else {
                servletpath = JspPageTable.getServletPath(request);
            }
            if (this.happ != null && !this.happ.isLegalFileSystemPath(servletpath, false)) {
                throw new FileNotFoundException();
            }
            this.pageTable.service(request, response, servletpath);
            Object var8_6 = null;
            if (!DMS_GATE) return;
            if (this.processJspRequestPhase == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!DMS_GATE || this.processJspRequestPhase == null) throw throwable;
            this.processJspRequestPhase.stop(processJspTok);
            throw throwable;
        }
        this.processJspRequestPhase.stop(processJspTok);
    }

    public void destroy() {
        if (this.pageTable != null) {
            this.pageTable.destroy();
            this.pageTable = null;
        }
    }

    private void initPageTable(HttpServletRequest request) throws ServletException {
        try {
            if (this.pageProvider == null && this.pageProviderClass != null) {
                ServletContext sc = this.getServletContext();
                String contextPath = null;
                if (this.happ != null) {
                    contextPath = this.happ.getContextPath();
                }
                this.pageProvider = (JspResourceProvider)this.pageProviderClass.newInstance();
                this.pageProvider.init(this.config.getInitParameter(PAGE_PROVIDER_ROOT), contextPath, "/", sc, request, JspServlet.readProperties(this.config));
            }
            if (this.pageTable == null) {
                File f = new File(this.pageClassRepoRoot);
                f.mkdirs();
                ServletContext sc = this.getServletContext();
                int jspTimeout = 0;
                if (this.happ != null) {
                    jspTimeout = this.happ.getConfig().getJSPTimeout();
                    if (this.tldCache == null) {
                        this.tldCache = (TldCache)this.happ.getConfig().getTldCache();
                    }
                }
                this.pageTable = new JspPageTable(this.config, this, this.pageProvider, this.pageClassRepoRoot, this.tagFileRepoRoot, this.mode == 2, jspTimeout, this.tldCache);
                this.pageTable.jsfShortCut = this.gen_mode == 0 || this.gen_mode == 1;
                this.pageTable.jsfSharedInst = this.gen_mode == 0;
                this.pageTable.checkClassReload = this.mode == 0 || this.mode == 1;
                this.pageTable.checkPageRecompile = this.mode == 0;
                this.pageTable.pageRepositoryClass = this.pageRepositoryClass;
                this.pageTable.pageClassRepoRoot = this.pageClassRepoRoot;
                this.pageTable.tagFileRepoRoot = this.tagFileRepoRoot;
                this.pageTable.cacheDelay = this.cacheDelay;
                this.pageTable.checkPrecompile = this.checkPrecompile;
                this.pageTable.debugMode = this.debugMode;
                this.pageTable.defaultProvider = this.defaultProvider;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private synchronized void prepareTable(HttpServletRequest request) throws ServletException {
        this.initPageTable(request);
    }

    protected static Hashtable readProperties(ServletConfig config) throws ServletException {
        Hashtable<String, String> h = new Hashtable<String, String>();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            h.put(s.toLowerCase(), config.getInitParameter(s));
        }
        return h;
    }

    private void createParentNoun(NounIntf contextNoun) {
        if (this.parentNoun == null) {
            try {
                this.parentNoun = ApplicationServer.nounFactory().create(contextNoun, "JSPs", "oc4j_jspExec");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void createProcessJspPhaseEvent() {
        if (this.processJspRequestPhase == null) {
            try {
                this.processJspRequestPhase = ApplicationServer.phaseEventFactory().create(this.parentNoun, "processRequest", "oc4j_jspExec");
                this.processJspRequestPhase.deriveMetric(511);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String handleErrorStack(Throwable th) {
        if (this.pageTable == null) {
            if (th == null) {
                return null;
            }
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            th.printStackTrace(pw);
            String s = caw.toString();
            return s;
        }
        return this.pageTable.handleErrorStack(th);
    }

    public String insertJspLineInfo(String s) {
        if (this.pageTable == null) {
            return s;
        }
        return this.pageTable.insertJspLineInfo(s);
    }

    public Class getJspClass(HttpServletRequest request, String servletpath) throws ServletException, ClassNotFoundException, IOException {
        if (!this.defaultProvider) {
            this.prepareTable(request);
        }
        return this.pageTable.getJspClass(request, servletpath);
    }

    public boolean isJspPageExists(String servletpath) throws ServletException {
        if (!this.defaultProvider) {
            this.prepareTable(null);
        }
        return this.pageTable.isPageInfoExists(servletpath);
    }

    public File getJspClassFile(HttpServletRequest request, String servletpath) throws ServletException, ClassNotFoundException, IOException {
        Class k = this.getJspClass(request, servletpath);
        String className = k.getClass().getName();
        String fileName = className.replace('.', File.separatorChar) + ".class";
        File f = new File(this.pageClassRepoRoot + File.separatorChar + fileName);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static Class loadClass(String s) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(s);
        }
        catch (Throwable th) {
            return Class.forName(s);
        }
    }

    public Object newApplicationCache(String realPath, ClassLoader loader, URL jspCacheDir, int verbosity, int searchLevel) throws IOException, InterruptedException, MalformedURLException {
        return new ApplicationTldCacheImpl(realPath, loader, jspCacheDir, verbosity, searchLevel);
    }

    public List getTldListeners(Object cache) throws IOException {
        if (cache == null) {
            return new ArrayList();
        }
        return ((TldCache)cache).getTldListeners();
    }

    public Object getGlobalTldCacheInstance(String realPath, ClassLoader loader, int verbosity, String globalResources, String globalCacheLocBase, int searchLevel) throws IOException, InterruptedException, MalformedURLException {
        return GlobalTldCacheImpl.getInstance(realPath, loader, verbosity, globalResources, globalCacheLocBase, searchLevel);
    }

    public List getJspTaglibListeners(String realPath, ClassLoader loader, Map tagClassMap) {
        return XMLUtil.getJspTaglibListeners(realPath, loader, null, tagClassMap);
    }

    public Map getTagClassMap() {
        if (this.tldCache == null && this.happ == null) {
            return null;
        }
        if (this.tldCache == null) {
            this.tldCache = (TldCache)this.happ.getConfig().getTldCache();
        }
        return this.tldCache == null ? null : this.tldCache.getTagClassMap();
    }

    static {
        try {
            DMS_GATE = ApplicationServer.DMS_GATE;
        }
        catch (Throwable th) {
            DMS_GATE = false;
        }
    }
}

