/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import com.evermind.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.runtimev2.JspServlet;

public class JspReportUtil {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");

    public static String markupEncode(String exceptionString) {
        if (exceptionString.indexOf(60) >= 0) {
            exceptionString = StringUtils.replace((String)exceptionString, (char)'<', (String)"&lt;");
        }
        if (exceptionString.indexOf(62) >= 0) {
            exceptionString = StringUtils.replace((String)exceptionString, (char)'>', (String)"&gt;");
        }
        if (exceptionString.indexOf(10) >= 0) {
            exceptionString = StringUtils.replace((String)exceptionString, (char)'\n', (String)"<br>");
        }
        return exceptionString;
    }

    public static String simpleMarkupEncode(String exceptionString) {
        if (exceptionString.indexOf(60) >= 0) {
            exceptionString = StringUtils.replace((String)exceptionString, (char)'<', (String)"&lt;");
        }
        if (exceptionString.indexOf(62) >= 0) {
            exceptionString = StringUtils.replace((String)exceptionString, (char)'>', (String)"&gt;");
        }
        return exceptionString;
    }

    public static void sendError(boolean isDebug, HttpServletResponse response, ServletContext sc, int status, String msg) {
        JspReportUtil.sendError(response, sc, status, isDebug ? msg : msgs.getString("oraJspHdr") + "\n" + msgs.getString("set_debug_mode"));
    }

    public static void sendError(HttpServletResponse response, ServletContext sc, int status, String msg) {
        if (response.isCommitted()) {
            try {
                PrintWriter pw = response.getWriter();
                pw.write(msg);
                pw.close();
            }
            catch (Throwable th) {
                try {
                    ServletOutputStream os = response.getOutputStream();
                    byte[] b = null;
                    try {
                        b = msg.getBytes(response.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException uee) {
                        b = msg.getBytes();
                    }
                    os.write(b);
                    os.close();
                }
                catch (Throwable th2) {
                    JspMessages.warningErrorWritingFailed(msg, th);
                    sc.log(msg);
                }
            }
        } else {
            try {
                response.sendError(status, msg);
            }
            catch (Throwable th) {
                JspMessages.warningSendErrorFailed(status, msg, th);
                sc.log(msg);
            }
        }
    }

    public static void reportException(Throwable t, JspServlet jspServlet, HttpServletRequest request, HttpServletResponse response, ServletContext sc, boolean debug) {
        if (msgs == null) {
            JspMessages.infoResourceFileNotFound(MSG_FILE);
        }
        JspReportUtil.logException(msgs.getString("cannot_dispatch_page"), t, sc, debug);
        if (t instanceof JspParseException) {
            JspReportUtil.sendError(debug, response, sc, 500, JspReportUtil.formatException(msgs.getString("oraJspHdr") + JspReportUtil.markupEncode(t.toString()), request));
        } else if (t instanceof JspCompileException) {
            JspReportUtil.sendError(debug, response, sc, 500, JspReportUtil.formatException(msgs.getString("oraJspHdr") + t.toString(), request));
        } else if (t instanceof FileNotFoundException) {
            try {
                response.setContentType("text/html;charset=UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            JspReportUtil.sendError(debug, response, sc, 404, JspReportUtil.formatException(msgs.getString("oraJspHdr") + JspReportUtil.markupEncode(t.toString()), request));
        } else {
            JspReportUtil.sendError(debug, response, sc, 500, msgs.getString("oraJspHdr") + "\n" + JspReportUtil.formatException(JspReportUtil.simpleMarkupEncode(jspServlet.handleErrorStack(t)), request));
        }
    }

    private static String formatException(String message, HttpServletRequest request) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("<HTML><BODY>");
        out.println("<P> <H2  ALIGN=CENTER>" + msgs.getString("jspError_hdr") + "</H2> <HR  ALIGN=CENTER> <P>");
        out.println("<P><H3>" + msgs.getString("requestURI_hdr") + request.getRequestURI() + "</H3><P>");
        out.println("<H3>" + msgs.getString("exception_hdr") + "</H3>" + message);
        out.println("<P><P><HR ALIGN=CENTER>");
        out.println("</HTML></BODY>");
        out.close();
        return sw.toString();
    }

    private static void logException(String msg, Throwable t, ServletContext sc, boolean debug) {
        if (debug) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            sc.log(msg + sw.toString());
            JspMessages.infoCannotDispatchJspPage(sw.toString());
        } else {
            sc.log(msg + msgs.getString("exception_hdr") + t.toString());
            JspMessages.infoCannotDispatchJspPage(msgs.getString("exception_hdr") + t.toString());
            JspMessages.logFineStackTrace(t);
        }
    }
}

