/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.VersionNumber;

public class JspClassLoader
extends PolicyClassLoader {
    protected Map classMap;

    public JspClassLoader(String name, VersionNumber version, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy, SearchPolicy searchPolicy, ProtectionPolicy protectionPolicy) {
        super(name, version, parent, origin, configurationPolicy, searchPolicy, protectionPolicy);
        this.init();
    }

    public JspClassLoader(PolicyClassLoader source, boolean closeSource, boolean commit) {
        super(source, closeSource, commit);
        this.init();
    }

    private void init() {
        this.classMap = new HashMap();
    }

    protected Class defineClass(String name, byte[] data, int offset, int length, SharedCodeSource source, ProtectionPolicy permissions, Certificate[] certificates, SearchMetrics metrics) {
        Class clazz = super.defineClass(name, data, offset, length, source, permissions, certificates, metrics);
        String relativePath = name.replace('.', '/') + ".class";
        try {
            File file = source.getFile(relativePath);
            if (file != null) {
                this.classMap.put(name, new ClassMapEntry(name, file, file.lastModified()));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return clazz;
    }

    public PolicyClassLoader copy(boolean closeThis, boolean commitCopy) {
        return new JspClassLoader(this, closeThis, commitCopy);
    }

    public synchronized boolean shouldReload(String className) {
        ClassMapEntry entry = (ClassMapEntry)this.classMap.get(className);
        if (entry == null) {
            return false;
        }
        return entry.file.lastModified() > entry.lastModified;
    }

    public synchronized boolean entryExists(String className) {
        ClassMapEntry entry = (ClassMapEntry)this.classMap.get(className);
        return entry != null;
    }

    public synchronized JspClassLoader reinstantiate() {
        return (JspClassLoader)this.copy(false, true);
    }

    protected static class ClassMapEntry {
        String className;
        File file;
        long lastModified;

        public ClassMapEntry(String className, File file, long lastModified) {
            this.className = className;
            this.file = file;
            this.lastModified = lastModified;
        }
    }
}

