/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;

public class OracleJspContextWrapper
extends PageContext {
    private PageContext invokingJspCtx;
    private HashMap pageAttributes = new HashMap();
    private ArrayList atBeginVars;
    private Hashtable origNestedVars;
    private ArrayList nestedVars;
    private ArrayList atEndVars;
    private HashMap aliasVars;

    public OracleJspContextWrapper(JspContext jspCtx, ArrayList atBeginVars, ArrayList atEndVars, ArrayList nestedVars, HashMap aliasVars) {
        this.invokingJspCtx = (PageContext)jspCtx;
        this.atBeginVars = atBeginVars;
        this.nestedVars = nestedVars;
        this.aliasVars = aliasVars;
        if (nestedVars != null) {
            this.origNestedVars = new Hashtable(nestedVars.size());
        }
        this.atEndVars = atEndVars;
        this.syncVariableBeginTagFile();
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
    }

    public Object getAttribute(String name) {
        return this.pageAttributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 1) {
            return this.pageAttributes.get(name);
        }
        return this.invokingJspCtx.getAttribute(name, scope);
    }

    public void setAttribute(String name, Object attribute) {
        this.pageAttributes.put(name, attribute);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 1) {
            this.pageAttributes.put(name, value);
        } else {
            this.invokingJspCtx.setAttribute(name, value, scope);
        }
    }

    public Object findAttribute(String name) {
        Object value = this.pageAttributes.get(name);
        if (value == null && (value = this.invokingJspCtx.getAttribute(name, 2)) == null) {
            if (this.getSession() != null) {
                value = this.invokingJspCtx.getAttribute(name, 3);
            }
            if (value == null) {
                value = this.invokingJspCtx.getAttribute(name, 4);
            }
        }
        return value;
    }

    public void removeAttribute(String name) {
        this.pageAttributes.remove(name);
        this.invokingJspCtx.removeAttribute(name, 2);
        if (this.getSession() != null) {
            this.invokingJspCtx.removeAttribute(name, 3);
        }
        this.invokingJspCtx.removeAttribute(name, 4);
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 1) {
            this.pageAttributes.remove(name);
        } else {
            this.invokingJspCtx.removeAttribute(name, scope);
        }
    }

    public int getAttributesScope(String name) {
        if (this.pageAttributes.get(name) != null) {
            return 1;
        }
        return this.invokingJspCtx.getAttributesScope(name);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return Collections.enumeration(this.pageAttributes.keySet());
        }
        return this.invokingJspCtx.getAttributeNamesInScope(scope);
    }

    public void release() {
        this.invokingJspCtx.release();
    }

    public JspWriter getOut() {
        return this.invokingJspCtx.getOut();
    }

    public HttpSession getSession() {
        return this.invokingJspCtx.getSession();
    }

    public Object getPage() {
        return this.invokingJspCtx.getPage();
    }

    public ServletRequest getRequest() {
        return this.invokingJspCtx.getRequest();
    }

    public ServletResponse getResponse() {
        return this.invokingJspCtx.getResponse();
    }

    public Exception getException() {
        return this.invokingJspCtx.getException();
    }

    public ServletConfig getServletConfig() {
        return this.invokingJspCtx.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.invokingJspCtx.getServletContext();
    }

    public void forward(String path) throws ServletException, IOException {
        this.invokingJspCtx.forward(path);
    }

    public void include(String path) throws ServletException, IOException {
        this.invokingJspCtx.include(path);
    }

    public void include(String path, boolean flush) throws ServletException, IOException {
        this.invokingJspCtx.include(path, false);
    }

    public BodyContent pushBody() {
        return this.invokingJspCtx.pushBody();
    }

    public JspWriter pushBody(Writer writer) {
        return this.invokingJspCtx.pushBody(writer);
    }

    public JspWriter popBody() {
        return this.invokingJspCtx.popBody();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.invokingJspCtx.getExpressionEvaluator();
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.invokingJspCtx.handlePageException(t);
    }

    public VariableResolver getVariableResolver() {
        return this.invokingJspCtx.getVariableResolver();
    }

    private void copyFromTagToPageScope(int scope) {
        Iterator iter = null;
        switch (scope) {
            case 1: {
                if (this.atBeginVars == null) break;
                iter = this.atBeginVars.iterator();
                break;
            }
            case 2: {
                if (this.atEndVars == null) break;
                iter = this.atEndVars.iterator();
                break;
            }
            case 0: {
                if (this.nestedVars == null) break;
                iter = this.nestedVars.iterator();
            }
        }
        while (iter != null && iter.hasNext()) {
            String varName = (String)iter.next();
            Object value = this.getAttribute(varName);
            varName = this.checkAlias(varName);
            if (value != null) {
                this.invokingJspCtx.setAttribute(varName, value);
                continue;
            }
            this.invokingJspCtx.removeAttribute(varName, 1);
        }
    }

    private void saveNestedVariables() {
        if (this.nestedVars != null) {
            Iterator iterator = this.nestedVars.iterator();
            while (iterator.hasNext()) {
                String varName = (String)iterator.next();
                Object value = this.invokingJspCtx.getAttribute(varName = this.checkAlias(varName));
                if (value == null) continue;
                this.origNestedVars.put(varName, value);
            }
        }
    }

    private void restoreNestedVariables() {
        if (this.nestedVars != null) {
            Iterator iterator = this.nestedVars.iterator();
            while (iterator.hasNext()) {
                String varName = (String)iterator.next();
                Object value = this.origNestedVars.get(varName = this.checkAlias(varName));
                if (value != null) {
                    this.invokingJspCtx.setAttribute(varName, value);
                    continue;
                }
                this.invokingJspCtx.removeAttribute(varName, 1);
            }
        }
    }

    private void syncVariableBeginTagFile() {
        this.saveNestedVariables();
    }

    public void syncVariableBeforeFragment() {
        this.copyFromTagToPageScope(1);
        this.copyFromTagToPageScope(0);
    }

    public void syncVariableEndTagFile() {
        this.copyFromTagToPageScope(1);
        this.restoreNestedVariables();
        this.copyFromTagToPageScope(2);
    }

    private String checkAlias(String varName) {
        if (this.aliasVars == null) {
            return varName;
        }
        String aliasName = (String)this.aliasVars.get(varName);
        if (aliasName != null) {
            return aliasName;
        }
        return varName;
    }
}

