/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.InjectionTarget;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.PersistenceUnitReference;
import com.evermind.server.http.HttpApplication;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.JspTag;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.runtime.JspAnnotatedTagsMgr;
import oracle.jsp.runtime.JspAnnotationFactory;
import oracle.jsp.runtime.JspTagAnnotationScanner;
import oracle.jsp.runtime.JspTagDescriptor;
import oracle.jsp.runtimev2.JspServlet;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspAnnotatedTagsMgrImpl
extends HashMap<Class<? extends JspTag>, JspTagDescriptor>
implements JspAnnotatedTagsMgr {
    @Override
    public void scanForAnnotatedTags(HttpApplication hApp) throws JspException {
        Map tagList = hApp.getTagClassMap();
        if (tagList == null) {
            return;
        }
        JspTagAnnotationScanner scanner = JspAnnotationFactory.getScanner();
        if (scanner == null) {
            throw new JspException("InternalError: Null anotationScanner.");
        }
        Iterator iterator = tagList.keySet().iterator();
        String tagClassName = null;
        J2EEContextConfigDelegate jccd = hApp.getConfigDelegate();
        this.getWebDescriptorAnnotatedTags(jccd);
        while (iterator.hasNext()) {
            try {
                tagClassName = (String)iterator.next();
                Class tagClass = JspServlet.loadClass(tagClassName);
                JspTagDescriptor jtd = null;
                jtd = this.isTagAnnotated(tagClass) ? (JspTagDescriptor)((Object)scanner.scanAnnotations(tagClass, jccd, true)) : (JspTagDescriptor)((Object)scanner.scanAnnotations(tagClass, jccd));
                if (jtd == null) continue;
                this.addAnnotatedTag(tagClass, (Object)jtd);
            }
            catch (JspTagException je) {
                JspMessages.warningAnnotationScanningFailureForTag(tagClassName, je);
                throw je;
            }
            catch (InstantiationException ie) {
                throw new JspException((Throwable)ie);
            }
            catch (NoClassDefFoundError err) {
                JspMessages.warningAnnotationTagNotFound(tagClassName, err);
            }
            catch (ClassNotFoundException cnfe) {
                JspMessages.warningAnnotationTagNotFound(tagClassName, cnfe);
            }
            catch (ClassCastException cce) {
                JspMessages.warningAnnotationNotATag(tagClassName, cce);
            }
        }
    }

    private void getWebDescriptorAnnotatedTags(J2EEContextConfigDelegate jccd) {
        List envtEntries = jccd.getEnvironmentEntries();
        for (EnvironmentEntry entry : envtEntries) {
            List it = entry.getInjectionTargets();
            this.addInjectionTargetTags(it);
        }
        List ejbRefs = jccd.getEJBReferences();
        for (EJBReference ejbRef : ejbRefs) {
            List it = ejbRef.getInjectionTargets();
            this.addInjectionTargetTags(it);
        }
        List resourceRefs = jccd.getResourceReferences();
        for (ResourceReference resourceRef : resourceRefs) {
            List it = resourceRef.getInjectionTargets();
            this.addInjectionTargetTags(it);
        }
        List persistenceUnitRefs = jccd.getPersistenceUnitReferences();
        for (PersistenceUnitReference persistenceUnitRef : persistenceUnitRefs) {
            List it = persistenceUnitRef.getInjectionTargets();
            this.addInjectionTargetTags(it);
        }
        List persistenceContextRefs = jccd.getPersistenceContextReferences();
        for (PersistenceContextReference persistenceContextRef : persistenceContextRefs) {
            List it = persistenceContextRef.getInjectionTargets();
            this.addInjectionTargetTags(it);
        }
    }

    private void addInjectionTargetTags(List it) {
        for (InjectionTarget target : it) {
            String targetClass = target.getTargetClass();
            try {
                Class<JspTag> jspTagClass = JspTag.class;
                Class currentClass = JspServlet.loadClass(targetClass);
                if (!jspTagClass.isAssignableFrom(currentClass)) continue;
                this.addAnnotatedTag(currentClass, null);
            }
            catch (ClassNotFoundException cnfe) {
                JspMessages.warningAnnotationTagNotFound(targetClass, cnfe);
            }
        }
    }

    @Override
    public boolean isTagAnnotated(Class tagClass) {
        return this.containsKey(tagClass);
    }

    @Override
    public void addAnnotatedTag(Class tagClass, Object obj) {
        this.put(tagClass, (JspTagDescriptor)((Object)obj));
    }

    @Override
    public Object removeAnnotatedTag(Class tagClass) {
        return this.remove(tagClass);
    }

    @Override
    public Method getPostConstructMethod(Class tagClass) {
        JspTagDescriptor jtd = (JspTagDescriptor)((Object)this.get(tagClass));
        if (jtd == null) {
            return null;
        }
        return jtd.getPostConstructMethod();
    }

    @Override
    public Method getPreDestroyMethod(Class tagClass) {
        JspTagDescriptor jtd = (JspTagDescriptor)((Object)this.get(tagClass));
        if (jtd == null) {
            return null;
        }
        return jtd.getPreDestroyMethod();
    }

    @Override
    public J2EEContextConfigDelegate getConfigDelegate(Class tagClass) {
        JspTagDescriptor jtd = (JspTagDescriptor)((Object)this.get(tagClass));
        if (jtd == null) {
            return null;
        }
        return jtd.getConfigDelegate();
    }
}

