/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.provider.JspResourceProvider;

public class JspFilesystemResource
implements JspResourceProvider {
    private static final String MESSAGE_FILE = "oracle.jsp.provider.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.provider.LocalStrings");
    protected String repositoryRoot;
    protected String contextRoot;
    protected String appPath;
    protected String physicalRoot;
    protected String virtualRoot;
    protected int vLen;
    private boolean needsInit = true;

    public void init(String repositoryRoot, String contextRoot, String appRoot, ServletContext sc, HttpServletRequest req, Hashtable initParams) throws IllegalStateException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        this.setRoots(repositoryRoot, contextRoot, appRoot);
        this.ensurePath("/");
    }

    private void setRoots(String repositoryRoot, String contextRoot, String appPath) {
        if (repositoryRoot.charAt(repositoryRoot.length() - 1) != File.separatorChar) {
            repositoryRoot = repositoryRoot + File.separator;
        }
        this.repositoryRoot = repositoryRoot;
        this.contextRoot = this.normalizeRoot(contextRoot, "/");
        this.appPath = this.normalizeRoot(appPath, "/");
        this.virtualRoot = this.concatPaths(this.contextRoot, this.appPath, "/");
        this.vLen = this.virtualRoot.length();
        this.physicalRoot = this.concatPaths(this.repositoryRoot.replace('/', File.separatorChar), this.appPath.replace('/', File.separatorChar), File.separator);
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public InputStream fromStream(String resource) throws FileNotFoundException, IOException {
        String resourcePath = this.translateToAbsolutePath(resource);
        return new FileInputStream(resourcePath);
    }

    public InputStreamReader fromReader(String resource, String enc) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (enc != null) {
            return new InputStreamReader(this.fromStream(resource), enc);
        }
        return new InputStreamReader(this.fromStream(resource));
    }

    public OutputStream toStream(String resource) throws FileNotFoundException, IOException {
        String absResource = this.translateToAbsolutePath(resource);
        try {
            return new FileOutputStream(absResource);
        }
        catch (FileNotFoundException fnf) {
            this.createPath(this.stripTarget(absResource, File.separator));
            return new FileOutputStream(absResource);
        }
    }

    public PrintWriter toPrintWriter(String resource) throws FileNotFoundException, IOException {
        return new PrintWriter(this.toWriter(resource));
    }

    public PrintWriter toPrintWriter(String resource, String enc) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return new PrintWriter(this.toWriter(resource, enc));
    }

    public OutputStreamWriter toWriter(String resource) throws FileNotFoundException, IOException {
        return new OutputStreamWriter(this.toStream(resource));
    }

    public OutputStreamWriter toWriter(String resource, String enc) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (enc != null) {
            return new OutputStreamWriter(this.toStream(resource), enc);
        }
        return new OutputStreamWriter(this.toStream(resource));
    }

    protected void ensurePath(String path) {
        String absResource = this.translateToAbsolutePath(path);
        this.createPath(this.stripTarget(absResource, File.separator));
    }

    public long getLastModified(String resource) throws FileNotFoundException, IOException {
        return this.getLastModified(resource, null);
    }

    public long getLastModified(String resource, HttpServletRequest request) throws FileNotFoundException, IOException {
        String absResource = this.translateToAbsolutePath(resource);
        File f = new File(absResource);
        long lastModified = f.lastModified();
        if (lastModified == 0L) {
            if (!f.exists()) {
                throw new FileNotFoundException(resource);
            }
            throw new IOException(resource);
        }
        return lastModified;
    }

    public String[] listClassRepositories(String path) {
        File fPath = path.charAt(0) == '/' ? new File(this.physicalRoot + path.replace('/', File.separatorChar).substring(1)) : new File(this.physicalRoot + path.replace('/', File.separatorChar));
        String[] files = fPath.list();
        if (files == null) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < files.length; ++i) {
            if (!XMLUtil.isJarFile(files[i])) continue;
            files[j++] = files[i];
        }
        String[] nFiles = new String[j];
        for (int i = 0; i < j; ++i) {
            nFiles[i] = files[i];
        }
        return nFiles;
    }

    public String translateToContextPath(String rPath) {
        if (rPath.charAt(0) == '/') {
            if (rPath.length() == 1) {
                int len = this.appPath.length();
                if (len == 1 || this.appPath.charAt(this.appPath.length() - 1) != '/') {
                    return this.appPath;
                }
                return this.appPath.substring(0, this.appPath.length() - 1);
            }
            return this.appPath + rPath.substring(1);
        }
        return this.appPath + rPath;
    }

    public String translateToAbsolutePath(String rPath) {
        return this.concatPaths(this.physicalRoot, rPath.replace('/', File.separatorChar), File.separator);
    }

    public String getAbsolutePath(String rPath) {
        return this.translateToAbsolutePath(rPath);
    }

    protected String concatPaths(String root, String relative, String pathSep) {
        boolean pathPrefixed;
        int sLen = root.length();
        boolean pathSuffixed = root.charAt(sLen - 1) == pathSep.charAt(0);
        boolean bl = pathPrefixed = relative.charAt(0) == pathSep.charAt(0);
        if (sLen == 1 && pathSuffixed && pathPrefixed) {
            return relative;
        }
        if (pathSuffixed && !pathPrefixed || !pathSuffixed && pathPrefixed) {
            return root + relative;
        }
        if (!pathSuffixed && !pathPrefixed) {
            return root + pathSep + relative;
        }
        return root.substring(0, sLen - 1) + relative;
    }

    protected String normalizeRoot(String root, String pathSep) {
        boolean pathSuffixed;
        int sLen = root.length();
        if (sLen == 0) {
            return pathSep;
        }
        boolean pathPrefixed = root.charAt(0) == pathSep.charAt(0);
        boolean bl = pathSuffixed = root.charAt(sLen - 1) == pathSep.charAt(0);
        if (pathPrefixed && pathSuffixed || pathPrefixed && sLen == 1) {
            return root;
        }
        if (!pathPrefixed && !pathSuffixed) {
            return pathSep + root + pathSep;
        }
        if (!pathPrefixed && pathSuffixed) {
            return pathSep + root;
        }
        return root + pathSep;
    }

    protected String stripTarget(String s, String separator) {
        int end = s.lastIndexOf(separator);
        if (end <= 0) {
            return separator;
        }
        return s.substring(0, end);
    }

    protected void createPath(String path) {
        File classDir = new File(path);
        if (!classDir.exists()) {
            classDir.mkdirs();
        }
    }

    public String getProviderURI(String path) {
        return path;
    }
}

