/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.tldcache.CachedTldImpl;
import oracle.jsp.parse.tldcache.TldUtil;
import oracle.xml.parser.v2.XMLParseException;

public class TldResourceImpl {
    protected URL url;
    protected String timestamp;
    protected List cachedTldList = new ArrayList();
    protected int action;
    protected String hasTlds;
    protected JspParseState st;

    protected TldResourceImpl() {
    }

    protected TldResourceImpl(int action, URL url, long timestamp, JspParseState st) {
        this.action = action;
        this.url = url;
        this.timestamp = new Long(timestamp).toString();
        this.st = st;
    }

    protected TldResourceImpl(StringTokenizer strTok) throws MalformedURLException {
        if (strTok.hasMoreElements()) {
            this.url = new URL((String)strTok.nextElement());
        }
        if (strTok.hasMoreElements()) {
            this.timestamp = (String)strTok.nextElement();
        }
        if (strTok.hasMoreElements()) {
            this.hasTlds = (String)strTok.nextElement();
        }
    }

    protected void loadTldLine(StringTokenizer strTok, boolean loadDom, String cacheDirectory, JspParseState st, Hashtable uriTable) throws MalformedURLException, IOException {
        this.cachedTldList.add(new CachedTldImpl(strTok, loadDom, cacheDirectory, st, uriTable));
    }

    protected void buildTlds(String cacheDirectory, Hashtable uriTable, boolean uriRequired, boolean debug) throws IOException {
        if (this.url.toString().endsWith(".jar") || this.url.toString().endsWith(".JAR")) {
            Enumeration<JarEntry> entryList;
            JarFile jf;
            String nm = this.url.toString().substring(5, this.url.toString().length());
            try {
                jf = new JarFile(nm);
                entryList = jf.entries();
            }
            catch (Exception io) {
                TldUtil.logException(io);
                return;
            }
            while (entryList.hasMoreElements()) {
                JarEntry je = entryList.nextElement();
                String name = je.getName();
                if (!name.startsWith("META-INF") || !name.endsWith(".tld") && !name.endsWith(".otld") && !name.endsWith(".TLD")) continue;
                try {
                    CachedTldImpl cti = new CachedTldImpl(new URL("jar:" + this.url.toString() + "!/" + name), je.getTime(), this.st, cacheDirectory, uriRequired);
                    this.cachedTldList.add(cti);
                    if (debug) {
                        this.checkDuplicateUri(cti, uriTable);
                    }
                    cti.persistParsedForm(TldUtil.generateParsedFormName(cti.url, cacheDirectory, this.st));
                }
                catch (XMLParseException x) {
                    TldUtil.logException(" xml parse processing jar:" + this.url.toString() + "!/" + name + ": ", (Exception)((Object)x));
                }
                catch (Exception e) {
                    TldUtil.logException(" processing jar:" + this.url.toString() + "!/" + name + ": ", e);
                }
            }
            try {
                jf.close();
            }
            catch (Exception e) {}
        } else {
            File f = new File(this.url.getFile());
            try {
                CachedTldImpl cti = new CachedTldImpl(this.url, f.lastModified(), this.st, cacheDirectory, uriRequired);
                this.cachedTldList.add(cti);
                if (debug) {
                    this.checkDuplicateUri(cti, uriTable);
                }
                cti.persistParsedForm(TldUtil.generateParsedFormName(cti.url, cacheDirectory, this.st));
            }
            catch (XMLParseException x) {
                TldUtil.logException(" xml parse error processing " + this.url.toString() + ": " + TldUtil.getDetailedXPEMsg(x, 10));
            }
            catch (Exception e) {
                TldUtil.logException(" processing " + this.url.toString() + ": ", e);
            }
        }
    }

    private void checkDuplicateUri(CachedTldImpl cti, Hashtable uriTable) {
        if (cti.uriElement != null) {
            if (uriTable.containsKey(cti.uriElement) && !uriTable.get(cti.uriElement).equals(cti.url)) {
                JspMessages.warningDuplicateURI(cti.uriElement.toString(), uriTable.get(cti.uriElement).toString(), cti.url.toString());
            }
            uriTable.put(cti.uriElement, cti.url);
        }
    }

    protected void format(PrintWriter pw) {
        pw.println(this.url.toString() + "^" + this.timestamp + "^" + (this.cachedTldList.isEmpty() ? "false" : "true") + "^");
        for (int i = 0; i < this.cachedTldList.size(); ++i) {
            ((CachedTldImpl)this.cachedTldList.get(i)).format(pw);
        }
    }
}

