/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import com.evermind.server.ApplicationServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.TagInfo;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.CachedConfigEntry;
import oracle.jsp.parse.CachedConfigTable;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.OracleTagLibraryInfo;
import oracle.jsp.parse.tldcache.ApplicationTldCacheImpl;
import oracle.jsp.parse.tldcache.CachedTldImpl;
import oracle.jsp.parse.tldcache.GlobalTldCacheImpl;
import oracle.jsp.parse.tldcache.TldCache;
import oracle.jsp.parse.tldcache.TldResourceImpl;
import oracle.jsp.parse.tldcache.TldUtil;

public abstract class TldCacheImpl
implements TldCache {
    public static final int UNKNOWN_ACTION = 0;
    public static final int INSERT_ACTION = 1;
    public static final int UPDATE_ACTION = 2;
    public static final int DELETE_ACTION = 3;
    public static final int COPY_ACTION = 4;
    protected ArrayList currentResources = new ArrayList();
    protected Hashtable existingResources = new Hashtable();
    protected Hashtable uriTable = new Hashtable();
    protected String cacheName;
    protected String cacheDirectory;
    protected JspParseState st;
    protected static boolean udpated = false;
    protected boolean uriRequired = false;
    protected int searchLevel = 0;
    public static boolean debug = false;
    private Map allTagClasses;

    public boolean isCachePresent() {
        File f = new File(this.getCacheLocation());
        return f.exists();
    }

    public void initCache(String realPath, ClassLoader loader, int verbosity) throws IOException {
        if (verbosity > 4) {
            debug = true;
        }
        TldUtil tu = new TldUtil();
        this.st = tu.initJspParseState(realPath, loader);
        if (this instanceof GlobalTldCacheImpl) {
            this.uriRequired = true;
        }
        this.getCurrentResources();
        JspMessages.fineInitializingTldCacheDone();
    }

    public List getTldListeners() throws IOException {
        this.readPersistedCache(false, this.cacheDirectory);
        ArrayList<String> listeners = new ArrayList<String>();
        if (this instanceof ApplicationTldCacheImpl) {
            Hashtable globalListeners = this.getListeners(((GlobalTldCacheImpl)ApplicationServer.getInstance().getGlobalTldCache()).existingResources, null);
            Hashtable appListeners = this.getListeners(this.existingResources, globalListeners);
            Enumeration enumerator = appListeners.keys();
            while (enumerator.hasMoreElements()) {
                listeners.add((String)enumerator.nextElement());
            }
            JspMessages.fineListenerSize(String.valueOf(listeners.size()));
        }
        return listeners;
    }

    public Object loadAllTlds(Object table, JspParseState st) throws IOException {
        if (!(this instanceof GlobalTldCacheImpl)) {
            GlobalTldCacheImpl gtci = (GlobalTldCacheImpl)ApplicationServer.getInstance().getGlobalTldCache();
            if (gtci != null) {
                JspMessages.fineReadingTldCache("global");
                gtci.readPersistedCache(true, gtci.cacheDirectory);
                if (table instanceof CachedConfigTable) {
                    table = this.loadFromExistingResources((CachedConfigTable)table, gtci.existingResources, true, st, false);
                }
            }
            JspMessages.fineReadingTldCache("application");
            this.readPersistedCache(true, this.cacheDirectory);
            table = table instanceof CachedConfigTable ? this.loadFromExistingResources((CachedConfigTable)table, this.existingResources, false, st, true) : this.loadTagClassNamesFromExistingResources((Map)table, this.existingResources, false, st, false);
        }
        return table;
    }

    public boolean getDebug() {
        return debug;
    }

    protected abstract void getCurrentResources() throws IOException;

    protected boolean refreshCache() throws IOException, MalformedURLException {
        if (!this.isCachePresent()) {
            return false;
        }
        if (this.needsUpdate()) {
            this.updateCache(false);
            JspMessages.fineUpdatingTldCacheDone();
            return true;
        }
        return false;
    }

    protected boolean needsUpdate() throws IOException, MalformedURLException {
        this.readPersistedCache(false, null);
        return this.compareTimestamps();
    }

    protected void readPersistedCache(boolean loadDom, String cacheDirectory) throws IOException, MalformedURLException {
        ArrayList<String> al = new ArrayList<String>();
        this.existingResources.clear();
        this.uriTable.clear();
        LineNumberReader lr = new LineNumberReader(new FileReader(new File(this.getCacheLocation())));
        String buf = lr.readLine();
        while (buf != null) {
            al.add(buf);
            buf = lr.readLine();
        }
        lr.close();
        TldResourceImpl tr = null;
        boolean lookingForUnjarredTldEntry = false;
        for (int i = 0; i < al.size(); ++i) {
            StringTokenizer strTok;
            if (((String)al.get(i)).startsWith("file:") && !lookingForUnjarredTldEntry) {
                strTok = new StringTokenizer((String)al.get(i), "^");
                tr = new TldResourceImpl(strTok);
                this.existingResources.put(tr.url.toString(), tr);
                lookingForUnjarredTldEntry = tr.url.toString().endsWith(".tld") || tr.url.toString().endsWith(".TLD") || tr.url.toString().endsWith(".otld") ? !tr.hasTlds.equals("false") : false;
            } else if (((String)al.get(i)).startsWith("file:") && lookingForUnjarredTldEntry && tr != null) {
                strTok = new StringTokenizer((String)al.get(i), "^");
                try {
                    tr.loadTldLine(strTok, loadDom, cacheDirectory, this.st, this.uriTable);
                }
                catch (IOException io) {
                    lookingForUnjarredTldEntry = false;
                    continue;
                }
                this.existingResources.put(tr.url.toString(), tr);
                lookingForUnjarredTldEntry = false;
            }
            if (!((String)al.get(i)).startsWith("jar:file:") || !tr.hasTlds.equals("true")) continue;
            strTok = new StringTokenizer((String)al.get(i), "^");
            if (tr == null) continue;
            try {
                tr.loadTldLine(strTok, loadDom, cacheDirectory, this.st, this.uriTable);
            }
            catch (IOException io) {
                lookingForUnjarredTldEntry = false;
                continue;
            }
            this.existingResources.put(tr.url.toString(), tr);
        }
    }

    protected boolean compareTimestamps() throws IOException {
        boolean needsUpdate = false;
        String existingTimestamp = null;
        String currentUrl = null;
        String currentTimestamp = null;
        TldResourceImpl curFile = null;
        for (int i = 0; i < this.currentResources.size(); ++i) {
            curFile = (TldResourceImpl)this.currentResources.get(i);
            currentUrl = curFile.url.toString();
            if (this.existingResources.containsKey(currentUrl)) {
                TldResourceImpl tr = (TldResourceImpl)this.existingResources.get(currentUrl);
                existingTimestamp = tr.timestamp;
                currentTimestamp = curFile.timestamp;
                if (!existingTimestamp.equals(currentTimestamp)) {
                    needsUpdate = true;
                    curFile.action = 2;
                    continue;
                }
                curFile.action = 4;
                continue;
            }
            curFile.action = 1;
            needsUpdate = true;
        }
        if (this.findDeletes()) {
            needsUpdate = true;
        }
        return needsUpdate;
    }

    protected boolean findDeletes() throws IOException {
        boolean foundDeletedResource = false;
        String prefix = "file:";
        Enumeration enumerator = this.existingResources.keys();
        while (enumerator.hasMoreElements()) {
            String existingUrl = (String)enumerator.nextElement();
            String existingName = existingUrl.substring(prefix.length(), existingUrl.length());
            File f = new File(existingName);
            if (f.exists()) continue;
            TldResourceImpl tri = (TldResourceImpl)this.existingResources.get(existingUrl);
            for (int i = 0; i < tri.cachedTldList.size(); ++i) {
                CachedTldImpl cti = (CachedTldImpl)tri.cachedTldList.get(i);
                String name = TldUtil.generateParsedFormName(cti.url, this.cacheDirectory, this.st);
                File parsedForm = new File(name);
                if (!parsedForm.exists()) continue;
                parsedForm.delete();
            }
            foundDeletedResource = true;
        }
        return foundDeletedResource;
    }

    protected void updateCache(boolean newCache) throws IOException {
        this.applyInserts();
        if (!newCache) {
            this.applyCopies();
            this.applyUpdates();
        }
    }

    protected void applyInserts() throws IOException {
        for (int i = 0; i < this.currentResources.size(); ++i) {
            if (((TldResourceImpl)this.currentResources.get((int)i)).action != 1) continue;
            JspMessages.fineInsertingURL(((TldResourceImpl)this.currentResources.get((int)i)).url.toString());
            ((TldResourceImpl)this.currentResources.get(i)).buildTlds(this.cacheDirectory, this.uriTable, this.uriRequired, debug);
        }
    }

    protected void applyCopies() throws IOException {
        int siz = this.currentResources.size();
        for (int i = 0; i < siz; ++i) {
            if (((TldResourceImpl)this.currentResources.get((int)i)).action != 4) continue;
            String url = ((TldResourceImpl)this.currentResources.get((int)i)).url.toString();
            if (this.existingResources.containsKey(url)) {
                this.currentResources.remove(i);
                this.currentResources.add(i, this.existingResources.get(url));
                continue;
            }
            JspMessages.warningBadTldCacheKey(url.toString());
        }
    }

    protected void applyUpdates() throws IOException {
        for (int i = 0; i < this.currentResources.size(); ++i) {
            if (((TldResourceImpl)this.currentResources.get((int)i)).action != 2) continue;
            JspMessages.fineUpdatingURL(((TldResourceImpl)this.currentResources.get((int)i)).url.toString());
            ((TldResourceImpl)this.currentResources.get(i)).buildTlds(this.cacheDirectory, this.uriTable, this.uriRequired, debug);
        }
    }

    protected String getCacheLocation() {
        return this.cacheDirectory + this.cacheName;
    }

    protected void persistCache() throws IOException, InterruptedException {
        File locker = new File(this.cacheDirectory + "cacheLock");
        boolean cacheFree = false;
        while (true) {
            cacheFree = locker.createNewFile();
            locker.deleteOnExit();
            if (cacheFree) break;
            Thread.sleep(3000L);
        }
        if (cacheFree) {
            this.writeOutCache();
            locker.delete();
        }
        JspMessages.finePersistingTldCacheDone();
    }

    protected void writeOutCache() throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(new File(this.getCacheLocation())));
        for (int i = 0; i < this.currentResources.size(); ++i) {
            ((TldResourceImpl)this.currentResources.get(i)).format(pw);
        }
        pw.close();
        JspMessages.fineWritingTldCacheDone();
    }

    protected void buildTagClassMap(JspParseState st) throws IOException {
        if (this.allTagClasses == null) {
            this.allTagClasses = new HashMap();
        }
        this.allTagClasses = (Map)this.loadAllTlds(this.allTagClasses, st);
    }

    private CachedConfigTable loadFromExistingResources(CachedConfigTable cachedConfigTable, Hashtable existingResources, boolean direct, JspParseState st, boolean reportDuplicates) throws IOException {
        Enumeration keys = existingResources.keys();
        while (keys.hasMoreElements()) {
            TldResourceImpl tri = (TldResourceImpl)existingResources.get(keys.nextElement());
            for (int i = 0; i < tri.cachedTldList.size(); ++i) {
                try {
                    CachedTldImpl cti = (CachedTldImpl)tri.cachedTldList.get(i);
                    OracleTagLibraryInfo tlib = cti.tlibInfo;
                    JspMessages.fineURLForEntry(cti.url.toString());
                    String temp = cti.url.toString();
                    String name = null;
                    String location = null;
                    if (direct) {
                        if (cti.uriElement == null || cti.uriElement.equals("null")) continue;
                        name = cti.uriElement;
                        location = temp.substring(temp.indexOf("jar:file:") + "jar:file:".length(), temp.lastIndexOf("!"));
                        JspMessages.fineLoadingDirectTld(name, location);
                        cachedConfigTable.setConfigObject(name, (Object)tlib, location, direct, st);
                        continue;
                    }
                    String temp1 = null;
                    if (temp.indexOf("/WEB-INF/") != -1) {
                        temp1 = temp.substring(temp.lastIndexOf("/WEB-INF/"), temp.lastIndexOf("!") == -1 ? temp.length() : temp.lastIndexOf("!"));
                    } else {
                        String repRoot = st.parms.resourceProvider.getRepositoryRoot();
                        repRoot = repRoot.replace('\\', '/');
                        temp1 = "/" + temp.substring(temp.lastIndexOf(repRoot) + repRoot.length(), temp.lastIndexOf("!") == -1 ? temp.length() : temp.lastIndexOf("!"));
                    }
                    if (temp1.endsWith(".jar")) {
                        tlib.setJarName(temp1);
                    }
                    if (cti.uriElement != null && !cti.uriElement.equals("null")) {
                        CachedConfigEntry cachedEntry;
                        name = cti.uriElement;
                        location = temp1;
                        if (temp.endsWith(".otld")) {
                            name = name + "_oracle";
                        }
                        if (reportDuplicates && this.getDebug() && (cachedEntry = cachedConfigTable.getCachedConfigEntry(name, ((Object)((Object)tlib)).getClass(), st)) != null) {
                            JspMessages.warningDuplicateURI(cti.uriElement, cti.url.toString(), cachedEntry.overridingLocation);
                        }
                        JspMessages.fineLoadingIndirectTld(name, location);
                        cachedConfigTable.setConfigObject(name, (Object)tlib, location, direct, st);
                    }
                    name = temp1;
                    location = null;
                    JspMessages.fineLoadingTldFile(name, location);
                    cachedConfigTable.setConfigObject(name, (Object)tlib, location, direct, st);
                    continue;
                }
                catch (Exception e) {
                    TldUtil.logException(" loading Tld's into cachedConfigTable: ", e);
                }
            }
        }
        return cachedConfigTable;
    }

    private Map loadTagClassNamesFromExistingResources(Map table, Hashtable existingResources, boolean direct, JspParseState st, boolean reportDuplicates) throws IOException {
        Enumeration elems = existingResources.elements();
        while (elems.hasMoreElements()) {
            TldResourceImpl tri = (TldResourceImpl)elems.nextElement();
            for (int i = 0; i < tri.cachedTldList.size(); ++i) {
                CachedTldImpl cti = (CachedTldImpl)tri.cachedTldList.get(i);
                OracleTagLibraryInfo tlib = cti.tlibInfo;
                if (tlib == null) continue;
                TagInfo[] ti = tlib.getTags();
                for (int j = 0; j < ti.length; ++j) {
                    table.put(ti[j].getTagClassName(), null);
                }
            }
        }
        return table;
    }

    private Hashtable getListeners(Hashtable existingResources, Hashtable globalListeners) {
        Hashtable h = globalListeners != null ? globalListeners : new Hashtable();
        Enumeration enumerator = existingResources.keys();
        while (enumerator.hasMoreElements()) {
            TldResourceImpl tr = (TldResourceImpl)existingResources.get(enumerator.nextElement());
            for (int i = 0; i < tr.cachedTldList.size(); ++i) {
                CachedTldImpl cti = (CachedTldImpl)tr.cachedTldList.get(i);
                for (int j = 0; j < cti.listeners.size(); ++j) {
                    JspMessages.fineFoundListener((String)cti.listeners.get(j));
                    h.put(cti.listeners.get(j), "dummy");
                }
            }
        }
        return h;
    }

    public int getSearchLevel() {
        return this.searchLevel;
    }

    public Map getTagClassMap() {
        return this.allTagClasses;
    }
}

