/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import com.evermind.server.ApplicationServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.tldcache.TldCacheImpl;
import oracle.jsp.parse.tldcache.TldResourceImpl;
import oracle.jsp.parse.tldcache.TldUtil;

public class GlobalTldCacheImpl
extends TldCacheImpl {
    private static final String globalTldCacheSubDir = "tldcache" + File.separator;
    private static final String globalTldCacheName = "_GlobalTldCache";
    private static String globalTldCacheLocBase = null;
    private static String globalTldResourceBase = null;
    private String globalResources;
    private ArrayList globalResourceDirs;

    private GlobalTldCacheImpl() {
    }

    public static synchronized GlobalTldCacheImpl getInstance(String realPath, ClassLoader loader, int verbosity, String globalResources, String globalCacheLocBase, int level) throws IOException, InterruptedException, MalformedURLException {
        GlobalTldCacheImpl instance = (GlobalTldCacheImpl)ApplicationServer.getInstance().getGlobalTldCache();
        if (instance == null) {
            JspMessages.fineBuildingTldCache("global");
            instance = new GlobalTldCacheImpl();
            instance.searchLevel = level;
            instance.setLocation(globalCacheLocBase);
            instance.globalResources = globalResources;
            instance.initCache(realPath, loader, verbosity);
            if (!instance.isCachePresent()) {
                instance.updateCache(!instance.isCachePresent());
                instance.persistCache();
                instance.readPersistedCache(false, null);
            } else {
                JspMessages.fineRefreshingTldCache("global");
                if (instance.refreshCache()) {
                    instance.persistCache();
                }
            }
        } else {
            instance.initCache(realPath, loader, verbosity);
            JspMessages.fineRefreshingTldCache("global");
            if (instance.refreshCache()) {
                instance.persistCache();
            }
        }
        return instance;
    }

    protected void getCurrentResources() throws IOException {
        boolean knownInsert = !this.isCachePresent();
        this.currentResources.clear();
        this.obtainGlobalResourceList();
        for (int j = 0; j < this.globalResourceDirs.size(); ++j) {
            File f = (File)this.globalResourceDirs.get(j);
            File[] resources = f.listFiles();
            if (resources == null) continue;
            for (int i = 0; i < resources.length; ++i) {
                if (!resources[i].getName().endsWith(".jar")) continue;
                this.currentResources.add(new TldResourceImpl(knownInsert ? 1 : 0, resources[i].toURL(), resources[i].lastModified(), this.st));
            }
        }
        JspMessages.fineGettingCurrentResourceDone();
    }

    private void obtainGlobalResourceList() {
        if (this.globalResourceDirs == null) {
            this.globalResourceDirs = new ArrayList();
        } else {
            this.globalResourceDirs.clear();
        }
        this.globalResources = this.globalResources == null || this.globalResources.length() == 0 ? GlobalTldCacheImpl.getWellKnownLoc() + ";" : (this.globalResources.endsWith(";") ? this.globalResources : this.globalResources + ";");
        StringTokenizer strTok = new StringTokenizer(this.globalResources, ";");
        while (strTok.hasMoreTokens()) {
            String afile = strTok.nextToken();
            File f = new File(!afile.startsWith(".") || globalTldResourceBase == null || globalTldResourceBase.length() == 0 ? afile : globalTldResourceBase + afile);
            JspMessages.fineLookingForGlobalResource(f.getAbsolutePath());
            if (!f.exists() || !f.isDirectory()) {
                JspMessages.warningInvalidTaglibLoc(f.getAbsolutePath());
                continue;
            }
            this.globalResourceDirs.add(f);
        }
    }

    private void setLocation(String globalCacheLocBase) throws IOException {
        this.cacheName = globalTldCacheName;
        this.cacheDirectory = GlobalTldCacheImpl.getCacheSubDir(globalCacheLocBase);
        globalTldCacheLocBase = globalCacheLocBase;
        globalTldResourceBase = globalCacheLocBase.substring(0, globalCacheLocBase.lastIndexOf(".." + File.separator));
    }

    private static String getCacheSubDir(String globalCacheLocBase) throws IOException {
        File f = new File(globalCacheLocBase + globalTldCacheSubDir);
        if (!f.exists() && !f.mkdirs()) {
            TldUtil.format("no_tldcache_dir", globalCacheLocBase, globalTldCacheSubDir);
        }
        return f.getPath() + File.separator;
    }

    private static String getWellKnownLoc() {
        return Jsp2JavaParms.ORACLE_HOME == null ? "." + Jsp2JavaParms.STANDALONE_DEFAULT_WELLKNOW_TLD_JAR_LOC : Jsp2JavaParms.ORACLE_HOME + Jsp2JavaParms.DEFAULT_WELLKNOWN_TLD_JAR_LOC;
    }
}

