/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspEmitter;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspUtils;

public class TagFileEmitter
extends JspEmitter {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final boolean canHandleThrowable_FLAG = TagFileEmitter.canHandleThrowable();
    private TagInfo taginfo;
    private String tagInfoStr;
    private static final String pkg = "oracle.jsp.runtime";
    private static final String[] importStrsEL = new String[]{"oracle.jsp.runtime.*", "oracle.jsp.el.*", "javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*", "javax.servlet.jsp.tagext.*", "javax.servlet.jsp.el.*"};
    private static final String[] importStrsNoEL = new String[]{"oracle.jsp.runtime.*", "javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*", "javax.servlet.jsp.tagext.*"};
    private String extName;
    private String clsName;
    protected String emittedPackageName;

    public TagFileEmitter(TagInfo taginfo, String tagInfoStr) {
        this.taginfo = taginfo;
        this.tagInfoStr = tagInfoStr;
    }

    public void emit(JspEmitState st, JspParseTagFile srcRoot) throws JspParseException {
        block3: {
            if (this.taginfo == null && st.parseState.throwParseException(new JspParseException(-1, msgs.getString("emit_ex"), "taginfo null in TagFileEmitter"))) {
                return;
            }
            st.printLineInfoFile(srcRoot.getFileName());
            st.printLineInfoGenerated();
            st.printLineInfo(0, 1);
            this.emitHeader(st);
            this.emitClassDecl(st);
            JspEmitter.emitGlobalDeclarations(st);
            this.emitDeclarations(st);
            this.emitClassVariables(st);
            this.emitJspContext(st);
            this.emitAttributeMethods(st);
            st.printLineInfoTranslated();
            this.emitDoTagMethod(st, srcRoot);
            st.setFromService(true);
            try {
                srcRoot.emit(st);
            }
            catch (JspEmitException e) {
                if (!st.parseState.throwParseException(new JspParseException(-1, msgs.getString("emit_ex"), e.getMessage()))) break block3;
                return;
            }
        }
        st.setFromService(false);
        st.printLineInfoGenerated();
        this.emitDoTagTrailer(st);
        this.emitGetTagInfoMethod(st);
        this.emitFragmentCode(st);
        this.emitTrailer(st);
    }

    protected void emitHeader(JspEmitState st) {
        String imp;
        int i;
        String pack = pkg;
        if (st.parms.packageName != null) {
            pack = st.parms.packageName;
        }
        if (pack.length() > 0) {
            st.println("package " + pack + ";");
            this.emittedPackageName = pack;
        } else {
            this.emittedPackageName = null;
        }
        st.println("");
        if (!st.parseState.parms.elIgnored) {
            for (i = 0; i < importStrsEL.length; ++i) {
                st.println("import " + importStrsEL[i] + ";");
            }
        } else {
            for (i = 0; i < importStrsNoEL.length; ++i) {
                st.println("import " + importStrsNoEL[i] + ";");
            }
        }
        if (st.parms.extraImports != null) {
            Enumeration e = st.parms.extraImports.elements();
            while (e.hasMoreElements()) {
                st.println("import " + e.nextElement() + ";");
            }
        }
        if (st.parms.imports != null) {
            for (i = 0; i < st.parms.imports.length; ++i) {
                st.println("import " + st.parms.imports[i] + ";");
            }
        }
        if ((imp = st.getDirectiveAttrValue("page", "import")) != null) {
            String line;
            int idx;
            while ((idx = imp.indexOf(44)) != -1) {
                line = imp.substring(0, idx).trim();
                if (line.length() > 0) {
                    st.println("import " + line + ";");
                }
                if (idx + 1 < imp.length()) {
                    imp = imp.substring(idx + 1);
                    continue;
                }
                imp = "";
            }
            line = imp.trim();
            if (line.length() > 0) {
                st.println("import " + line + ";");
            }
        }
        st.println("");
        st.println("");
    }

    protected void emitClassDecl(JspEmitState st) {
        this.clsName = st.parms.className == null ? "tagfile_" + Long.toString(new Date().getTime()) + "_" + Integer.toString(++JspEmitState.emitCount) : st.parms.className;
        String extName = st.parms.extend;
        if (extName == null) {
            extName = "javax.servlet.jsp.tagext.SimpleTagSupport";
        }
        st.print("public class " + this.clsName + " extends " + extName + " ");
        st.print(" implements oracle.jsp.runtime.OracleTagFile");
        if (this.taginfo.hasDynamicAttributes()) {
            st.println(",");
            st.iprintln(" javax.servlet.jsp.tagext.DynamicAttributes ");
        }
        st.println("");
        st.println("{");
        st.println("");
    }

    protected void emitClassVariables(JspEmitState st) {
        st.iprintln("private TagInfo tagInfo = null;");
        st.iprintln("private JspContext jspContext;");
        st.iprintln("private java.io.Writer _jspFragWriter;");
        if (this.taginfo.hasDynamicAttributes()) {
            st.iprintln("private java.util.HashMap _dynamicAttrs= new java.util.HashMap();");
        }
        TagAttributeInfo[] tagAttributes = this.taginfo.getAttributes();
        for (int i = 0; i < tagAttributes.length; ++i) {
            st.iprint("private ");
            if (tagAttributes[i].isFragment()) {
                st.print("javax.servlet.jsp.tagext.JspFragment ");
            } else {
                st.print(tagAttributes[i].getTypeName());
            }
            st.print(" ");
            st.print(tagAttributes[i].getName());
            st.println(";");
        }
        st.println("");
    }

    protected void emitJspContext(JspEmitState st) {
        int i;
        boolean atBeginArrayDecl = false;
        boolean atEndArrayDecl = false;
        boolean nestedArrayDecl = false;
        boolean aliasExists = false;
        TagVariableInfo[] tagVars = this.taginfo.getTagVariableInfos();
        for (i = 0; i < tagVars.length; ++i) {
            if (tagVars[i].getNameFromAttribute() == null || tagVars[i].getNameGiven() == null) continue;
            aliasExists = true;
            break;
        }
        if (aliasExists) {
            st.iprintln("public void setJspContext(JspContext ctx, java.util.HashMap _aliasMap) ");
        } else {
            st.iprintln("public void setJspContext(JspContext ctx) ");
        }
        st.iprintln("{");
        st.indent();
        st.iprintln("super.setJspContext(ctx);");
        st.iprintln("java.util.ArrayList _nestedVars;");
        st.iprintln("java.util.ArrayList _atBeginVars;");
        st.iprintln("java.util.ArrayList _atEndVars;");
        for (i = 0; i < tagVars.length; ++i) {
            switch (tagVars[i].getScope()) {
                case 0: {
                    if (!nestedArrayDecl) {
                        st.iprintln("_nestedVars = new java.util.ArrayList();");
                        nestedArrayDecl = true;
                    }
                    st.iprint("_nestedVars.add(");
                    break;
                }
                case 1: {
                    if (!atBeginArrayDecl) {
                        st.iprintln("_atBeginVars = new java.util.ArrayList();");
                        atBeginArrayDecl = true;
                    }
                    st.iprint("_atBeginVars.add(");
                    break;
                }
                case 2: {
                    if (!atEndArrayDecl) {
                        st.iprintln("_atEndVars = new java.util.ArrayList();");
                        atEndArrayDecl = true;
                    }
                    st.iprint("_atEndVars.add(");
                }
            }
            st.print("\"" + tagVars[i].getNameGiven() + "\"");
            st.println(");");
        }
        if (!atBeginArrayDecl) {
            st.iprintln("_atBeginVars = null;");
        }
        if (!atEndArrayDecl) {
            st.iprintln("_atEndVars = null;");
        }
        if (!nestedArrayDecl) {
            st.iprintln("_nestedVars = null;");
        }
        if (aliasExists) {
            st.iprintln("this.jspContext = new oracle.jsp.runtime.OracleJspContextWrapper(ctx, _atBeginVars, _atEndVars, _nestedVars, _aliasMap);");
        } else {
            st.iprintln("this.jspContext = new oracle.jsp.runtime.OracleJspContextWrapper(ctx, _atBeginVars, _atEndVars, _nestedVars, null);");
        }
        st.undent();
        st.iprintln("}");
        st.println("");
        st.iprintln("public JspContext getJspContext() ");
        st.iprintln("{");
        st.indent();
        st.iprintln("return this.jspContext;");
        st.undent();
        st.iprintln("}");
        st.println("");
    }

    protected void emitAttributeMethods(JspEmitState st) {
        TagAttributeInfo[] tagAttributes = this.taginfo.getAttributes();
        if (tagAttributes != null) {
            for (int i = 0; i < tagAttributes.length; ++i) {
                st.iprint("public void ");
                st.print(JspUtils.setterMethod(tagAttributes[i].getName()));
                if (tagAttributes[i].isFragment()) {
                    st.print("(javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    st.print("(");
                    st.print(tagAttributes[i].getTypeName());
                    st.print(" ");
                }
                st.print(tagAttributes[i].getName());
                st.println(")");
                st.iprintln("{");
                st.indent();
                st.iprint("this.");
                st.print(tagAttributes[i].getName());
                st.print(" = ");
                st.print(tagAttributes[i].getName());
                st.println(";");
                st.undent();
                st.iprintln("}");
                st.println("");
                st.iprint("public ");
                if (tagAttributes[i].isFragment()) {
                    st.print("javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    st.print(tagAttributes[i].getTypeName());
                    st.print(" ");
                }
                st.println(JspUtils.getterMethod(tagAttributes[i].getName()) + "()");
                st.iprintln("{");
                st.indent();
                st.iprint("return this.");
                st.print(tagAttributes[i].getName());
                st.println(";");
                st.undent();
                st.iprintln("}");
                st.println("");
            }
        }
        if (this.taginfo.hasDynamicAttributes()) {
            st.iprintln("public void setDynamicAttribute(String uri, String localName, Object value) throws javax.servlet.jsp.JspException ");
            st.iprintln("{");
            st.indent();
            st.iprintln("if (uri == null)");
            st.indent();
            st.iprintln("_dynamicAttrs.put(localName, value);");
            st.undent();
            st.undent();
            st.iprintln("}");
        }
        st.println("");
    }

    protected void emitDoTagMethod(JspEmitState st, JspParseTagFile srcRoot) {
        st.iprintln("public void doTag() throws javax.servlet.jsp.JspException, java.io.IOException { ");
        st.indent();
        st.iprintln("PageContext pageContext = (PageContext) jspContext;");
        st.iprintln("try { ");
        st.indent();
        this.emitImplicitObjects(st);
        this.emitPageScopeAttributes(st);
        st.println("");
        if (!st.parseState.omitXmlDecl) {
            st.iprintln("out.println(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + srcRoot.getSrcEncoding() + "\\\" ?>\");");
        }
        st.println("");
    }

    protected void emitImplicitObjects(JspEmitState st) {
        st.indent();
        st.iprintln("HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();");
        st.iprintln("HttpServletResponse response = (HttpServletResponse) pageContext.getResponse();");
        st.iprintln("HttpSession session = pageContext.getSession();");
        st.iprintln("ServletContext application = pageContext.getServletContext();");
        st.iprintln("JspWriter out = jspContext.getOut();");
        st.iprintln("ServletConfig config = pageContext.getServletConfig();");
        st.iprintln("int __jsp_tag_starteval;");
        if (!st.parseState.parms.elIgnored) {
            st.iprintln("javax.servlet.jsp.el.VariableResolver __ojsp_varRes = (VariableResolver)new OracleVariableResolverImpl(pageContext);");
        }
        String[] classList = st.parseState.getTagUsageClassList();
        if (st.parms.compileTimeTagReuse && classList != null && classList.length > 0) {
            String[] usageList = st.parseState.getTagUsageUsageList();
            if (st.parseState.classicTagsInFragmentClass) {
                st.iprintln("javax.servlet.jsp.tagext.JspTag[] __ojsp_classicTags = new javax.servlet.jsp.tagext.JspTag[" + classList.length + "];");
            }
            st.iprintln("// compile time tag reuse - begin");
            String ctType = "compiletime";
            if (st.parms.compileTimeTagReleaseReuse) {
                ctType = "compiletime_with_release";
            }
            for (int i = 0; i < classList.length; ++i) {
                String tagHandlerName = "__jsp_tag_ctru" + i;
                st.iprintln("// usage : " + usageList[i]);
                st.iprintln(classList[i] + " " + tagHandlerName + " = (" + classList[i] + ") OracleJspRuntime.getTagHandler(pageContext, " + classList[i] + ".class, \"" + ctType + "\");");
                if (st.parseState.classicTagsInFragmentClass) {
                    st.iprintln("__ojsp_classicTags[" + i + "] = " + tagHandlerName + ";");
                }
                if (st.parms.compileTimeTagReleaseReuse) continue;
                st.iprintln(tagHandlerName + ".setPageContext(pageContext);");
            }
            st.iprintln("// compile tag reuse - end");
        }
    }

    protected void emitPageScopeAttributes(JspEmitState st) {
        TagAttributeInfo[] tagAttributes = this.taginfo.getAttributes();
        for (int i = 0; i < tagAttributes.length; ++i) {
            String attrName = tagAttributes[i].getName();
            st.iprint("pageContext.setAttribute(");
            st.print("\"" + attrName + "\"");
            st.print(", ");
            st.print(JspUtils.getterMethod(attrName));
            st.println("());");
        }
        if (this.taginfo.hasDynamicAttributes()) {
            st.iprint("pageContext.setAttribute(\"");
            String dynamicAttrsMapName = st.getDirectiveAttrValue("page", "dynamic-attributes");
            st.print(dynamicAttrsMapName);
            st.print("\"");
            st.println(", _dynamicAttrs);");
        }
    }

    protected void emitDoTagTrailer(JspEmitState st) {
        st.undent();
        st.iprintln("} catch( Throwable t ) {");
        st.indent();
        st.iprintln("if (t instanceof javax.servlet.jsp.SkipPageException)");
        st.iprintln("    throw (javax.servlet.jsp.SkipPageException) t;");
        st.iprintln("if (t instanceof IllegalStateException)");
        st.iprintln("    throw (IllegalStateException) t;");
        st.iprintln("if (t instanceof java.io.IOException)");
        st.iprintln("    throw (java.io.IOException) t;");
        st.iprintln("if (t instanceof javax.servlet.jsp.JspException)");
        st.iprintln("    throw (javax.servlet.jsp.JspException) t;");
        st.iprintln("throw new javax.servlet.jsp.JspException(t);");
        st.undent();
        st.iprintln("}");
        st.iprintln("finally {");
        st.indent();
        st.iprintln("((oracle.jsp.runtime.OracleJspContextWrapper) jspContext).syncVariableEndTagFile();");
        st.iprintln("OracleJspRuntime.releaseTagHandlers(pageContext);");
        st.undent();
        st.iprintln("}");
        st.undent();
        st.iprintln("}");
    }

    private void emitGetTagInfoMethod(JspEmitState st) {
        st.println("");
        st.iprintln("public TagInfo getTagInfo(TagLibraryInfo tlib)");
        st.iprintln("{");
        st.indent();
        st.iprintln("if (tagInfo != null)");
        st.indent();
        st.iprintln("return tagInfo;");
        st.undent();
        st.println("");
        Iterator tagVars = st.parseState.tagFileVariableVector.iterator();
        if (tagVars.hasNext()) {
            TagVariableInfo info = (TagVariableInfo)tagVars.next();
            st.iprintln("TagVariableInfo[] tagVariableInfos = {");
            st.indent();
            st.iprint(JspUtils.getVarInfoString(info));
            while (tagVars.hasNext()) {
                TagVariableInfo varInfo = (TagVariableInfo)tagVars.next();
                st.println(",");
                st.iprint(JspUtils.getVarInfoString(varInfo));
            }
            st.println("};");
            st.undent();
            st.println("");
        } else {
            st.iprintln("TagVariableInfo[] tagVariableInfos = new TagVariableInfo[0];");
        }
        Iterator tagAttrs = st.parseState.tagFileAttributeVector.iterator();
        if (tagAttrs.hasNext()) {
            TagAttributeInfo info = (TagAttributeInfo)tagAttrs.next();
            st.iprintln("TagAttributeInfo[] tagAttributeInfo = {");
            st.indent();
            st.iprint(JspUtils.getAttrInfoString(info));
            while (tagAttrs.hasNext()) {
                TagAttributeInfo attrInfo = (TagAttributeInfo)tagAttrs.next();
                st.println(",");
                st.iprint(JspUtils.getAttrInfoString(attrInfo));
            }
            st.println("};");
            st.undent();
            st.println("");
        } else {
            st.iprintln("TagAttributeInfo[] tagAttributeInfo = new TagAttributeInfo[0];");
        }
        st.iprintln("tagInfo = " + this.tagInfoStr);
        st.iprintln("return tagInfo;");
        st.undent();
        st.iprintln("}");
        st.println("");
    }

    protected void emitFragmentCode(JspEmitState st) {
        if (st.parseState.fragmentSupportClass != null && st.parseState.fragmentSupportClass.fragmentExists()) {
            st.parseState.fragmentSupportClass.emit(st);
        }
    }

    protected void emitTrailer(JspEmitState st) {
        st.println("}");
    }

    public static boolean canHandleThrowable() {
        try {
            Class pcClass = PageContext.class;
            Class[] args = new Class[]{Throwable.class};
            Method m = pcClass.getMethod("handlePageException", args);
            return m != null;
        }
        catch (Throwable th) {
            return false;
        }
    }
}

