/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import javax.servlet.jsp.tagext.TagVariableInfo;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.XMLUtil;

public class TagFileDirectiveVariable
extends JspDirective
implements Serializable {
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[7];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("variable", true);

    public TagFileDirectiveVariable() {
        if (attrs[0] == null) {
            TagFileDirectiveVariable.dirAttr.validValues = new String[0];
            TagFileDirectiveVariable.attrs[0] = new JspDirectiveAttrDesc("name-given", true, false);
            TagFileDirectiveVariable.attrs[0].required = false;
            TagFileDirectiveVariable.attrs[1] = new JspDirectiveAttrDesc("name-from-attribute", true, false);
            TagFileDirectiveVariable.attrs[1].required = false;
            TagFileDirectiveVariable.attrs[2] = new JspDirectiveAttrDesc("alias", true, false);
            TagFileDirectiveVariable.attrs[2].required = false;
            TagFileDirectiveVariable.attrs[3] = new JspDirectiveAttrDesc("variable-class", true, false);
            TagFileDirectiveVariable.attrs[3].required = false;
            TagFileDirectiveVariable.attrs[4] = new JspDirectiveAttrDesc("declare", true, false);
            TagFileDirectiveVariable.attrs[4].required = false;
            TagFileDirectiveVariable.attrs[5] = new JspDirectiveAttrDesc("scope", true, false);
            TagFileDirectiveVariable.attrs[5].required = false;
            TagFileDirectiveVariable.attrs[6] = new JspDirectiveAttrDesc("description", true, false);
            TagFileDirectiveVariable.attrs[6].required = false;
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public void validateAttributes(JspParseState st) throws JspParseException {
        super.validateAttributes(st);
        String nameGiven = this.getAttrValue("name-given");
        String nameFromAttribute = this.getAttrValue("name-from-attribute");
        String alias = this.getAttrValue("alias");
        if (nameGiven != null && nameFromAttribute != null && st.throwParseException(new JspParseException(st, msgs.getString("cannot_specify_both_name")))) {
            return;
        }
        if ((nameFromAttribute != null && alias == null || nameFromAttribute == null && alias != null) && st.throwParseException(new JspParseException(st, msgs.getString("specify_alias_with_nameFromAttribute")))) {
            return;
        }
        if (nameGiven == null && nameFromAttribute == null && st.throwParseException(new JspParseException(st, msgs.getString("specify_atleast_one_name")))) {
            return;
        }
        int scope = XMLUtil.convVarScopeStr(this.getAttrValue("scope"), st);
        String variableClass = this.getAttrValue("variable-class");
        if (variableClass == null) {
            variableClass = "java.lang.String";
        }
        boolean declare = JspUtils.translateBoolean(this.getAttrValue("declare"), true);
        if (nameFromAttribute != null) {
            nameGiven = alias;
        }
        if (st.tagFileHt.get(nameGiven) != null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfile_attrVar_nameexists"), nameGiven)))) {
            return;
        }
        TagVariableInfo varInfo = new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, scope);
        st.tagFileVariableVector.addElement(varInfo);
        st.tagFileHt.put(nameGiven, varInfo);
    }
}

