/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import oracle.jsp.parse.LineInfoMapObj;

public class SDE {
    public static final String CR = System.getProperty("line.separator", "\n");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSMAP(String javaPage, LineInfoMapObj[] unsortedLineMap) {
        Vector<Object> tMapVector = new Vector<Object>();
        TreeMap<Integer, LineInfoMapObj> tMap = new TreeMap<Integer, LineInfoMapObj>();
        String currentFileName = null;
        int numberOfTMapEntries = 0;
        Hashtable<String, TreeMap<Integer, LineInfoMapObj>> wholeIncludingFileTable = new Hashtable<String, TreeMap<Integer, LineInfoMapObj>>();
        Stack<String> includingFileStack = new Stack<String>();
        String includingFile = null;
        String includingFileToCheck = null;
        Vector<Object> vector = tMapVector;
        synchronized (vector) {
            for (int i = 0; i < unsortedLineMap.length; ++i) {
                LineInfoMapObj limo = unsortedLineMap[i];
                if (currentFileName == null) {
                    currentFileName = limo.jspFileName;
                    tMap = new TreeMap();
                }
                if (currentFileName != limo.jspFileName) {
                    includingFileToCheck = null;
                    if (wholeIncludingFileTable.containsKey(currentFileName)) {
                        TreeMap existingFilePart = (TreeMap)wholeIncludingFileTable.get(currentFileName);
                        existingFilePart.putAll(tMap);
                    } else {
                        wholeIncludingFileTable.put(currentFileName, tMap);
                    }
                    if (includingFile != null && limo.jspFileName.equals(includingFile)) {
                        includingFileToCheck = includingFile;
                        includingFile = includingFileStack.empty() ? null : (String)includingFileStack.pop();
                    } else {
                        includingFileStack.push(includingFile);
                        includingFile = currentFileName;
                    }
                    tMapVector.add(tMap.clone());
                    tMap = new TreeMap<Integer, LineInfoMapObj>();
                    currentFileName = limo.jspFileName;
                }
                LineInfoMapObj prev = null;
                if (includingFileToCheck != null && limo.jspFileName.equals(includingFileToCheck) && wholeIncludingFileTable.containsKey(includingFileToCheck)) {
                    TreeMap prevTMap = (TreeMap)wholeIncludingFileTable.get(includingFileToCheck);
                    prev = (LineInfoMapObj)prevTMap.get(new Integer(limo.jspLineNum));
                }
                if (tMap.containsKey(new Integer(limo.jspLineNum))) {
                    prev = (LineInfoMapObj)tMap.get(new Integer(limo.jspLineNum));
                    prev.fromTextTag = false;
                    if (limo.javaEndLineNum != -1) {
                        prev.javaEndLineNum = limo.javaEndLineNum;
                    }
                    tMap.put(new Integer(limo.jspLineNum), prev);
                    continue;
                }
                if (prev != null) continue;
                tMap.put(new Integer(limo.jspLineNum), limo);
                ++numberOfTMapEntries;
            }
        }
        tMapVector.add(tMap.clone());
        LineInfoMapObj[] lineMap = new LineInfoMapObj[numberOfTMapEntries];
        int k = 0;
        Enumeration e = tMapVector.elements();
        while (e.hasMoreElements()) {
            tMap = (TreeMap<Integer, LineInfoMapObj>)e.nextElement();
            Iterator i = tMap.keySet().iterator();
            while (i.hasNext()) {
                lineMap[k++] = (LineInfoMapObj)tMap.get(i.next());
            }
        }
        SMAP smap = new SMAP(javaPage, "JSP");
        StratumSection ssec = new StratumSection("JSP");
        FileSection fsec = new FileSection();
        LineSection lsec = new LineSection();
        VendorSection vsec = new VendorSection("oracle");
        smap.append(ssec);
        smap.append(fsec);
        smap.append(lsec);
        smap.append(vsec);
        vsec.addVendorInfo("built-by: ojsp (v Oracle Containers for J2EE 10g (10.1.3.4.0))");
        for (int i = 0; i < lineMap.length; ++i) {
            LineInfoMapObj lineInfo = lineMap[i];
            File jspFile = new File(lineInfo.jspFileName);
            int id = fsec.addFileInfo(jspFile.getName(), lineInfo.jspFileName);
            int jspLineNum = lineInfo.jspLineNum;
            int javaLineNum = lineInfo.javaLineNum;
            int nextJavaLineNum = -1;
            int nextJspLineNum = -1;
            if (jspLineNum < 1) {
                jspLineNum = 1;
            }
            if (i + 1 < lineMap.length) {
                nextJavaLineNum = lineMap[i + 1].javaLineNum;
                LineInfoMapObj nextLineInfo = null;
                for (int j = i + 1; j < lineMap.length; ++j) {
                    nextLineInfo = lineMap[j];
                    if (!lineInfo.jspFileName.equals(nextLineInfo.jspFileName)) continue;
                    nextJspLineNum = nextLineInfo.jspLineNum;
                    break;
                }
                if (nextLineInfo == null) {
                    nextJspLineNum = -1;
                }
                nextJspLineNum = jspLineNum > nextJspLineNum - 1 ? -1 : --nextJspLineNum;
                nextJavaLineNum = javaLineNum > nextJavaLineNum - 1 ? -1 : --nextJavaLineNum;
            }
            if (lineInfo.javaEndLineNum != -1) {
                nextJavaLineNum = lineInfo.javaEndLineNum;
            }
            lsec.addLineInfo(id, jspLineNum, nextJspLineNum, javaLineNum, nextJavaLineNum, lineInfo.fromTextTag, lineInfo.lastRealJspLineNum);
        }
        StringBuffer buffer = new StringBuffer(256);
        smap.serialize(buffer);
        String smap_str = buffer.toString();
        return smap_str;
    }

    public static class FutureSection
    implements Section {
        public void serialize(StringBuffer buffer) {
        }
    }

    public static class VendorSection
    implements Section {
        private String vendorID = "";
        private List infos;

        public VendorSection(String vendorID) {
            this.vendorID = vendorID;
            this.infos = new ArrayList();
        }

        public void addVendorInfo(String info) {
            this.infos.add(info);
        }

        public void serialize(StringBuffer buffer) {
            buffer.append("*V");
            buffer.append(CR);
            buffer.append(this.vendorID);
            buffer.append(CR);
            Iterator i = this.infos.iterator();
            while (i.hasNext()) {
                String info = (String)i.next();
                buffer.append(info);
                buffer.append(CR);
            }
        }
    }

    public static class LineSection
    implements Section {
        private List linemaps = new ArrayList();

        public void addLineInfo(int fileID, int inputStartLine, int inputEndLine, int outputStartLine, int outputEndLine, boolean fromTextTag, int lastRealJspLineNum) {
            this.linemaps.add(new LineMap(fileID, inputStartLine, inputEndLine, outputStartLine, outputEndLine, fromTextTag, lastRealJspLineNum));
        }

        public void serialize(StringBuffer buffer) {
            buffer.append("*L");
            buffer.append(CR);
            List lineinfos = this.optimize(this.linemaps);
            int previousFileID = 0;
            Iterator i = lineinfos.iterator();
            while (i.hasNext()) {
                LineInfo lineinfo = (LineInfo)i.next();
                buffer.append(lineinfo.inputStartLine);
                if (previousFileID == 0 || lineinfo.lineFileID != previousFileID) {
                    buffer.append("#");
                    buffer.append(lineinfo.lineFileID);
                    previousFileID = lineinfo.lineFileID;
                }
                if (lineinfo.repeatCount != 1) {
                    buffer.append(",");
                    buffer.append(lineinfo.repeatCount);
                }
                buffer.append(":");
                buffer.append(lineinfo.outputStartLine);
                if (lineinfo.outputLineIncrement != 1) {
                    buffer.append(",");
                    buffer.append(lineinfo.outputLineIncrement);
                }
                buffer.append(CR);
            }
        }

        private List optimize(List linemaps) {
            ArrayList<LineInfo> lineinfos = new ArrayList<LineInfo>();
            LineMap nextLineMap = null;
            LineInfo lineinfo = null;
            boolean currentInputLine = false;
            boolean currentOutputLine = false;
            boolean addThisLine = true;
            for (int i = 0; i < linemaps.size(); ++i) {
                LineMap linemap = (LineMap)linemaps.get(i);
                lineinfo = new LineInfo(linemap.inputStartLine, linemap.fileID, 1, linemap.outputStartLine, 1);
                if (linemap.inputEndLine == -1) {
                    linemap.inputEndLine = linemap.lastRealJspLineNum != 0 ? linemap.lastRealJspLineNum : linemap.inputStartLine + 1;
                }
                if (linemap.outputEndLine == -1) {
                    if (i < linemaps.size() - 1) {
                        nextLineMap = (LineMap)linemaps.get(i + 1);
                        linemap.outputEndLine = nextLineMap.outputStartLine - 1;
                    } else {
                        linemap.outputEndLine = linemap.outputStartLine + 1;
                    }
                }
                if (linemap.fromTextTag) {
                    if (linemap.lastRealJspLineNum != 0 && linemap.inputStartLine > linemap.lastRealJspLineNum) {
                        addThisLine = false;
                        if (linemaps.size() > 1) {
                            LineInfo prev = (LineInfo)lineinfos.get(lineinfos.size() - 1);
                            if (prev.inputStartLine == linemap.lastRealJspLineNum && prev.repeatCount == 1) {
                                ++prev.outputLineIncrement;
                            }
                        }
                    }
                    if (linemap.inputEndLine >= linemap.inputStartLine) {
                        lineinfo.repeatCount = linemap.inputEndLine - linemap.inputStartLine + 1;
                        lineinfo.outputLineIncrement = 0;
                    }
                } else if (linemap.outputEndLine >= linemap.outputStartLine) {
                    lineinfo.outputLineIncrement = linemap.outputEndLine - linemap.outputStartLine + 1;
                }
                if (addThisLine) {
                    lineinfos.add(lineinfo);
                    continue;
                }
                addThisLine = true;
            }
            LineInfo cur = null;
            LineInfo next = null;
            boolean matched = true;
            for (int k = 0; k < lineinfos.size() - 1; ++k) {
                matched = true;
                cur = (LineInfo)lineinfos.get(k);
                if (cur.outputLineIncrement == 0) continue;
                while (matched && k < lineinfos.size() - 1) {
                    next = (LineInfo)lineinfos.get(k + 1);
                    if (cur.lineFileID == next.lineFileID && cur.repeatCount != 0 && next.inputStartLine == cur.inputStartLine + cur.repeatCount && next.outputLineIncrement == 1 && next.repeatCount == 1 && next.outputStartLine == cur.outputStartLine + cur.repeatCount) {
                        ++cur.repeatCount;
                        lineinfos.remove(k + 1);
                        continue;
                    }
                    matched = false;
                }
            }
            ArrayList<LineInfo> lineinfos2 = new ArrayList<LineInfo>();
            LineInfo lineinfo2 = null;
            LineInfo temp = null;
            for (int i = 0; i < lineinfos.size(); ++i) {
                lineinfo2 = (LineInfo)lineinfos.get(i);
                if (lineinfo2.outputLineIncrement == 0) {
                    for (int j = 0; j < lineinfo2.repeatCount; ++j) {
                        temp = new LineInfo(lineinfo2.inputStartLine + j, lineinfo2.lineFileID, 1, lineinfo2.outputStartLine, 1);
                        lineinfos2.add(temp);
                    }
                    continue;
                }
                if (lineinfo2.repeatCount != 1) {
                    lineinfo2.outputLineIncrement = 1;
                }
                lineinfos2.add(lineinfo2);
            }
            return lineinfos2;
        }

        private static class LineInfo {
            public int inputStartLine;
            public int lineFileID;
            public int repeatCount;
            public int outputStartLine;
            public int outputLineIncrement;

            public LineInfo(int inputStartLine, int lineFileID, int repeatCount, int outputStartLine, int outputLineIncrement) {
                this.inputStartLine = inputStartLine;
                this.lineFileID = lineFileID;
                this.repeatCount = repeatCount;
                this.outputStartLine = outputStartLine;
                this.outputLineIncrement = outputLineIncrement;
            }
        }

        private static class LineMap {
            public int fileID;
            public int inputStartLine;
            public int inputEndLine;
            public int outputStartLine;
            public int outputEndLine;
            public boolean fromTextTag;
            public int lastRealJspLineNum;

            public LineMap(int fileID, int inputStartLine, int inputEndLine, int outputStartLine, int outputEndLine, boolean fromTextTag, int lastRealJspLineNum) {
                this.fileID = fileID;
                this.inputStartLine = inputStartLine;
                this.inputEndLine = inputEndLine;
                this.outputStartLine = outputStartLine;
                this.outputEndLine = outputEndLine;
                this.fromTextTag = fromTextTag;
                this.lastRealJspLineNum = lastRealJspLineNum;
            }
        }
    }

    public static class FileSection
    implements Section {
        private Map files = new HashMap();

        public int addFileInfo(String fileName) {
            return this.addFileInfo(fileName, "");
        }

        public int addFileInfo(String fileName, String absoluteFileName) {
            String key = fileName + "|" + absoluteFileName;
            if (this.files.containsKey(key)) {
                FileInfo fi = (FileInfo)this.files.get(key);
                return fi.fileID;
            }
            int fileID = this.files.size() + 1;
            FileInfo fi = new FileInfo(fileID, fileName, absoluteFileName);
            this.files.put(key, fi);
            return fileID;
        }

        public void serialize(StringBuffer buffer) {
            buffer.append("*F");
            buffer.append(CR);
            Iterator i = this.files.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                FileInfo fi = (FileInfo)this.files.get(key);
                buffer.append("+");
                buffer.append(" ");
                buffer.append(fi.fileID);
                buffer.append(" ");
                buffer.append(fi.fileName);
                buffer.append(CR);
                buffer.append(fi.absoluteFileName.startsWith("/") ? fi.absoluteFileName.substring(1, fi.absoluteFileName.length()) : fi.absoluteFileName);
                buffer.append(CR);
            }
        }

        private static class FileInfo {
            public int fileID;
            public String fileName;
            public String absoluteFileName;
            public boolean hasAbsolute;

            public FileInfo(int fileID, String fileName, String absoluteFileName) {
                this.fileID = fileID;
                this.fileName = fileName;
                this.absoluteFileName = absoluteFileName;
                this.hasAbsolute = true;
            }
        }
    }

    public static class StratumSection
    implements Section {
        private String name = "";

        public StratumSection(String name) {
            this.name = name;
        }

        public void serialize(StringBuffer buffer) {
            buffer.append("*S");
            buffer.append(" ");
            buffer.append(this.name);
            buffer.append(CR);
        }
    }

    public static class SMAP
    implements Section {
        private String outputFileName = "";
        private String defaultStratumID = "";
        private List sections;

        public SMAP(String outputFileName, String defaultStratumID) {
            this.outputFileName = outputFileName;
            this.defaultStratumID = defaultStratumID;
            this.sections = new ArrayList();
        }

        public void append(Section section) {
            this.sections.add(section);
        }

        public void serialize(StringBuffer buffer) {
            buffer.append("SMAP");
            buffer.append(CR);
            buffer.append(this.outputFileName);
            buffer.append(CR);
            buffer.append(this.defaultStratumID);
            buffer.append(CR);
            Iterator i = this.sections.iterator();
            while (i.hasNext()) {
                Section section = (Section)i.next();
                section.serialize(buffer);
            }
            buffer.append("*E");
            buffer.append(CR);
        }
    }

    public static interface Section {
        public void serialize(StringBuffer var1);
    }
}

