/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import oracle.jsp.parse.DependencyFile;
import oracle.jsp.parse.Jsp2Java;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspCompilationAuxObj;
import oracle.jsp.parse.JspDirectiveTaglibInfo;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspEmitter;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspRTTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.SingleExceptionHandler;
import oracle.jsp.parse.TagFileEmitter;
import oracle.jsp.parse.TagFileParseDirectives;
import oracle.jsp.parse.TranslatorPluginSupport;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.util.JspUtil;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

public class OracleJsp2Java
implements Jsp2Java {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final String PARTIALLY_PARSED_FILE_MARKER = "oracle_partially_parsed_file_marker";
    private TranslatorPluginSupport tps = new TranslatorPluginSupport();
    protected TagInfo tagInfo;
    protected String tagInfoStr;
    private String scannedFileName = null;
    private boolean scanFileAgainForBOM = true;
    private boolean parseWithDefaultEnc = false;
    private int BOMLen = 0;
    private String byteOrderMarkEncoding = null;

    public OracleJsp2Java() {
        this.tps.addPlugin(new SingleExceptionHandler());
    }

    public TranslatorPluginSupport getTranslatorPluginSupport() {
        return this.tps;
    }

    /*
     * Unable to fully structure code
     */
    public int transform(Jsp2JavaParms parms, Reader in, Writer out, OutputStream resOut, int type) throws JspParseException, JspEncodingException, IOException {
        if (type != 2) {
            throw new JspParseException(0, "", OracleJsp2Java.msgs.getString("only_tagfile"));
        }
        this.tps.setAttribute("params", parms);
        file = null;
        st = new JspParseState(null, parms, this.tps);
        st.setPageType(type);
        st.initializeTagFileVariables();
        st.omitXmlDecl = true;
        this.tps.setAttribute("parse.state", st);
        this.tps.fireEvent(1L);
        if (st.parms.sourceFileName.endsWith(".tagx") && !st.parms.webXmlIsPre24) {
            parms.xmlStyleSrc = true;
        }
        if (parms.xmlStyleSrc) {
            xis = null;
            st.position.currentSourceFile = fileName = st.parms.sourceFileName;
            try {
                if (st.parms.jarName != null) {
                    xis = XMLUtil.getTagFileFromJarFile(st.parms.resourceProvider, fileName, st.parms.jarName);
                } else {
                    if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(st.parms.resourceProvider, fileName)) {
                        throw new FileNotFoundException(fileName);
                    }
                    xis = XMLUtil.getFromStream(st, fileName);
                }
                doc = XMLUtil.getDocument(xis, 0, null, null, true, true, false);
                dtd = (DTD)doc.getDoctype();
                if (dtd != null) {
                    if (xis != null) {
                        xis.close();
                    }
                    if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(st.parms.resourceProvider, fileName)) {
                        throw new FileNotFoundException(fileName);
                    }
                    xis = XMLUtil.getFromStream(st, fileName);
                    doc = XMLUtil.getDocument(xis, 2, null, null, true, true, false);
                }
                file = st.parms.parseTagFileDirectivesOnly != false && type == 2 ? new TagFileParseDirectives(st, doc.getDocumentElement(), fileName) : new JspParseTagFile(st, doc.getDocumentElement(), fileName);
                file.xmlEncoding = ((XMLDocument)doc).getXmlEncoding();
                file.configEncoding = JspUtils.getPageEncoding(parms.sourceFileName, parms.happ);
                if (JspUtils.isMismatchEncoding(file.xmlEncoding, file.configEncoding) && st.throwParseException(new JspParseException(st, OracleJsp2Java.msgs.getString("xml_config_encoding_mismatch")))) {
                    var12_17 = -1;
                    return var12_17;
                }
                file.parse(st);
            }
            catch (XMLParseException xpe) {
                if (!st.throwParseException(new JspParseException(-1, "", fileName, xpe))) ** GOTO lbl65
                dtd = -1;
                return dtd;
            }
            catch (SAXException saxe) {
                if (!st.throwParseException(new JspParseException(-1, "", fileName, saxe))) ** GOTO lbl65
                dtd = -1;
                return dtd;
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException(MessageFormat.format(OracleJsp2Java.msgs.getString("file_not_found"), new Object[]{fileName}));
            }
            finally {
                if (xis != null) {
                    xis.close();
                }
            }
        } else {
            buffIn = new BufferedReader(in);
            if (type == 0 || type == 2) {
                file = st.parms.parseTagFileDirectivesOnly != false && type == 2 ? new TagFileParseDirectives(buffIn, st.parms.encoding) : new JspParseTagFile(st, buffIn, st.parms.encoding);
            }
            file.setFileName(parms.sourceFileName);
            file.configEncoding = JspUtils.getPageEncoding(parms.sourceFileName, parms.happ);
            this.tps.fireEvent(4L);
            file.parse(st);
            if (this.tps.fireEvent(8L) == 0) {
                return 0;
            }
        }
lbl65:
        // 5 sources

        this.checkJspTagLibValidator(st, file);
        this.validateDirectivesForTagFiles(st);
        this.createTagInfo(st);
        language = st.getDirectiveAttrValue("page", "language");
        if (language == null) {
            language = "java";
        }
        printOut = new PrintWriter(out);
        eState = new JspEmitState(printOut, resOut, st);
        eState.setPageType(type);
        this.tps.setAttribute("emit.state", eState);
        emit = null;
        emit = new TagFileEmitter(this.tagInfo, this.tagInfoStr);
        this.tps.fireEvent(32L);
        emit.emit(eState, file);
        this.tps.fireEvent(64L);
        printOut.flush();
        parms.lineMap = eState.getLineMapArray();
        parms.dependencies = st.dependencies;
        auxObj = new JspCompilationAuxObj();
        auxObj.lineMap = parms.lineMap;
        if (st.parms.parseTagFileDirectivesOnly && type == 2) {
            dependencyFile = new DependencyFile();
            dependencyFile.fileName = "oracle_partially_parsed_file_marker";
            auxObj.dependentFiles = new DependencyFile[]{dependencyFile};
        } else {
            auxObj.dependentFiles = parms.dependencies.getIncludeDependencyInfo();
        }
        parms.auxObj = auxObj;
        this.tps.fireEvent(2L);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public int transform(Jsp2JavaParms parms, InputStream inStream, Writer out, OutputStream resOut, int type) throws JspParseException, JspEncodingException, IOException {
        if (type != 0) {
            throw new JspParseException(0, "", OracleJsp2Java.msgs.getString("only_jsp"));
        }
        this.tps.setAttribute("params", parms);
        file = null;
        st = new JspParseState(null, parms, this.tps);
        st.setPageType(type);
        this.tps.setAttribute("parse.state", st);
        this.tps.fireEvent(1L);
        if (st.parms.xmlStyleSrc && st.parms.isXML != null && !st.parms.isXML.booleanValue() && st.throwParseException(new JspParseException(st, MessageFormat.format(OracleJsp2Java.msgs.getString("jsp_root_in_non_xml"), new Object[]{parms.sourceFileName})))) {
            return -1;
        }
        if (st.parms.isXML != null && st.parms.isXML.booleanValue() || st.parms.isXML == null && st.parms.sourceFileName.endsWith(".jspx") && !st.parms.webXmlIsPre24) {
            parms.xmlStyleSrc = true;
        }
        if (parms.xmlStyleSrc) {
            xis = null;
            st.position.currentSourceFile = fileName = st.parms.sourceFileName;
            try {
                if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(st.parms.resourceProvider, fileName)) {
                    throw new FileNotFoundException(fileName);
                }
                xis = inStream;
                doc = XMLUtil.getDocument(xis, 0, null, null, true, true, false);
                dtd = (DTD)doc.getDoctype();
                if (dtd != null) {
                    if (xis != null) {
                        xis.close();
                    }
                    if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(st.parms.resourceProvider, fileName)) {
                        throw new FileNotFoundException(fileName);
                    }
                    xis = XMLUtil.getFromStream(st, fileName);
                    doc = XMLUtil.getDocument(xis, 2, null, null, true, true, false);
                }
                file = new JspParseTagFile(st, doc.getDocumentElement(), fileName);
                file.xmlEncoding = ((XMLDocument)doc).getXmlEncoding();
                file.configEncoding = JspUtils.getPageEncoding(parms.sourceFileName, parms.happ);
                if (JspUtils.isMismatchEncoding(file.xmlEncoding, file.configEncoding) && st.throwParseException(new JspParseException(st, OracleJsp2Java.msgs.getString("xml_config_encoding_mismatch")))) {
                    var12_18 = -1;
                    return var12_18;
                }
                file.parse(st);
            }
            catch (XMLParseException xpe) {
                if (!st.throwParseException(new JspParseException(-1, "", fileName, xpe))) ** GOTO lbl85
                dtd = -1;
                return dtd;
            }
            catch (SAXException saxe) {
                if (!st.throwParseException(new JspParseException(-1, "", fileName, saxe))) ** GOTO lbl85
                dtd = -1;
                return dtd;
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException(MessageFormat.format(OracleJsp2Java.msgs.getString("file_not_found"), new Object[]{fileName}));
            }
            finally {
                if (xis != null) {
                    xis.close();
                }
            }
        } else {
            if ((this.scannedFileName == null || !this.scannedFileName.equalsIgnoreCase(st.parms.sourceFileName) || this.scanFileAgainForBOM) && inStream != null) {
                this.byteOrderMarkEncoding = JspUtil.scanForByteOrderMark(inStream);
                inStream.reset();
                this.scannedFileName = st.parms.sourceFileName;
                ianaEnc = null;
                if (this.byteOrderMarkEncoding != null && (ianaEnc = JspUtil.convIANAtoJavaEncoding(this.byteOrderMarkEncoding, true)) != null) {
                    this.BOMLen = JspUtil.getBOMLengthInBytes(this.byteOrderMarkEncoding);
                }
                if (ianaEnc != null && !ianaEnc.equalsIgnoreCase(st.parms.encoding)) {
                    this.scanFileAgainForBOM = false;
                    throw new JspEncodingException(st, st.parms.encoding, ianaEnc, false);
                }
            }
            if (this.BOMLen != 0 && !this.parseWithDefaultEnc && JspUtil.needToSkipBOM(this.byteOrderMarkEncoding, st.parms.encoding)) {
                inStream.skip(this.BOMLen);
            }
            buffIn = st.parms.encoding == null ? new BufferedReader(new InputStreamReader(inStream)) : new BufferedReader(new InputStreamReader(inStream, st.parms.encoding));
            if (type == 0 || type == 2) {
                file = new JspParseTagFile(st, buffIn, st.parms.encoding);
            }
            file.setFileName(parms.sourceFileName);
            file.configEncoding = JspUtils.getPageEncoding(parms.sourceFileName, parms.happ);
            this.tps.fireEvent(4L);
            try {
                this.scanFileAgainForBOM = true;
                file.parse(st);
                this.parseWithDefaultEnc = false;
                if (this.BOMLen != 0 && JspUtils.isMismatchEncoding(st.parms.encoding, "ISO-8859-1") && file.configEncoding == null && file.pageEncoding == null && file.contentEncoding == null) {
                    this.parseWithDefaultEnc = true;
                    throw new JspEncodingException(st, st.parms.encoding, "ISO-8859-1", false);
                }
            }
            catch (JspEncodingException jee) {
                this.scanFileAgainForBOM = false;
                throw jee;
            }
            if (this.tps.fireEvent(8L) == 0) {
                return 0;
            }
        }
lbl85:
        // 5 sources

        this.checkJspTagLibValidator(st, file);
        language = st.getDirectiveAttrValue("page", "language");
        if (language == null) {
            language = "java";
        }
        if (parms.jsfShortCut) {
            parms.tree = file.createTree(st, parms.parseContext);
        } else {
            printOut = new PrintWriter(out);
            eState = new JspEmitState(printOut, resOut, st);
            eState.setPageType(type);
            this.tps.setAttribute("emit.state", eState);
            emit = null;
            if (type == 0) {
                emit = new JspEmitter();
            }
            this.tps.fireEvent(32L);
            emit.emit(eState, file);
            this.tps.fireEvent(64L);
            printOut.flush();
            parms.lineMap = eState.getLineMapArray();
        }
        parms.dependencies = st.dependencies;
        auxObj = new JspCompilationAuxObj();
        auxObj.lineMap = parms.lineMap;
        auxObj.dependentFiles = parms.dependencies.getIncludeDependencyInfo();
        parms.auxObj = auxObj;
        this.tps.fireEvent(2L);
        return 0;
    }

    public int transform(Jsp2JavaParms parms, InputStream inStream, Writer out, int type) throws JspParseException, IOException {
        return this.transform(parms, inStream, out, null, type);
    }

    private void checkJspTagLibValidator(JspParseState st, JspParseTagFile srcRoot) throws JspParseException {
        Hashtable<String, String> processed = new Hashtable<String, String>();
        Enumeration enumerator = st.jspDirectiveTaglibInfoTable.elements();
        while (enumerator.hasMoreElements()) {
            JspDirectiveTaglibInfo dtli = (JspDirectiveTaglibInfo)enumerator.nextElement();
            String xmlURI = dtli.getXMLStyleURI();
            if (xmlURI == null || processed.containsKey(xmlURI) || dtli.rtTagLibObj == null || dtli.rtTagLibObj.validatorInfo == null) continue;
            this.invokeValidator(st, dtli, srcRoot);
            processed.put(xmlURI, dtli.prefix);
        }
        for (int i = 0; i < st.jspRTTagList.size(); ++i) {
            JspRTTag rtTag = (JspRTTag)st.jspRTTagList.elementAt(i);
            TagInfo tagInfo = rtTag.getTagInfo();
            TagData tagData = rtTag.getTagAttrData();
            TagExtraInfo tagExtraInfo = tagInfo.getTagExtraInfo();
            if (tagExtraInfo == null) continue;
            ValidationMessage[] messages = tagExtraInfo.validate(tagData);
            this.reportValidationMsgs(tagExtraInfo.getClass().getName(), messages, st, srcRoot);
        }
    }

    private void validateDirectivesForTagFiles(JspParseState st) throws JspParseException {
        this.checkAttributeDirective(st);
    }

    private void checkAttributeDirective(JspParseState st) throws JspParseException {
        Iterator tagAttributes = st.tagFileAttributeVector.iterator();
        String dynamicAttrsMap = st.getDirectiveAttrValue("page", "dynamic-attributes");
        while (tagAttributes.hasNext()) {
            TagAttributeInfo attrInfo = (TagAttributeInfo)tagAttributes.next();
            if (dynamicAttrsMap != null && dynamicAttrsMap.equals(attrInfo.getName()) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfile_dynamic_attrs_attribute_name"), dynamicAttrsMap)))) {
                return;
            }
            Iterator tagVars = st.tagFileVariableVector.iterator();
            while (tagVars.hasNext()) {
                TagVariableInfo varInfo = (TagVariableInfo)tagVars.next();
                if (dynamicAttrsMap != null && dynamicAttrsMap.equals(varInfo.getNameGiven()) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfile_dynamic_attrs_var_name"), dynamicAttrsMap)))) {
                    return;
                }
                String attrName = attrInfo.getName();
                if (!attrName.equals(varInfo.getNameGiven()) || !st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfile_var_namegiven_equals_attribute_name"), attrName)))) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeValidator(JspParseState st, JspDirectiveTaglibInfo dtli, JspParseTagFile srcRoot) throws JspParseException {
        TagLibraryValidator tlv = null;
        try {
            tlv = dtli.rtTagLibObj.validatorInfo.createValidatorInst(st, dtli.uri, dtli.pos);
            ValidationMessage[] messages = tlv.validate(dtli.prefix, dtli.getXMLStyleURI(), (PageData)st.getPageData(srcRoot));
            this.reportValidationMsgs(tlv.getClass().getName(), messages, st, srcRoot);
        }
        finally {
            if (tlv != null) {
                tlv.release();
            }
        }
    }

    public void reportValidationMsgs(String validatorName, ValidationMessage[] messages, JspParseState st, JspParseTagFile srcRoot) throws JspParseException {
        if (messages != null && messages.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < messages.length; ++i) {
                sb.append(MessageFormat.format(msgs.getString("validator_reports"), validatorName));
                if (messages[i].getId() != null) {
                    sb.append(srcRoot.getNodeById(messages[i].getId()));
                }
                sb.append(messages[i].getMessage() + "\n");
            }
            if (st.throwParseException(new JspParseException(-1, "", "", sb.toString()))) {
                return;
            }
        }
    }

    protected void createTagInfo(JspParseState st) {
        String name = st.parms.tagFileName;
        TagInfo tag = null;
        Object[] tagVariableInfos = new TagVariableInfo[st.tagFileVariableVector.size()];
        st.tagFileVariableVector.copyInto(tagVariableInfos);
        Object[] tagAttributeInfo = new TagAttributeInfo[st.tagFileAttributeVector.size()];
        st.tagFileAttributeVector.copyInto(tagAttributeInfo);
        Object path = null;
        TagExtraInfo tei = null;
        String bodycontent = null;
        String description = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        bodycontent = st.getDirectiveAttrValue("page", "body-content");
        bodycontent = bodycontent == null ? "SCRIPTLESS" : bodycontent.toUpperCase();
        String dynamicAttrsMapName = st.getDirectiveAttrValue("page", "dynamic-attributes");
        smallIcon = st.getDirectiveAttrValue("page", "small-icon");
        largeIcon = st.getDirectiveAttrValue("page", "large-icon");
        description = st.getDirectiveAttrValue("page", "description");
        displayName = st.getDirectiveAttrValue("page", "display-name");
        boolean dynamicAttributes = false;
        if (dynamicAttrsMapName != null) {
            dynamicAttributes = true;
        }
        String tagInfoStr = null;
        tagInfoStr = "new TagInfo(\"" + name + "\"," + "\"" + st.parms.tagClassName + "\",";
        tagInfoStr = tagInfoStr + "\"" + bodycontent + "\",";
        tagInfoStr = tagInfoStr + "\"" + description + "\"," + "tlib,null,tagAttributeInfo,";
        tagInfoStr = tagInfoStr + "\"" + displayName + "\",";
        tagInfoStr = tagInfoStr + "\"" + smallIcon + "\",";
        tagInfoStr = tagInfoStr + "\"" + largeIcon + "\"," + "tagVariableInfos," + dynamicAttributes + ");";
        this.tagInfo = tag = new TagInfo(name, st.parms.tagClassName, bodycontent, description, st.parms.tlib, tei, (TagAttributeInfo[])tagAttributeInfo, displayName, smallIcon, largeIcon, (TagVariableInfo[])tagVariableInfos, dynamicAttributes);
        this.tagInfoStr = tagInfoStr;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }
}

