/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspTagAttribute;
import oracle.jsp.parse.OpenJspTagHandler;
import oracle.jsp.parse.PropertyUtil;

public class OpenJspTagSetProperty
extends OpenJspTagHandler {
    private JspBeanInfo bean;
    private JspBeanPropertyInfo info;
    private boolean setAllParams = false;
    private static final String[] subTags = new String[2];
    private static final String[] validProps = new String[]{"*"};
    private static final OpenJspAVDesc[] avList1 = new OpenJspAVDesc[]{new OpenJspAVDesc("name", 4, false), new OpenJspAVDesc("property", 4, true, true, validProps), new OpenJspAVDesc("param", 1, false), new OpenJspAVDesc("value", 11, false)};

    public OpenJspTagSetProperty() {
        this.htmlTag = "setProperty";
        if (subTags[0] == null) {
            OpenJspTagSetProperty.subTags[0] = ":attribute";
            OpenJspTagSetProperty.subTags[1] = OpenJspTagAttribute.class.getName();
        }
    }

    public String[] getSubTags() {
        return subTags;
    }

    public boolean allowsBody() {
        return true;
    }

    public boolean isTagValidInBody(JspParseState st, String tagStr, Class tagClass, JspParseTag tag) {
        return tagClass.equals(OpenJspTagAttribute.class);
    }

    public void addTagToBody(JspParseState st, JspParseTag tag) throws JspParseException {
        if (JspUtils.isTagWhitespace(tag)) {
            return;
        }
        if (tag.getClass().equals(JspParseTagText.class) && st.throwParseException(new JspParseException(st, msgs.getString("bad_text_inside")))) {
            return;
        }
        this.body.addElement(tag);
    }

    private boolean parentIsUsebean() {
        if (this.parent != null) {
            try {
                OpenJspTagHandler tag = (OpenJspTagHandler)this.parent;
                OpenJspAVInfo av = tag.findAV("scope");
                if (av == null) {
                    return false;
                }
                av = tag.findAV("id");
                return av != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return avList1;
    }

    public String validateAttributeList(JspParseState st, OpenJspAVInfo[] avList) {
        String beanName = null;
        this.bean = null;
        this.info = null;
        if (avList[0].valueExists()) {
            beanName = avList[0].getStringValue();
        }
        if (!this.parentIsUsebean() && beanName == null) {
            return msgs.getString("no_name");
        }
        this.bean = st.beans.getBeanInfo(beanName);
        if (this.bean == null) {
            return MessageFormat.format(msgs.getString("not_bean"), beanName);
        }
        String propName = avList[1].getStringValue();
        if (propName.equals("*")) {
            if (avList[2].valueExists()) {
                return msgs.getString("bad_param_attr");
            }
            if (avList[3].valueExists()) {
                return msgs.getString("bad_value_attr");
            }
            this.setAllParams = true;
            return null;
        }
        if (avList[3].valueExists() && avList[2].valueExists()) {
            return msgs.getString("both_param_value_attr");
        }
        this.info = st.beans.getSetPropertyInfo(beanName, propName);
        if (this.info == null && !st.parms.requestTimeIntrospection) {
            return MessageFormat.format(msgs.getString("bad_bean_prop"), propName, beanName);
        }
        if (avList[3].valueExists()) {
            if (this.info != null) {
                try {
                    PropertyUtil.checkSetValue(avList[3], this.info, st, this.bean.bean, this.getAV(1).getStringValue());
                }
                catch (JspParseException e) {
                    return e.getParentMsg();
                }
            }
        } else if (!avList[2].valueExists()) {
            avList[2].setStringValue(propName);
        }
        return null;
    }

    private void emitSetAllParams(JspEmitState st) {
        if (st.parms.requestTimeIntrospection && this.bean.getDuplicateBean()) {
            st.iprintln("OracleJspRuntime.__jspFindBeanSetAllParams(pageContext, \"" + this.bean.name + "\", " + "request, " + st.parms.needToRaiseBeanException + ");");
        } else {
            st.iprintln("OracleJspRuntime.__jspSetAllParams(request, (Object)" + this.bean.name + ", " + st.parms.needToRaiseBeanException + ");");
        }
    }

    private String convertParamValue(String inValue) {
        String v = this.info.type.equals(Integer.TYPE) ? "Integer.valueOf( " + inValue + ").intValue()" : (this.info.type.equals(Integer.class) ? "Integer.valueOf( " + inValue + ")" : (this.info.type.equals(String.class) ? inValue : (this.info.type.equals(Boolean.TYPE) ? "Boolean.valueOf( " + inValue + ").booleanValue()" : (this.info.type.equals(Boolean.class) ? "Boolean.valueOf( " + inValue + ")" : (this.info.type.equals(Byte.TYPE) ? "Byte.valueOf( " + inValue + ").byteValue()" : (this.info.type.equals(Byte.class) ? "Byte.valueOf( " + inValue + ")" : (this.info.type.equals(Character.TYPE) ? inValue + ".charAt( 0)" : (this.info.type.equals(Character.class) ? "new Character( " + inValue + ".charAt( 0))" : (this.info.type.equals(Double.TYPE) ? "Double.valueOf( " + inValue + ").doubleValue()" : (this.info.type.equals(Double.class) ? "Double.valueOf( " + inValue + ")" : (this.info.type.equals(Float.TYPE) ? "Float.valueOf( " + inValue + ").floatValue()" : (this.info.type.equals(Float.class) ? "Float.valueOf( " + inValue + ")" : (this.info.type.equals(Long.TYPE) ? "Long.valueOf( " + inValue + ").longValue()" : (this.info.type.equals(Long.class) ? "Long.valueOf( " + inValue + ")" : (this.info.type.equals(Short.TYPE) ? "Short.valueOf( " + inValue + ").shortValue()" : (this.info.type.equals(Short.class) ? "Short.valueOf( " + inValue + ")" : (this.info.type.equals(Object.class) ? inValue : inValue)))))))))))))))));
        return v;
    }

    private void emitSetParam(JspEmitState st) {
        String paramName = this.getAV(2).getQuotedValue();
        String editorClassFromPD = null;
        if (this.info.editorClassNameFromPD != null) {
            editorClassFromPD = "\"" + this.info.editorClassNameFromPD + "\"";
        }
        st.iprintln("{");
        st.indent();
        st.iprintln("String[] __paramList = request.getParameterValues( " + paramName + ");");
        if (this.info.type.isArray()) {
            if (this.info.propertyEditorClass != null) {
                Class<?> componentType = this.info.type.getComponentType();
                String componentTypeName = componentType.getName();
                if (this.info.isMethod()) {
                    st.iprintln(this.bean.name + "." + this.info.getName() + "((" + componentTypeName + "[])" + "OracleJspRuntime.__getValueFromPropertyEditor( __paramList" + ",\"" + componentTypeName + "\"" + "," + editorClassFromPD + "," + paramName + "));");
                } else {
                    st.iprintln(this.bean.name + "." + this.info.getName() + " =" + "(" + componentTypeName + "[])" + " OracleJspRuntime.__getValueFromPropertyEditor(__paramList" + ",\"" + componentTypeName + "\"" + "," + editorClassFromPD + "," + paramName + ");");
                }
            } else if (this.info.isMethod()) {
                st.iprintln(this.bean.name + "." + this.info.getName() + "( __paramList);");
            } else {
                st.iprintln(this.bean.name + "." + this.info.getName() + " = __paramList;");
            }
        } else {
            String idxStr;
            if (this.info.isMultiValue) {
                st.iprintln("for (int __i = 0; (__paramList != null) && (__i < __paramList.length); __i++) {");
                st.indent();
                idxStr = "__i";
            } else {
                idxStr = "0";
            }
            st.iprintln("if ((__paramList != null) && (__paramList[" + idxStr + "] != null) && (__paramList[" + idxStr + "].length() > 0)) {");
            st.indent();
            boolean isTrivialType = JspUtils.isTrivialType(this.info.type);
            if (isTrivialType) {
                String rq = null;
                if (this.info.propertyEditorClass != null) {
                    String val = "OracleJspRuntime.__getValueFromPropertyEditor(__paramList[" + idxStr + "]" + ",\"" + this.info.type.getName() + "\"" + "," + editorClassFromPD + "," + paramName + ")";
                    rq = "(" + this.info.type.getName() + ")(" + val + ")";
                } else {
                    rq = this.convertParamValue("__paramList[" + idxStr + "]");
                }
                if (this.info.isMultiValue) {
                    st.iprintln(this.bean.name + "." + this.info.getName() + "( __i, " + rq + ");");
                } else if (this.info.isMethod()) {
                    st.iprintln(this.bean.name + "." + this.info.getName() + "(" + rq + ");");
                } else {
                    st.iprintln(this.bean.name + "." + this.info.getName() + " = " + rq + ";");
                }
            } else {
                st.iprintln("OracleJspRuntime.__IntrospectHelper(__paramList[" + idxStr + "]" + ",(Object)" + this.bean.name + "," + paramName + ", " + st.parms.needToRaiseBeanException + ");");
            }
            st.undent();
            st.iprintln("}");
            if (this.info.isMultiValue) {
                st.undent();
                st.iprintln("}");
            }
        }
        st.undent();
        st.iprintln("}");
    }

    private void emitSetValue(JspEmitState st, String attrName) {
        PropertyUtil.emitSetValue(st, this.info, this.getAV(3), this.bean.name, attrName);
    }

    public void emitStart(JspEmitState st) {
        if (this.setAllParams) {
            this.emitSetAllParams(st);
        } else if (this.getAV(3).valueExists()) {
            if (st.parms.requestTimeIntrospection && this.bean.getDuplicateBean()) {
                st.iprintln("OracleJspRuntime.__jspFindBeanSetPropValue(pageContext, \"" + this.bean.name + "\", " + this.getAV(1).getQuotedValue() + ", " + this.getAV(3).getStringValue() + ", " + st.parms.needToRaiseBeanException + ");");
            } else if (this.info == null) {
                st.iprintln("OracleJspRuntime.__jspSetPropValue( " + this.bean.name + ", " + this.getAV(1).getQuotedValue() + ", " + this.getAV(3).getStringValue() + ", " + st.parms.needToRaiseBeanException + ");");
            } else {
                this.emitSetValue(st, this.getAV(1).getStringValue());
            }
        } else if (st.parms.requestTimeIntrospection && this.bean.getDuplicateBean()) {
            st.iprintln("OracleJspRuntime.__jspFindBeanSetPropReq(pageContext, \"" + this.bean.name + "\", " + this.getAV(1).getQuotedValue() + ", " + "request, " + this.getAV(2).getQuotedValue() + "," + st.parms.needToRaiseBeanException + " );");
        } else if (this.info == null) {
            st.iprintln("OracleJspRuntime.__jspSetPropReq( " + this.bean.name + ", " + this.getAV(1).getQuotedValue() + ", " + "request, " + this.getAV(2).getQuotedValue() + "," + st.parms.needToRaiseBeanException + " );");
        } else {
            PropertyUtil.checkForPropertyEditorClass(this.bean.bean, this.getAV(1).getStringValue(), this.info);
            this.emitSetParam(st);
        }
    }
}

