/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspFragment;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagDeclaration;
import oracle.jsp.parse.JspParseTagExpression;
import oracle.jsp.parse.JspParseTagScriptlet;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspRTTag;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspTagBody;
import oracle.jsp.parse.OpenJspTagHandler;

public class OpenJspTagAttribute
extends OpenJspTagHandler {
    private static final OpenJspAVDesc[] avList1 = new OpenJspAVDesc[]{new OpenJspAVDesc("name", 11, true), new OpenJspAVDesc("trim", 2, false)};
    private boolean trim = true;
    private String name;
    private String localName;
    private String prefix;
    private String varName;
    private boolean templateText = false;
    public boolean onlyTemplateText = true;
    public boolean scriptless = true;
    public boolean isFragment = false;

    public OpenJspTagAttribute() {
        this.htmlTag = "attribute";
    }

    public boolean allowsBody() {
        return true;
    }

    public boolean isTagValidInBody(JspParseState st, String tagStr, Class tagClass, JspParseTag tag) {
        return true;
    }

    public void addTagToBody(JspParseState st, JspParseTag tag) throws JspParseException {
        if (tag instanceof OpenJspTagBody && st.throwParseException(new JspParseException(st, msgs.getString("bad_jspattribute_body")))) {
            return;
        }
        if (tag instanceof JspParseTagText) {
            ((JspParseTagText)tag).setFromJspAttribute();
        } else {
            this.onlyTemplateText = false;
        }
        if (tag instanceof JspParseTagScriptlet || tag instanceof JspParseTagExpression || tag instanceof JspParseTagDeclaration) {
            this.scriptless = false;
        }
        this.body.addElement(tag);
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return avList1;
    }

    public String validateAttributeList(JspParseState st, OpenJspAVInfo[] avList) {
        String trimStr;
        String name = avList[0].getStringValue();
        this.name = avList[0].getUnquotedValue();
        if (name != null) {
            this.localName = name;
            int index = this.name.indexOf(58);
            if (index != -1) {
                this.prefix = this.name.substring(0, index);
                this.localName = this.name.substring(index + 1);
            }
        }
        if ((trimStr = avList[1].getStringValue()) != null && trimStr.equalsIgnoreCase("false")) {
            this.trim = false;
        }
        return null;
    }

    public void emitStart(JspEmitState st) {
        if (this.body != null && !this.isFragment) {
            if (this.body.size() == 1) {
                JspParseTag tag = (JspParseTag)this.body.elementAt(0);
                String textVal = null;
                if (tag instanceof JspParseTagText) {
                    JspParseTagText stag = (JspParseTagText)tag;
                    stag.setFromJspAttributeNoEmit();
                    textVal = stag.hasEL() ? stag.getELString() : stag.getString();
                    if (textVal != null) {
                        this.templateText = true;
                        if (stag.hasEL()) {
                            st.iprintln("String " + this.getVariableName(st) + " = " + textVal + ";");
                        } else {
                            st.iprintln("String " + this.getVariableName(st) + " = " + "\"" + OpenJspTagAttribute.sanitizeQuotedString(textVal) + "\";");
                        }
                    }
                }
            }
            if (!this.templateText) {
                st.iprintln("out = pageContext.pushBody();");
            }
        }
    }

    public void emitEnd(JspEmitState st) {
        if (!this.isFragment) {
            if (this.body != null) {
                if (!this.templateText) {
                    st.iprintln("String " + this.getVariableName(st) + " = " + "((javax.servlet.jsp.tagext.BodyContent)" + "out).getString();");
                    st.iprintln("out = pageContext.popBody();");
                }
            } else {
                st.println("String " + this.getVariableName(st) + " = \"\";");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getJspAttributePrefix() {
        return this.prefix;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public String getVariableName(JspEmitState st) {
        if (this.varName == null) {
            this.varName = st.nextJspAttributeVariableName();
        }
        return this.varName;
    }

    public String getTextString() {
        JspParseTag tag = (JspParseTag)this.body.elementAt(0);
        if (tag instanceof JspParseTagText) {
            JspParseTagText stag = (JspParseTagText)tag;
            stag.setFromJspAttributeNoEmit();
            return stag.getString();
        }
        return null;
    }

    public void validateTagParse(JspParseState st) throws JspParseException {
        if (this.trim) {
            int max = this.body.size();
            for (int i = 0; i < max; ++i) {
                JspParseTag tag = (JspParseTag)this.body.elementAt(i);
                if (!(tag instanceof JspParseTagText)) continue;
                if (i == 0) {
                    ((JspParseTagText)tag).ltrim();
                }
                if (i != max - 1) continue;
                ((JspParseTagText)tag).rtrim();
            }
        }
    }

    private void emitJspFragment(JspEmitState st) throws JspEmitException {
        st.iprint("javax.servlet.jsp.tagext.JspFragment " + this.getVariableName(st) + " = ");
        JspFragment frag = this.generateJspFragment(st, ((JspRTTag)this.parent).getTagVarName());
        st.println(";");
        super.emitTagBody(frag.getOut());
        st.parseState.fragmentSupportClass.closeFragment(frag);
    }

    public void emitTagBody(JspEmitState st) throws JspEmitException {
        if (!this.isFragment) {
            super.emitTagBody(st);
        } else {
            this.emitJspFragment(st);
        }
    }
}

