/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspAttributeValuePiece;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspTagAttribute;

public class OpenJspAVInfo {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public OpenJspAVDesc desc;
    private String stringValue;
    public ArrayList stringValueElPieces;
    private Class valueClass;
    private boolean amExpression;
    private boolean quoted = false;
    private String stringValueBeforeQuotation;
    private String xmlStyleStringValue;
    private boolean hasEL = false;
    private String xmlViewValue;
    private boolean isXmlSrc = false;
    private boolean isDynamic = false;
    private boolean jspAttribute = false;
    private OpenJspTagAttribute jspAttributeNode = null;
    private static boolean DOLLAR_ESCAPE = false;

    public OpenJspAVInfo(OpenJspAVDesc desc) {
        this.desc = desc;
    }

    public boolean valueExists() {
        return this.stringValue != null;
    }

    public String getQuotedValue() {
        if (this.quoted) {
            return this.stringValue;
        }
        return "\"" + JspParseTag.sanitizeQuotedString(this.stringValue) + "\"";
    }

    public String getUnquotedValue() {
        if (this.quoted) {
            return this.stringValueBeforeQuotation;
        }
        return this.stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String val) {
        this.stringValue = val;
    }

    public String getExpression() {
        return this.stringValue;
    }

    public boolean isExpression() {
        return this.amExpression;
    }

    public static String decodeEscapes(String val) {
        int idx = val.indexOf("<\\%");
        while (idx != -1) {
            val = val.substring(0, idx + 1) + val.substring(idx + 2);
            idx = val.indexOf("<\\%", idx + 1);
        }
        idx = val.indexOf("%\\>");
        while (idx != -1) {
            val = val.substring(0, idx + 1) + val.substring(idx + 2);
            idx = val.indexOf("%\\>", idx + 1);
        }
        return val;
    }

    private static String handleELTextPiece(JspParseState st, String value) {
        if (st.parms.xmlStyleSrc) {
            return JspUtils.decodeDollarEscape(value);
        }
        return JspParseTag.sanitizeQuotedString(JspUtils.decodeQuotes(value));
    }

    public void setValue(JspParseState st, String value) throws JspParseException {
        this.stringValue = this.desc.caseSens ? value : value.toLowerCase();
        if ((JspUtils.hasProcessedEL(st) || JspUtils.hasEscapingText(st)) && this.desc.type == 11 && st.attributeValueElPieces != null) {
            this.stringValueElPieces = new ArrayList();
            for (int i = 0; i < st.attributeValueElPieces.size(); ++i) {
                JspAttributeValuePiece avp = (JspAttributeValuePiece)st.attributeValueElPieces.get(i);
                if (!avp.isELPiece()) {
                    String temp = OpenJspAVInfo.handleELTextPiece(st, avp.getPiece());
                    avp.setPiece(temp);
                }
                this.stringValueElPieces.add(avp);
            }
            st.attributeValueElPieces = null;
        }
        switch (this.desc.type) {
            case 1: {
                this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                if (this.desc.validValues != null && this.desc.validValues.length > 0) {
                    int j;
                    for (j = 0; j < this.desc.validValues.length && !this.stringValue.equals(this.desc.validValues[j]); ++j) {
                    }
                    if (j == this.desc.validValues.length && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_attr_value"), value, this.desc.name)))) {
                        return;
                    }
                }
                this.checkRtexprSyntax(st, this.stringValue);
                this.xmlStyleStringValue = this.stringValue;
                return;
            }
            case 2: {
                if (JspUtils.isBoolean(value)) {
                    this.xmlStyleStringValue = this.stringValue = value.toLowerCase().trim();
                    return;
                }
                if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_bool_attr"), this.desc.name, value)))) {
                    return;
                }
            }
            case 4: {
                if (this.desc.validValues != null && this.desc.validValues.length > 0) {
                    for (int j = 0; j < this.desc.validValues.length; ++j) {
                        if (!value.equals(this.desc.validValues[j])) continue;
                        return;
                    }
                }
                this.xmlStyleStringValue = this.stringValue = value.trim();
                if (this.stringValue.length() == 0 && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("empty_value"), this.desc.name)))) {
                    return;
                }
                char ch = this.stringValue.charAt(0);
                if (!Character.isJavaIdentifierStart(ch) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_id"), this.desc.name)))) {
                    return;
                }
                int pos = 1;
                int max = this.stringValue.length();
                while (pos < max) {
                    ch = this.stringValue.charAt(pos);
                    if (Character.isJavaIdentifierPart(ch)) {
                        ++pos;
                        continue;
                    }
                    if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_char"), new Character(ch), this.desc.name)))) continue;
                    return;
                }
                return;
            }
            case 11: {
                this.stringValue = value;
                if (this.stringValue.startsWith("<%=") && this.stringValue.endsWith("%>")) {
                    this.stringValue = this.stringValue.length() > 5 ? this.stringValue.substring(3, this.stringValue.length() - 2).trim() : "";
                    if (this.stringValue.length() == 0 && st.throwParseException(new JspParseException(st, msgs.getString("empty_expr")))) {
                        return;
                    }
                    this.amExpression = true;
                    this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                    this.xmlStyleStringValue = "%=" + this.stringValue + "%";
                } else if (JspUtils.isELEvaluationOn(st) && this.attributeValueHasEL()) {
                    this.amExpression = true;
                    this.stringValueBeforeQuotation = OpenJspAVInfo.decodeEscapes(this.stringValue);
                    this.quoted = true;
                    this.stringValue = "\"" + JspParseTag.sanitizeQuotedString(this.stringValueBeforeQuotation) + "\"";
                    this.xmlStyleStringValue = this.getXMLViewValue(this.stringValueBeforeQuotation);
                } else {
                    this.stringValueBeforeQuotation = OpenJspAVInfo.decodeEscapes(this.stringValue);
                    this.quoted = true;
                    this.stringValue = "\"" + JspParseTag.sanitizeQuotedString(this.stringValueBeforeQuotation) + "\"";
                    this.xmlStyleStringValue = this.getXMLViewValue(this.stringValueBeforeQuotation);
                }
                return;
            }
        }
    }

    private void checkRtexprSyntax(JspParseState st, String stringValue) throws JspParseException {
        if (stringValue.startsWith("<%=") && stringValue.endsWith("%>") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("expr_in_nonrtexpr"), this.desc.name)))) {
            return;
        }
    }

    public void setXMLSrcValue(JspParseState st, String value) throws JspParseException {
        if (this.desc.type == 11) {
            if (value.startsWith("%=") && value.endsWith("%")) {
                this.setValue(st, "<" + value + ">");
            } else {
                this.setValue(st, value);
            }
        } else {
            this.setValue(st, value);
        }
    }

    public boolean isJspAttribute() {
        return this.jspAttribute;
    }

    public boolean isDynamicAttribute() {
        return this.isDynamic;
    }

    public void setDynamicAttributeFlag() {
        this.isDynamic = true;
    }

    public void setJspAttributeNode(OpenJspTagAttribute tag) {
        this.jspAttribute = true;
        this.jspAttributeNode = tag;
    }

    public OpenJspTagAttribute getJspAttributeNode() {
        return this.jspAttributeNode;
    }

    public String getXMLStyleStringValue() {
        return this.xmlStyleStringValue;
    }

    public void setXMLViewValue(String value, boolean isXmlSrc) {
        this.xmlViewValue = value;
        this.isXmlSrc = isXmlSrc;
    }

    private String getXMLViewValue(String defaultStr) {
        if (this.xmlViewValue == null) {
            return defaultStr;
        }
        if (this.isXmlSrc) {
            return this.xmlViewValue;
        }
        return JspUtils.convertToXMLViewValue(this.xmlViewValue);
    }

    public boolean attributeValueHasEL() {
        return this.hasEL;
    }

    public void setHasEL(boolean hasEL) {
        this.hasEL = hasEL;
    }
}

