/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTagXMLTextContainer;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;

public class JspParseException
extends Exception {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public int lineNum;
    public String errorLine;
    public String fileName;
    public Throwable rootCause;
    public Element xe;

    public JspParseException(JspParseState st, String s) {
        super(s);
        this.lineNum = st.position.lineNum;
        this.errorLine = st.position.line;
        this.fileName = st.position.currentSourceFile;
        this.xe = st.position.curXMLSrcElem;
    }

    public JspParseException(JspParseState st, Throwable rootCause) {
        super(rootCause.toString());
        this.lineNum = st.position.lineNum;
        this.errorLine = st.position.line;
        this.fileName = st.position.currentSourceFile;
        this.xe = st.position.curXMLSrcElem;
        this.rootCause = rootCause;
    }

    public JspParseException(int lineNum, String errorLine, String msg) {
        super(msg);
        this.lineNum = lineNum;
        this.errorLine = errorLine;
        this.fileName = "";
    }

    public JspParseException(int lineNum, String errorLine, String fileName, String msg) {
        super(msg);
        this.lineNum = lineNum;
        this.errorLine = errorLine;
        this.fileName = fileName;
    }

    public JspParseException(int lineNum, String errorLine, String fileName, Throwable rootCause) {
        super(rootCause.toString());
        this.lineNum = lineNum;
        this.errorLine = errorLine;
        this.fileName = fileName;
        this.rootCause = rootCause;
    }

    public JspParseException(JspParsePosition pos, String msg) {
        super(msg);
        this.lineNum = pos.lineNum;
        this.errorLine = pos.line;
        this.fileName = pos.currentSourceFile;
        this.xe = pos.curXMLSrcElem;
    }

    public JspParseException(JspParsePosition pos, Throwable rootCause) {
        super(rootCause.toString());
        this.lineNum = pos.lineNum;
        this.errorLine = pos.line;
        this.fileName = pos.currentSourceFile;
        this.xe = pos.curXMLSrcElem;
        this.rootCause = rootCause;
    }

    public JspParseException(Element xe, String fileName, String msg) {
        super(msg);
        this.xe = xe;
        this.fileName = fileName;
    }

    public JspParseException(Element xe, String fileName, Throwable th) {
        super(th.toString());
        this.xe = xe;
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public String getErrorLine() {
        if (this.errorLine == null) {
            return "";
        }
        String errLine = this.errorLine;
        if (errLine.endsWith("\r\n")) {
            errLine = errLine.substring(0, errLine.length() - 2);
        } else if (errLine.endsWith("\n")) {
            errLine = errLine.substring(0, errLine.length() - 1);
        }
        return errLine;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    private static String getElementStr(Element e) {
        try {
            String s = JspParseTagXMLTextContainer.getXMLElementOneLineStr(e);
            if (s != null) {
                return s.trim();
            }
            return s;
        }
        catch (Throwable th) {
            return "";
        }
    }

    private static String getElementLineNum(Element e) {
        try {
            return ((XMLElement)e).getLineNumber() + "";
        }
        catch (Throwable th) {
            return "";
        }
    }

    public String getMessage() {
        if (this.xe != null) {
            return this.getErrorLine() + "\n" + MessageFormat.format(msgs.getString("error_line_hdr"), this.fileName != null && !this.fileName.equals("") ? this.fileName + ":" : "", JspParseException.getElementLineNum(this.xe), JspParseException.getElementStr(this.xe)) + "\n" + msgs.getString("error_hdr") + this.getGeneralOrXPEMsg();
        }
        if (this.lineNum < 0) {
            return this.getErrorLine() + "\n" + msgs.getString("error_hdr") + this.getGeneralOrXPEMsg();
        }
        return MessageFormat.format(msgs.getString("error_line_hdr"), this.fileName != null && !this.fileName.equals("") ? this.fileName + ":" : "", this.lineNum + "", this.getErrorLine()) + "\n" + msgs.getString("error_hdr") + this.getGeneralOrXPEMsg();
    }

    protected String getGeneralOrXPEMsg() {
        if (this.rootCause instanceof XMLParseException) {
            return this.getDetailedXPEMsg((XMLParseException)this.rootCause, 20);
        }
        return super.getMessage();
    }

    protected String getDetailedXPEMsg(XMLParseException xpe, int max) {
        int numMsg = xpe.getNumMessages();
        if (numMsg > max) {
            numMsg = max;
        }
        StringBuffer sb = new StringBuffer();
        if (this.fileName != null && !this.fileName.equals("")) {
            sb.append(((Object)((Object)xpe)).getClass().getName() + " ( " + this.fileName + " ):\n");
        } else {
            sb.append(((Object)((Object)xpe)).getClass().getName() + " :\n");
        }
        for (int i = 0; i < numMsg; ++i) {
            sb.append(msgs.getString("line_num"));
            sb.append(xpe.getLineNumber(i));
            sb.append(" ");
            sb.append(msgs.getString("col_num"));
            sb.append(xpe.getColumnNumber(i));
            sb.append(" : ");
            sb.append(xpe.getMessage(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getParentMsg() {
        return super.getMessage();
    }
}

