/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;

public class JspEncodingException
extends JspParseException {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private String expectedEncoding;
    private String specifiedEncoding;
    private boolean explicitCharsetSpecified = true;

    public JspEncodingException(JspParseState st, String expecting, String got) {
        super(st, MessageFormat.format(msgs.getString("encoding_mismatch"), expecting, got));
        this.expectedEncoding = expecting;
        this.specifiedEncoding = got;
    }

    public JspEncodingException(JspParseState st, String expecting, String got, boolean explicitCharsetSpecified) {
        this(st, expecting, got);
        this.explicitCharsetSpecified = explicitCharsetSpecified;
    }

    public String getSpecifiedEncoding() {
        return this.specifiedEncoding;
    }

    public boolean isExplicitCharsetSpecified() {
        return this.explicitCharsetSpecified;
    }
}

