/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.FunctionInfo;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.runtime.OracleJspRuntime;
import oracle.jsp.util.JspUtil;

public class JspEmitter {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final boolean canHandleThrowable_FLAG = JspEmitter.canHandleThrowable();
    private static final String pkg = "oracle.jsp.runtime";
    private static final String[] commonImports = new String[]{"oracle.jsp.runtime.*", "javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*"};
    private static final String[] elImports = new String[]{"oracle.jsp.el.*", "javax.servlet.jsp.el.*"};
    private String extName;
    private String clsName;
    protected String emittedPackageName;
    private static boolean isOc4jJspCommonExtraWriterDefined_flag = false;
    public static final String STATICTEXT_CLASSNAME = "__jsp_StaticText";

    protected static void emitGlobalDeclarations(JspEmitState st) {
        if (!st.parseState.parms.elIgnored && st.parseState.elFunctionCounter > -1) {
            st.println("");
            st.iprintln("// Begin global declarations");
            st.println("");
            st.iprint("private static OracleFunctionMapperImpl [] __ojsp_fnmappers = OracleJspRuntime.__init_ojsp_fMappers(");
            Integer size = new Integer(st.parseState.elFunctionCounter + 1);
            st.print(size.toString());
            st.println(");");
            st.iprintln("// End global declarations");
            st.println("");
            JspEmitter.emitFunctionMappings(st);
        }
    }

    public void emit(JspEmitState st, JspParseTagFile srcRoot) throws JspParseException {
        block2: {
            st.printLineInfoFile(srcRoot.getFileName());
            st.printLineInfoGenerated();
            st.printLineInfo(0, 1);
            this.emitHeader(st);
            this.emitClassDecl(st);
            JspEmitter.emitGlobalDeclarations(st);
            this.emitDeclarations(st);
            this.emitServiceHeader(st, srcRoot);
            st.printLineInfoTranslated();
            st.setFromService(true);
            try {
                srcRoot.emit(st);
            }
            catch (JspEmitException e) {
                if (!st.parseState.throwParseException(new JspParseException(-1, msgs.getString("emit_ex"), e.getMessage()))) break block2;
                return;
            }
        }
        st.setFromService(false);
        st.printLineInfoGenerated();
        this.emitServiceTrailer(st);
        this.emitHelperMethods(st);
        this.emitClearText(st);
        this.emitFragmentCode(st);
        this.emitStaticTexts(st);
        this.emitTrailer(st);
    }

    protected void emitFragmentCode(JspEmitState st) {
        if (st.parseState.fragmentSupportClass != null && st.parseState.fragmentSupportClass.fragmentExists()) {
            st.parseState.fragmentSupportClass.emit(st);
        }
    }

    protected void emitHeader(JspEmitState st) {
        String imp;
        int i;
        String pack = pkg;
        if (st.parms.packageName != null) {
            pack = st.parms.packageName;
        }
        if (pack.length() > 0) {
            st.println("package " + pack + ";");
            this.emittedPackageName = pack;
        } else {
            this.emittedPackageName = null;
        }
        st.println("");
        for (i = 0; i < commonImports.length; ++i) {
            st.println("import " + commonImports[i] + ";");
        }
        if (!st.parseState.parms.elIgnored) {
            for (i = 0; i < elImports.length; ++i) {
                st.println("import " + elImports[i] + ";");
            }
        }
        if (st.parms.extraImports != null) {
            Enumeration e = st.parms.extraImports.elements();
            while (e.hasMoreElements()) {
                st.println("import " + e.nextElement() + ";");
            }
        }
        if (st.parms.imports != null) {
            for (int i2 = 0; i2 < st.parms.imports.length; ++i2) {
                st.println("import " + st.parms.imports[i2] + ";");
            }
        }
        if ((imp = st.getDirectiveAttrValue("page", "import")) != null) {
            String line;
            int idx;
            while ((idx = imp.indexOf(44)) != -1) {
                line = imp.substring(0, idx).trim();
                if (line.length() > 0) {
                    st.println("import " + line + ";");
                }
                if (idx + 1 < imp.length()) {
                    imp = imp.substring(idx + 1);
                    continue;
                }
                imp = "";
            }
            line = imp.trim();
            if (line.length() > 0) {
                st.println("import " + line + ";");
            }
        }
        st.println("");
        st.println("");
    }

    protected void emitClassDecl(JspEmitState st) {
        this.clsName = st.parms.className == null ? "jsp_" + Long.toString(new Date().getTime()) + "_" + Integer.toString(++JspEmitState.emitCount) : st.parms.className;
        this.extName = st.getDirectiveAttrValue("page", "extends");
        if (this.extName == null) {
            this.extName = st.parms.extend == null ? "com.orionserver.http.OrionHttpJspPage" : st.parms.extend;
        }
        st.print("public class " + this.clsName + " extends " + this.extName + " ");
        boolean threadSafe = JspUtils.translateBoolean(st.getDirectiveAttrValue("page", "isThreadSafe"), true);
        if (st.parms.implement != null) {
            st.print("implements " + st.parms.implement);
            if (threadSafe) {
                st.print(" ");
            } else {
                st.print(", SingleThreadModel ");
            }
        } else if (!threadSafe) {
            st.print("implements SingleThreadModel ");
        }
        st.println("{");
        st.println("");
    }

    protected void emitDeclarations(JspEmitState st) {
        String val = st.getDirectiveAttrValue("page", "info");
        if (val != null) {
            st.iprintln("public String getServletInfo() {");
            st.indent();
            st.iprintln("return( \"" + JspParseTag.sanitizeQuotedString(val) + "\");");
            st.undent();
            st.iprintln("}");
            st.println("");
        }
        int max = st.declarations.size();
        boolean user = false;
        String originalFile = st.getLineInfoFileName();
        st.println("");
        st.iprintln("// ** Begin Declarations");
        st.println("");
        Jsp2JavaParms cfr_ignored_0 = st.parms;
        if (st.parms.gensmap != 0) {
            st.setFromDeclarations(true);
            int lineInfoNumSave = st.lineInfoLineNum;
            int jspLineNum = 0;
            for (int i = 0; i < max; ++i) {
                String s;
                Object o = st.declarations.elementAt(i);
                if (o instanceof Integer) {
                    Integer theLine = (Integer)o;
                    jspLineNum = theLine;
                    st.lineInfoFileName = s = (String)st.declarations.elementAt(++i);
                    continue;
                }
                st.lineInfoLineNum = jspLineNum++;
                s = (String)st.declarations.elementAt(i);
                st.print(s);
                if (st.parseState.parms.xmlStyleSrc) {
                    st.processSmapForXmlSrcBodyStr(st.lineInfoLineNum, s, false);
                }
                if (st.currentLineInfoMapObj == null) continue;
                st.currentLineInfoMapObj.javaEndLineNum = st.currentLine - 1;
            }
            st.lineInfoLineNum = lineInfoNumSave;
            st.setFromDeclarations(false);
            st.lineInfoFileName = originalFile;
            st.smapLineInfoNeeded = false;
            st.println("");
            st.smapLineInfoNeeded = true;
        } else {
            for (int i = 0; i < max; ++i) {
                String s;
                Object o = st.declarations.elementAt(i);
                if (o instanceof Integer) {
                    Integer theLine = (Integer)o;
                    s = (String)st.declarations.elementAt(++i);
                    if (!user) {
                        st.printLineInfoUser();
                        user = true;
                    }
                    st.printLineInfoFile(s);
                    st.printLineInfo(theLine + 1, 1);
                    continue;
                }
                s = (String)st.declarations.elementAt(i);
                st.print(s);
            }
            st.printLineInfoGenerated();
            st.printLineInfoFile(originalFile);
            st.println("");
        }
        st.iprintln("// ** End Declarations");
        st.println("");
    }

    public static boolean isOc4jJspCommonExtraWriterDefined(JspEmitState emitState) {
        if (emitState.parms.reduceTagExtCodeGen) {
            return false;
        }
        return isOc4jJspCommonExtraWriterDefined_flag;
    }

    protected void emitServiceHeader(JspEmitState st, JspParseTagFile srcRoot) {
        st.iprintln("public void _jspService(HttpServletRequest request, HttpServletResponse response) throws java.io.IOException, ServletException {");
        st.indent();
        st.println("");
        String resEncoding = null;
        String justContentType = null;
        String ct = st.getDirectiveAttrValue("page", "contentType");
        if (ct != null) {
            justContentType = JspUtils.extractContentType(ct);
            resEncoding = JspUtils.extractEncoding(ct);
        }
        if (ct == null || ct.length() == 0 || ct != null && resEncoding == null) {
            if (srcRoot.xmlSrcElem == null) {
                if (srcRoot.pageEncoding != null) {
                    resEncoding = srcRoot.pageEncoding;
                } else if (srcRoot.configEncoding != null) {
                    resEncoding = srcRoot.configEncoding;
                } else if (srcRoot.defaultCharSet != null) {
                    resEncoding = srcRoot.defaultCharSet;
                }
                if (justContentType == null) {
                    justContentType = "text/html";
                }
            } else {
                resEncoding = "UTF-8";
                if (justContentType == null) {
                    justContentType = "text/xml";
                }
            }
            if (!justContentType.startsWith("application/")) {
                ct = resEncoding != null ? justContentType + ";charset=" + resEncoding : justContentType;
            } else if (resEncoding != null) {
                st.encodingUsed = resEncoding;
            }
        }
        st.contentTypeUsed = ct;
        st.iprintln("response.setContentType( \"" + ct + "\");");
        st.iprintln("/* set up the intrinsic variables using the pageContext goober:");
        st.iprintln("** session = HttpSession");
        st.iprintln("** application = ServletContext");
        st.iprintln("** out = JspWriter");
        st.iprintln("** page = this");
        st.iprintln("** config = ServletConfig");
        st.iprintln("** all session/app beans declared in globals.jsa");
        st.iprintln("*/");
        boolean needsSession = JspUtils.translateBoolean(st.getDirectiveAttrValue("page", "session"), true);
        String val = st.getDirectiveAttrValue("page", "buffer");
        if (val == null) {
            JspUtils.checkOjspConfigForDefaultBufferSize(st.parseState);
            val = st.parseState.parms.defaultBufferSz;
        }
        int bufferSz = JspUtils.translateBufferSize(val);
        boolean autoFlush = JspUtils.translateBoolean(st.getDirectiveAttrValue("page", "autoFlush"), true);
        String errorPage = st.getDirectiveAttrValue("page", "errorPage");
        errorPage = errorPage == null ? "null" : "\"" + JspParseTag.sanitizeQuotedString(errorPage) + "\"";
        st.iprint("PageContext pageContext = JspFactory.getDefaultFactory().getPageContext( this, request, response, " + errorPage + ", " + JspUtils.getBooleanString(needsSession) + ", ");
        if (bufferSz < 0) {
            st.print("JspWriter.DEFAULT_BUFFER");
        } else if (bufferSz == 0) {
            st.print("JspWriter.NO_BUFFER");
        } else {
            st.print(Integer.toString(bufferSz));
        }
        st.print(", " + JspUtils.getBooleanString(autoFlush) + ");");
        st.println("");
        if (needsSession) {
            st.iprintln("// Note: this is not emitted if the session directive == false");
            st.iprintln("HttpSession session = pageContext.getSession();");
        } else {
            st.iprintln("// Note: session is false, so no session variable is defined.");
        }
        if (st.parms.extend == null || !st.parms.extend.equals("com.orionserver.http.OrionHttpJspPage")) {
            st.iprintln("if (pageContext.getAttribute(OracleJspRuntime.JSP_REQUEST_REDIRECTED, PageContext.REQUEST_SCOPE) != null) {");
            st.indent();
            st.iprintln("pageContext.setAttribute(OracleJspRuntime.JSP_PAGE_DONTNOTIFY, \"true\", PageContext.PAGE_SCOPE);");
            st.iprintln("JspFactory.getDefaultFactory().releasePageContext(pageContext);");
            st.iprintln("return;");
            st.undent();
            st.println("}");
        }
        st.iprintln("int __jsp_tag_starteval;");
        st.iprintln("ServletContext application = pageContext.getServletContext();");
        st.iprintln("JspWriter out = pageContext.getOut();");
        st.iprintln(this.clsName + " page = this;");
        st.iprintln("ServletConfig config = pageContext.getServletConfig();");
        if (!st.parseState.parms.elIgnored) {
            st.iprintln("javax.servlet.jsp.el.VariableResolver __ojsp_varRes = (VariableResolver)new OracleVariableResolverImpl(pageContext);");
        }
        if (JspUtils.translateBoolean(st.getDirectiveAttrValue("page", "isErrorPage"), false)) {
            if (canHandleThrowable_FLAG) {
                st.iprintln("Throwable exception = (Throwable) request.getAttribute(PageContext.EXCEPTION);");
            } else {
                st.iprintln("Exception exception = pageContext.getException();");
            }
        }
        st.println("");
        if (st.parms.staticTextInBytes && "com.orionserver.http.OrionHttpJspPage".equals(st.parms.extend) && JspEmitter.isOc4jJspCommonExtraWriterDefined(st)) {
            st.iprintln("com.evermind.server.http.JspCommonExtraWriter __ojsp_s_out = (com.evermind.server.http.JspCommonExtraWriter) out;");
        }
        String[] classList = st.parseState.getTagUsageClassList();
        st.iprintln("try {");
        st.indent();
        if (st.parms.compileTimeTagReuse && classList != null && classList.length > 0) {
            st.iprintln("// compile time tag reuse - begin");
            String[] usageList = st.parseState.getTagUsageUsageList();
            if (st.parseState.classicTagsInFragmentClass) {
                st.iprintln("javax.servlet.jsp.tagext.JspTag[] __ojsp_classicTags = new javax.servlet.jsp.tagext.JspTag[" + classList.length + "];");
            }
            String ctType = "compiletime";
            if (st.parms.compileTimeTagReleaseReuse) {
                ctType = "compiletime_with_release";
            }
            for (int i = 0; i < classList.length; ++i) {
                String tagHandlerName = "__jsp_tag_ctru" + i;
                st.iprintln("// usage : " + usageList[i]);
                st.iprintln(classList[i] + " " + tagHandlerName + " = (" + classList[i] + ") OracleJspRuntime.getTagHandler(pageContext, " + classList[i] + ".class, \"" + ctType + "\");");
                if (!st.parseState.classicTagsInFragmentClass) continue;
                st.iprintln("__ojsp_classicTags[" + i + "] = " + tagHandlerName + ";");
            }
            st.iprintln("// compile tag reuse - end");
        }
        st.println("");
        if (st.resOut != null) {
            if (st.parms.staticTextInSameClass) {
                st.iprintln("if (__oracle_jsp_text == null)");
                st.indent();
                st.iprintln("initializeText();");
            } else {
                st.iprintln("if (__jsp_StaticText.__oracle_jsp_text == null)");
                st.indent();
                st.iprintln("__jsp_StaticText.initializeText();");
            }
            st.undent();
            st.println("");
        }
        if (srcRoot.xmlSrcElem != null && !st.parseState.omitXmlDecl) {
            String r_encoding = JspUtils.extractEncoding(st.contentTypeUsed);
            if (r_encoding == null) {
                r_encoding = st.encodingUsed;
            }
            st.iprintln("out.println(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + r_encoding + "\\\" ?>\");");
        }
        st.println("");
        if (srcRoot.xmlSrcElem != null && st.parseState.doctypeRootElem != null) {
            String qStr = null;
            String buf = "out.println(\"<!DOCTYPE " + st.parseState.doctypeRootElem;
            if (st.parseState.doctypePublic != null) {
                qStr = st.parseState.doctypePublic.indexOf("\"") == -1 ? "\\\"" : "'";
                buf = buf + " PUBLIC " + qStr + JspParseTag.sanitizeQuotedString(st.parseState.doctypePublic) + qStr + " ";
            } else {
                buf = buf + " SYSTEM ";
            }
            qStr = st.parseState.doctypeSystem.indexOf("\"") == -1 ? "\\\"" : "'";
            buf = buf + qStr + JspParseTag.sanitizeQuotedString(st.parseState.doctypeSystem) + qStr + " >" + "\" );";
            st.iprintln(buf);
        }
    }

    protected void emitServiceTrailer(JspEmitState st) {
        st.println("");
        st.undent();
        st.iprintln("}");
        if (canHandleThrowable_FLAG) {
            st.iprintln("catch (Throwable e) {");
        } else {
            st.iprintln("catch (Exception e) {");
        }
        st.indent();
        st.iprintln("if (!(e instanceof javax.servlet.jsp.SkipPageException)){");
        st.indent();
        st.iprintln("try {");
        st.indent();
        st.iprintln("if (out != null) out.clear();");
        st.undent();
        st.iprintln("}");
        st.iprintln("catch (Exception clearException) {");
        st.iprintln("}");
        st.iprintln("pageContext.handlePageException(e);");
        st.undent();
        st.iprintln("}");
        st.undent();
        st.iprintln("}");
        st.iprintln("finally {");
        st.indent();
        st.iprintln("OracleJspRuntime.extraHandlePCFinally(pageContext, true);");
        st.iprintln("JspFactory.getDefaultFactory().releasePageContext(pageContext);");
        st.undent();
        st.iprintln("}");
        st.println("");
        st.undent();
        st.iprintln("}");
    }

    protected void emitHelperMethods(JspEmitState st) {
        if (st.helperMethodWriter == null) {
            return;
        }
        if (st.helperMethodWriter.toString() != null && !st.helperMethodWriter.toString().equals("")) {
            st.iprintln(st.helperMethodWriter.toString());
        }
    }

    protected void emitTrailer(JspEmitState st) {
        st.println("}");
    }

    protected void emitStaticTexts(JspEmitState st) {
        Vector staticTexts = st.getStaticTexts();
        boolean textBytes = st.parms.staticTextInBytes && "com.orionserver.http.OrionHttpJspPage".equals(st.parms.extend);
        String t_encoding = null;
        if (textBytes) {
            t_encoding = JspUtils.extractEncoding(st.contentTypeUsed);
            if (t_encoding == null) {
                t_encoding = st.encodingUsed;
            }
            if (t_encoding == null) {
                t_encoding = "ISO-8859-1";
            }
            String javaEncoding = t_encoding;
            if ((t_encoding = JspUtil.convIANAtoJavaEncoding(t_encoding, false)) == null) {
                t_encoding = javaEncoding;
            }
        }
        if (st.resOut != null) {
            try {
                OracleJspRuntime.writeTexts(st.resOut, staticTexts);
                st.iprintln("");
                st.iprintln("");
                if (!st.parms.staticTextInSameClass) {
                    st.iprintln("private static class __jsp_StaticText {");
                    st.indent();
                }
                if (textBytes) {
                    st.iprintln("private static byte __oracle_jsp_text[][] = null;");
                } else {
                    st.iprintln("private static char __oracle_jsp_text[][] = null;");
                }
                st.iprintln("");
                st.iprintln("private static void initializeText() {");
                st.indent();
                if (textBytes) {
                    if (st.parms.staticTextInSameClass) {
                        st.iprintln("__oracle_jsp_text = OracleJspRuntime.readTextsAsBytes(" + st.parms.className + ".class , \"" + st.parms.className + ".res\", \"" + t_encoding + "\" );");
                    } else {
                        st.iprintln("__oracle_jsp_text = OracleJspRuntime.readTextsAsBytes(__jsp_StaticText.class , \"" + st.parms.className + ".res\", \"" + t_encoding + "\" );");
                    }
                } else if (st.parms.staticTextInSameClass) {
                    st.iprintln("__oracle_jsp_text = OracleJspRuntime.readTexts(" + st.parms.className + ".class , \"" + st.parms.className + ".res\" );");
                } else {
                    st.iprintln("__oracle_jsp_text = OracleJspRuntime.readTexts(__jsp_StaticText.class , \"" + st.parms.className + ".res\" );");
                }
                st.undent();
                st.iprintln("}");
                st.iprintln("");
                st.iprintln("private static void __ojsp_clearText() {");
                st.indent();
                st.iprintln("__oracle_jsp_text = null;");
                st.undent();
                if (!st.parms.staticTextInSameClass) {
                    st.iprintln("}");
                    st.undent();
                }
                st.iprintln("}");
            }
            catch (IOException ioe) {
                JspMessages.warningErrorWritingExternalResourceFile(ioe);
            }
            return;
        }
        if (staticTexts.size() == 0) {
            return;
        }
        if (!st.parms.staticTextInSameClass) {
            st.iprintln("private static class __jsp_StaticText {");
            st.indent();
        }
        if (textBytes) {
            st.iprintln("private static final byte __oracle_jsp_text[][]=new byte[" + staticTexts.size() + "][];");
        } else {
            st.iprintln("private static final char __oracle_jsp_text[][]=new char[" + staticTexts.size() + "][];");
        }
        st.iprintln("static {");
        st.indent();
        st.iprintln("try {");
        Enumeration e = staticTexts.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            st.iprintln("__oracle_jsp_text[" + i + "] = ");
            String text = (String)e.nextElement();
            if (textBytes) {
                st.iprintln("\"" + JspParseTag.sanitizeQuotedString(text) + "\".getBytes(\"" + t_encoding + "\");");
            } else {
                st.iprintln("\"" + JspParseTag.sanitizeQuotedString(text) + "\".toCharArray();");
            }
            ++i;
        }
        st.iprintln("}");
        st.iprintln("catch (Throwable th) {");
        st.indent();
        st.iprintln("System.err.println(th);");
        st.undent();
        st.iprintln("}");
        st.undent();
        if (!st.parms.staticTextInSameClass) {
            st.undent();
            st.iprintln("}");
        }
        st.undent();
        st.iprintln("}");
    }

    protected void emitClearText(JspEmitState st) {
        if (st.resOut != null) {
            st.println("");
            st.iprintln("public static void _clearText() {");
            st.indent();
            if (st.parms.staticTextInSameClass) {
                st.iprintln("__ojsp_clearText();");
            } else {
                st.iprintln("__jsp_StaticText.__ojsp_clearText();");
            }
            st.undent();
            st.iprintln("}");
        }
    }

    public static boolean canHandleThrowable() {
        try {
            Class pcClass = PageContext.class;
            Class[] args = new Class[]{Throwable.class};
            Method m = pcClass.getMethod("handlePageException", args);
            return m != null;
        }
        catch (Throwable th) {
            return false;
        }
    }

    protected static void emitFunctionMappings(JspEmitState st) {
        st.iprintln("// begin functions");
        st.iprintln("static {");
        st.indent();
        for (int i = 0; i < st.parseState.elFunctionsUsed.size(); ++i) {
            Hashtable h = (Hashtable)st.parseState.elFunctionsUsed.get(i);
            Enumeration e = h.keys();
            Enumeration e1 = h.elements();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                FunctionInfo value = (FunctionInfo)e1.nextElement();
                String name = value.getName();
                String sig = value.getFunctionSignature();
                String argSig = sig.substring(sig.indexOf("(") + 1, sig.lastIndexOf(")"));
                argSig.trim();
                StringTokenizer stok = new StringTokenizer(sig.substring(0, sig.lastIndexOf("(")));
                String returnType = null;
                String methodName = null;
                if (stok.hasMoreElements()) {
                    returnType = stok.nextToken();
                }
                if (stok.hasMoreElements()) {
                    methodName = stok.nextToken();
                }
                String prefix = key.substring(0, key.indexOf(":")).equals("#default") ? "" : key.substring(0, key.indexOf(":"));
                st.iprint("__ojsp_fnmappers[" + i + "].mapFunction(" + "\"" + prefix + "\"," + "\"" + name + "\"," + value.getFunctionClass() + ".class," + "\"" + methodName + "\"," + "new Class[] {");
                stok = new StringTokenizer(argSig, ",");
                String argList = null;
                while (stok.hasMoreElements()) {
                    String arg = stok.nextToken();
                    if (arg == null || "".equals(arg.trim())) continue;
                    argList = argList == null ? arg.trim() + ".class," : argList + arg.trim() + ".class,";
                }
                if (argList != null && argList.length() > 1) {
                    st.print(argList.substring(0, argList.length() - 1));
                }
                st.println("});");
            }
        }
        st.undent();
        st.iprintln("}");
        st.iprintln("// end functions");
    }

    static {
        try {
            Class.forName("com.evermind.server.http.JspCommonExtraWriter");
            isOc4jJspCommonExtraWriterDefined_flag = true;
        }
        catch (Throwable th) {
            isOc4jJspCommonExtraWriterDefined_flag = false;
        }
    }
}

