/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspBeanDictionary;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.LineInfoMapObj;
import oracle.jsp.parse.TranslatorPluginSupport;

public class JspEmitState {
    public PrintWriter out;
    public StringWriter helperMethodWriter;
    public PrintWriter outBackup;
    public OutputStream resOut;
    public String contentTypeUsed;
    public String encodingUsed;
    public Hashtable directives;
    public JspBeanDictionary beans;
    protected Vector declarations;
    protected Vector staticTexts;
    protected boolean fromTextTag = false;
    protected int lastRealJspLineNum = 0;
    protected LineInfoMapObj currentLineInfoMapObj;
    public String tabStr;
    public String tabStrBackup;
    public static final String INDENT_STR = "  ";
    public int currentLine;
    public int pageType;
    public JspParseState parseState;
    public Jsp2JavaParms parms;
    private boolean genLineInfo;
    private boolean genLineInfoComment;
    private int tagHelperCount = 0;
    protected static int emitCount = 1;
    protected String lineInfoFileName = "";
    private int lineInfoType;
    private int lineInfoNeeded;
    public static final int LINEINFO_USER = 1;
    public static final int LINEINFO_GENERATED = 2;
    public static final int LINEINFO_TRANSLATED = 3;
    private static final String JSPATTRIB_VAR_PREFIX = "_ojspAttribVal";
    private int ojspAttribSeqNo;
    private boolean fromFragment;
    private boolean fromService = false;
    private boolean fromDeclarations = false;
    protected int lineInfoLineNum;
    private int lineInfoColNum;
    private String lineInfoStr;
    protected boolean smapLineInfoNeeded = true;
    protected Vector lineInfoMapVector;
    public TranslatorPluginSupport tps;
    protected Hashtable declaredVars;
    Integer prevDepth = new Integer(0);

    public JspEmitState(PrintWriter out, OutputStream resOut, JspParseState parseState) {
        this.out = out;
        this.resOut = resOut;
        this.parseState = parseState;
        this.directives = parseState.directives;
        this.declarations = parseState.declarations;
        this.staticTexts = new Vector();
        this.beans = parseState.beans;
        this.parms = parseState.parms;
        this.genLineInfo = true;
        this.genLineInfoComment = this.parms.genLineInfo;
        this.lineInfoMapVector = new Vector();
        this.tabStr = INDENT_STR;
        this.currentLine = 1;
        this.ojspAttribSeqNo = 0;
        this.ClearLineInfo();
        this.tps = parseState.tps;
    }

    public JspEmitState(PrintWriter out, JspParseState parseState) {
        this(out, null, parseState);
    }

    private void ClearLineInfo() {
        this.lineInfoLineNum = -1;
        this.lineInfoColNum = -1;
        this.lineInfoType = 0;
        this.lineInfoNeeded = 0;
        this.lineInfoStr = null;
    }

    public String getDirectiveAttrValue(String dir, String attrName) {
        if (this.directives == null) {
            return null;
        }
        JspDirective d = (JspDirective)this.directives.get(dir);
        if (d != null) {
            return d.getAttrValue(attrName);
        }
        return null;
    }

    public void indent() {
        this.tabStr = this.tabStr.concat(INDENT_STR);
    }

    public void undent() {
        if (this.tabStr.length() > 1) {
            this.tabStr = this.tabStr.substring(INDENT_STR.length());
        }
    }

    private void outprint(String s) {
        this.out.print(s);
        this.currentLine += this.countLine(s);
    }

    private void outprintln(String s) {
        this.out.println(s);
        this.currentLine = this.currentLine + this.countLine(s) + 1;
    }

    public void savePrinter() {
        this.outBackup = this.out;
        this.tabStrBackup = this.tabStr;
        this.out = null;
        this.tabStr = INDENT_STR;
    }

    public void createHelperPrinter() {
        if (this.helperMethodWriter == null) {
            this.helperMethodWriter = new StringWriter();
        }
        if (this.out == null) {
            this.out = new PrintWriter(this.helperMethodWriter);
        }
    }

    public void closeHelperPrinter() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public void restorePrinter() {
        this.out = this.outBackup;
        this.tabStr = this.tabStrBackup;
    }

    private int countLine(String s) {
        if (s == null) {
            return 0;
        }
        int len = s.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public void print(String str) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            if (this.genLineInfoComment) {
                this.outprint(this.lineInfoStr);
            }
            this.lineInfoStr = null;
        }
        this.outprint(str);
    }

    public void iprint(String str) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            if (this.genLineInfoComment) {
                this.outprint(this.lineInfoStr);
            }
            this.outprint(this.tabStr + str);
            this.lineInfoStr = null;
        } else {
            this.outprint(this.tabStr + str);
        }
    }

    public void println(String str) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            if (this.genLineInfoComment) {
                this.outprint(this.lineInfoStr);
            }
            this.lineInfoStr = null;
        }
        this.outprintln(str);
    }

    public void iprintln(String str) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            if (this.genLineInfoComment) {
                this.outprint(this.lineInfoStr);
            }
            this.outprintln(this.tabStr + str);
            this.lineInfoStr = null;
        } else {
            this.outprintln(this.tabStr + str);
        }
    }

    public void setPageType(int type) {
        this.pageType = type;
    }

    public String getLineInfoFileName() {
        return this.lineInfoFileName;
    }

    public void printLineInfoFile(String fileName) {
        if (this.genLineInfo && fileName != null && fileName.length() > 0 && this.lineInfoFileName != fileName) {
            if (this.genLineInfoComment) {
                this.outprintln(this.tabStr + "/*@lineinfo:filename=" + fileName + "*/");
            }
            int needed = this.lineInfoNeeded;
            this.ClearLineInfo();
            this.lineInfoNeeded = needed;
        }
        this.lineInfoFileName = fileName != null ? fileName : "";
    }

    private boolean printLineInfoNeeded() {
        if (this.parms.gensmap != 0) {
            return this.printLineInfoNeededSmap();
        }
        return this.printLineInfoNeededInLineComment();
    }

    private boolean printLineInfoNeededSmap() {
        if (this.smapLineInfoNeeded && (this.fromService || this.fromDeclarations)) {
            LineInfoMapObj lineMap = new LineInfoMapObj();
            lineMap.javaLineNum = this.currentLine;
            lineMap.jspFileName = this.lineInfoFileName;
            lineMap.jspLineNum = this.fromDeclarations ? this.lineInfoLineNum : (this.parseState.parms.xmlStyleSrc ? this.lineInfoLineNum : this.lineInfoLineNum - 1);
            lineMap.jspColNum = this.lineInfoColNum;
            lineMap.lineType = this.lineInfoType;
            lineMap.lastRealJspLineNum = this.lastRealJspLineNum;
            lineMap.fromTextTag = this.fromTextTag;
            this.lineInfoMapVector.addElement(lineMap);
            this.currentLineInfoMapObj = lineMap;
        }
        return true;
    }

    private boolean printLineInfoNeededInLineComment() {
        boolean result = true;
        if (this.lineInfoNeeded != 0 && this.lineInfoNeeded != this.lineInfoType) {
            if (this.genLineInfo) {
                if (this.lineInfoNeeded == 1) {
                    if (this.genLineInfoComment) {
                        this.outprint(this.tabStr + "/*@lineinfo:user-code*/");
                    }
                    result = false;
                } else if (this.lineInfoNeeded == 2) {
                    if (this.genLineInfoComment) {
                        this.outprintln(this.tabStr + "/*@lineinfo:generated-code*/");
                    }
                    result = false;
                } else if (this.lineInfoNeeded == 3 && this.genLineInfoComment) {
                    this.outprint(this.tabStr + "/*@lineinfo:translated-code*/");
                }
            }
            this.lineInfoType = this.lineInfoNeeded;
            if (this.parms.gensmap == 0) {
                LineInfoMapObj lineMap = new LineInfoMapObj();
                lineMap.javaLineNum = this.currentLine;
                lineMap.jspFileName = this.lineInfoFileName;
                lineMap.jspLineNum = this.lineInfoLineNum - 1;
                lineMap.jspColNum = this.lineInfoColNum;
                lineMap.lineType = this.lineInfoType;
                this.lineInfoMapVector.addElement(lineMap);
            }
        }
        return result;
    }

    public LineInfoMapObj[] getLineMapArray() {
        LineInfoMapObj[] a = new LineInfoMapObj[this.lineInfoMapVector.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (LineInfoMapObj)this.lineInfoMapVector.elementAt(i);
        }
        return a;
    }

    public int getTagHelperCount() {
        return ++this.tagHelperCount;
    }

    public void printLineInfoGenerated() {
        this.printLineInfoGenerated(false);
    }

    public void printLineInfoGenerated(boolean force) {
        this.lineInfoNeeded = 2;
        if (this.genLineInfo && force) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfoUser() {
        this.printLineInfoUser(false);
    }

    public void printLineInfoUser(boolean force) {
        this.lineInfoNeeded = 1;
        if (this.genLineInfo && force) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfoTranslated() {
        this.printLineInfoTranslated(false);
    }

    public void printLineInfoTranslated(boolean force) {
        this.lineInfoNeeded = 3;
        if (this.genLineInfo && force) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfo(int lineNum, int column) {
        if (lineNum < 1) {
            lineNum = 1;
        }
        if (this.genLineInfo && (lineNum != this.lineInfoLineNum || column != this.lineInfoColNum)) {
            this.lineInfoLineNum = lineNum;
            this.lineInfoColNum = column;
            this.lineInfoStr = "/*@lineinfo:" + Integer.toString(lineNum - 1) + "^" + Integer.toString(column) + "*/";
        }
    }

    public int addStaticText(String s) {
        this.staticTexts.addElement(s);
        return this.staticTexts.size() - 1;
    }

    public Vector getStaticTexts() {
        return this.staticTexts;
    }

    public String nextJspAttributeVariableName() {
        return JSPATTRIB_VAR_PREFIX + this.ojspAttribSeqNo++;
    }

    public void setFromFragment() {
        this.fromFragment = true;
    }

    public boolean isFromFragment() {
        return this.fromFragment;
    }

    public void setFromService(boolean fromService) {
        this.fromService = fromService;
    }

    public boolean isFromService() {
        return this.fromService;
    }

    public void setFromDeclarations(boolean fromDeclarations) {
        this.fromDeclarations = fromDeclarations;
    }

    protected void processSmapForXmlSrcBodyStr(int jspLine, String str, boolean retainEnclosingOutput) {
        LineInfoMapObj cur = this.currentLineInfoMapObj;
        LineInfoMapObj lineMap = null;
        int startJavaLine = cur.javaLineNum;
        boolean firstChunk = true;
        cur.javaEndLineNum = -1;
        int pos = 0;
        int lastPos = -1;
        boolean strStartsWithNL = false;
        boolean strEndsWithNL = false;
        String lineSeparator = Character.toString('\n');
        int startPosNL = str.indexOf(lineSeparator);
        int endPosNL = str.lastIndexOf(lineSeparator);
        if (retainEnclosingOutput && startPosNL != -1) {
            if (str.startsWith(lineSeparator) || str.substring(0, startPosNL).trim().equals("")) {
                strStartsWithNL = true;
            }
            if (str.endsWith(lineSeparator) || str.substring(endPosNL, str.length()).equals("")) {
                strEndsWithNL = true;
            } else {
                str = str + lineSeparator;
            }
        }
        while (pos < str.length() && pos != -1) {
            if ((pos = str.indexOf(lineSeparator, pos)) == -1) continue;
            lastPos = pos;
            if (firstChunk) {
                firstChunk = false;
                if (pos == 0 || str.substring(0, pos).trim().equals("")) {
                    if (strStartsWithNL) {
                        ((LineInfoMapObj)this.lineInfoMapVector.elementAt((int)(this.lineInfoMapVector.size() - 1))).javaEndLineNum = -1;
                        ((LineInfoMapObj)this.lineInfoMapVector.elementAt((int)(this.lineInfoMapVector.size() - 1))).jspLineNum = jspLine + 1;
                    } else {
                        this.lineInfoMapVector.removeElementAt(this.lineInfoMapVector.size() - 1);
                    }
                }
            } else {
                lineMap = new LineInfoMapObj();
                lineMap.jspFileName = cur.jspFileName;
                lineMap.jspLineNum = ++jspLine;
                lineMap.javaLineNum = ++startJavaLine;
                lineMap.javaEndLineNum = startJavaLine;
                lineMap.lineType = cur.lineType;
                lineMap.jspColNum = cur.jspColNum;
                lineMap.lastRealJspLineNum = -1;
                lineMap.fromTextTag = false;
                this.lineInfoMapVector.addElement(lineMap);
            }
            ++pos;
        }
        if (retainEnclosingOutput) {
            if (strEndsWithNL) {
                if (lineMap != null) {
                    lineMap.javaEndLineNum = ++startJavaLine;
                } else {
                    ((LineInfoMapObj)this.lineInfoMapVector.elementAt((int)(this.lineInfoMapVector.size() - 1))).javaEndLineNum = ++startJavaLine;
                }
            }
        } else if (lastPos != -1 && !str.substring(lastPos, str.length()).trim().equals("")) {
            lineMap = new LineInfoMapObj();
            lineMap.jspFileName = cur.jspFileName;
            lineMap.jspLineNum = ++jspLine;
            lineMap.javaLineNum = ++startJavaLine;
            lineMap.javaEndLineNum = startJavaLine;
            lineMap.lineType = cur.lineType;
            lineMap.jspColNum = cur.jspColNum;
            lineMap.lastRealJspLineNum = -1;
            lineMap.fromTextTag = false;
            this.lineInfoMapVector.addElement(lineMap);
        }
    }
}

