/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;

public class JspDirectiveJsp
extends JspDirective
implements Serializable {
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[13];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("page", true);
    private static final String[] languageValue = new String[]{"java", "sqlj"};

    public JspDirectiveJsp() {
        if (attrs[0] == null) {
            JspDirectiveJsp.dirAttr.validValues = new String[0];
            JspDirectiveJsp.attrs[0] = new JspDirectiveAttrDesc("info", true, true);
            JspDirectiveJsp.attrs[0].required = false;
            JspDirectiveJsp.attrs[1] = new JspDirectiveAttrDesc("errorPage", true, true);
            JspDirectiveJsp.attrs[1].required = false;
            JspDirectiveJsp.attrs[2] = new JspDirectiveAttrDesc("session", false, true);
            JspDirectiveJsp.attrs[2].required = false;
            JspDirectiveJsp.attrs[2].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[3] = new JspDirectiveAttrDesc("isThreadSafe", false, true);
            JspDirectiveJsp.attrs[3].required = false;
            JspDirectiveJsp.attrs[3].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[4] = new JspDirectiveAttrDesc("isErrorPage", false, true);
            JspDirectiveJsp.attrs[4].required = false;
            JspDirectiveJsp.attrs[4].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[5] = new JspDirectiveAttrDesc("buffer", true, true);
            JspDirectiveJsp.attrs[5].required = false;
            JspDirectiveJsp.attrs[6] = new JspDirectiveAttrDesc("language", false, true);
            JspDirectiveJsp.attrs[6].required = false;
            JspDirectiveJsp.attrs[6].validValues = languageValue;
            JspDirectiveJsp.attrs[7] = new JspDirectiveAttrDesc("extends", true, true);
            JspDirectiveJsp.attrs[7].required = false;
            JspDirectiveJsp.attrs[8] = new JspDirectiveAttrDesc("import", ',', true, true);
            JspDirectiveJsp.attrs[8].required = false;
            JspDirectiveJsp.attrs[9] = new JspDirectiveAttrDesc("autoFlush", false, true);
            JspDirectiveJsp.attrs[9].required = false;
            JspDirectiveJsp.attrs[9].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[10] = new JspDirectiveAttrDesc("contentType", true, true);
            JspDirectiveJsp.attrs[10].required = false;
            JspDirectiveJsp.attrs[11] = new JspDirectiveAttrDesc("pageEncoding", ';', false, true, false);
            JspDirectiveJsp.attrs[11].required = false;
            JspDirectiveJsp.attrs[12] = new JspDirectiveAttrDesc("isELIgnored", false, true);
            JspDirectiveJsp.attrs[12].required = false;
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public void validateAttributes(JspParseState st) throws JspParseException {
        super.validateAttributes(st);
        String val = this.getAttrValue("isErrorPage");
        if (JspUtils.translateBoolean(val, false)) {
            st.getThisBean().addObject("exception", "java.lang.Exception", st);
        }
        if ((val = this.getAttrValue("language")) == null) {
            val = "java";
        } else {
            val = val.toLowerCase();
            val = val.trim();
        }
        if (!val.equals("java") && !val.equals("sqlj") && st.throwParseException(new JspParseException(st, msgs.getString("bad_lang")))) {
            return;
        }
        val = this.getAttrValue("buffer");
        int bufSz = JspUtils.translateBufferSize(val);
        if (bufSz == -1 && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_buffer_val"), val)))) {
            return;
        }
        if (bufSz == 0 && !JspUtils.translateBoolean(val = this.getAttrValue("autoFlush"), true) && st.throwParseException(new JspParseException(st, msgs.getString("bad_aflush_val")))) {
            return;
        }
        val = this.getAttrValue("isELIgnored");
        if (val != null) {
            if (JspUtils.isBoolean(val)) {
                st.parms.elIgnored = JspUtils.translateBoolean(val, false);
            } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_elignored_val"), val)))) {
                return;
            }
        }
    }
}

