/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspBeanDictionary;
import oracle.jsp.parse.JspBeanMethodInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;

public class JspBeanInfo
implements Serializable {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final int SCOPE_UNDEFINED = 0;
    public static final int SCOPE_PAGE = 1;
    public static final int SCOPE_REQUEST = 2;
    public static final int SCOPE_SESSION = 3;
    public static final int SCOPE_APPLICATION = 4;
    public static final int SCOPE_BLOCK = 10;
    public String name;
    public String className;
    public int scope;
    public Class bean;
    protected JspBeanInfo hides;
    private boolean isPrimitive;
    private Hashtable getMethods;
    private Hashtable setMethods;
    private BeanInfo beanInfo;
    private static final String[] primitives = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static final Class[] primitiveClass = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private boolean duplicateBean = false;

    public JspBeanInfo(String beanName, String clsName) {
        this.scope = 1;
        this.name = beanName;
        this.className = clsName;
        this.determinePrimitive();
    }

    public JspBeanInfo(String beanName, String clsName, int beanScope) {
        this.scope = beanScope;
        this.name = beanName;
        this.className = clsName;
        this.determinePrimitive();
    }

    public void setDuplicateBean(boolean duplicate) {
        this.duplicateBean = duplicate;
    }

    public boolean getDuplicateBean() {
        return this.duplicateBean;
    }

    private void determinePrimitive() {
        this.isPrimitive = false;
        for (int i = 0; i < primitives.length; ++i) {
            if (!this.className.equals(primitives[i])) continue;
            this.isPrimitive = true;
            this.bean = primitiveClass[i];
            this.className = this.bean.getName();
            break;
        }
    }

    public boolean loadBean(JspParseState st) {
        if (this.bean == null) {
            this.bean = JspUtils.loadClass(this.className, st);
        }
        return this.bean != null;
    }

    private Method findSpecificMethod(String name, Class[] parms) {
        Method m;
        if (this.isPrimitive) {
            return null;
        }
        try {
            m = this.bean.getMethod(name, parms);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        catch (SecurityException e) {
            m = null;
        }
        return m;
    }

    private JspBeanPropertyInfo findGetProperty(String name) {
        Class[] parms;
        if (this.bean == null || this.isPrimitive) {
            return null;
        }
        name = name.length() > 1 ? name.substring(0, 1).toUpperCase() + name.substring(1) : name.toUpperCase();
        String methName = "get" + name;
        Method m = this.findSpecificMethod(methName, parms = new Class[]{Integer.TYPE});
        if (m != null && !m.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(m);
        }
        parms[0] = String.class;
        m = this.findSpecificMethod(methName, parms);
        if (m != null && !m.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(m);
        }
        methName = "get" + name;
        m = this.findSpecificMethod(methName, parms = new Class[0]);
        if (m != null && !m.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(m);
        }
        methName = "is" + name;
        m = this.findSpecificMethod(methName, parms);
        if (m != null && m.getReturnType().equals(Boolean.TYPE)) {
            return new JspBeanMethodInfo(m);
        }
        return null;
    }

    private Method findMultiSetMethod(String name, Method[] list) {
        for (int i = 0; i < list.length; ++i) {
            Class<?>[] parms;
            if (!list[i].getName().equals(name) || !list[i].getReturnType().equals(Void.TYPE) || (parms = list[i].getParameterTypes()).length != 2 || !parms[0].equals(Integer.TYPE) && !parms[0].equals(class$java$lang$String == null ? JspBeanInfo.class$("java.lang.String") : class$java$lang$String)) continue;
            return list[i];
        }
        return null;
    }

    private Method findSingleSetMethod(String name, Method[] list) {
        for (int i = 0; i < list.length; ++i) {
            Class<?>[] parms;
            if (!list[i].getName().equals(name) || !list[i].getReturnType().equals(Void.TYPE) || (parms = list[i].getParameterTypes()).length != 1) continue;
            return list[i];
        }
        return null;
    }

    private boolean determineSetPropertyOverloading(String name) {
        if (this.bean == null) {
            return false;
        }
        String methName = name.length() > 1 ? name.substring(0, 1).toUpperCase() + name.substring(1) : name.toUpperCase();
        Method[] mList = this.bean.getMethods();
        methName = "set" + methName;
        return this.determineOverloading(methName, mList);
    }

    private boolean determineOverloading(String methodName, Method[] list) {
        boolean ol = false;
        boolean found = false;
        for (int i = 0; i < list.length; ++i) {
            Class<?>[] parms;
            if (!list[i].getName().equals(methodName) || (parms = list[i].getParameterTypes()).length != 1) continue;
            if (!found) {
                found = true;
                continue;
            }
            ol = true;
            break;
        }
        return ol;
    }

    private JspBeanPropertyInfo findSetProperty(String name) {
        if (this.bean == null || this.isPrimitive) {
            return null;
        }
        name = name.length() > 1 ? name.substring(0, 1).toUpperCase() + name.substring(1) : name.toUpperCase();
        Method[] mList = this.bean.getMethods();
        String methName = "set" + name;
        Method m = this.findMultiSetMethod(methName, mList);
        if (m != null) {
            return new JspBeanMethodInfo(m);
        }
        m = this.findSingleSetMethod(methName, mList);
        if (m != null) {
            return new JspBeanMethodInfo(m);
        }
        return null;
    }

    private JspBeanPropertyInfo createGetPropertyFromBean(PropertyDescriptor prop) {
        JspBeanMethodInfo info;
        if (prop instanceof IndexedPropertyDescriptor) {
            Method m = ((IndexedPropertyDescriptor)prop).getIndexedReadMethod();
            if (m == null) {
                return null;
            }
            info = new JspBeanMethodInfo(m, ((IndexedPropertyDescriptor)prop).getIndexedPropertyType());
        } else {
            Method m = prop.getReadMethod();
            if (m == null) {
                return null;
            }
            info = new JspBeanMethodInfo(m, prop.getPropertyType());
            info.isMultiValue = false;
        }
        return info;
    }

    private JspBeanPropertyInfo createSetPropertyFromBean(PropertyDescriptor prop) {
        JspBeanMethodInfo info;
        if (prop instanceof IndexedPropertyDescriptor) {
            Method m = ((IndexedPropertyDescriptor)prop).getIndexedWriteMethod();
            if (m == null) {
                return null;
            }
            info = new JspBeanMethodInfo(m, ((IndexedPropertyDescriptor)prop).getIndexedPropertyType());
        } else {
            Method m = prop.getWriteMethod();
            if (m == null) {
                return null;
            }
            info = new JspBeanMethodInfo(m, prop.getPropertyType());
            info.isMultiValue = false;
        }
        return info;
    }

    private JspBeanPropertyInfo beanGetProperty(String name) {
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        if (props == null || props.length == 0) {
            return null;
        }
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            JspBeanPropertyInfo info = this.createGetPropertyFromBean(props[i]);
            if (info != null) {
                this.addGet(name, info);
            }
            return info;
        }
        return null;
    }

    private JspBeanPropertyInfo beanSetProperty(String name) {
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        if (props == null || props.length == 0) {
            return null;
        }
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            JspBeanPropertyInfo info = this.createSetPropertyFromBean(props[i]);
            if (info != null) {
                this.addSet(name, info);
            }
            return info;
        }
        return null;
    }

    public JspBeanPropertyInfo getGetProperty(String name, boolean allowField) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo info = this.getGetProperty(name);
        if (info != null) {
            return info;
        }
        return null;
    }

    private JspBeanPropertyInfo checkCache(Hashtable cache, String name) {
        JspBeanPropertyInfo info;
        if (cache != null && (info = (JspBeanPropertyInfo)cache.get(name)) != null) {
            return info;
        }
        return null;
    }

    protected void addGet(String name, JspBeanPropertyInfo info) {
        if (this.getMethods == null) {
            this.getMethods = new Hashtable();
        }
        this.getMethods.put(name, info);
    }

    protected void addSet(String name, JspBeanPropertyInfo info) {
        if (this.setMethods == null) {
            this.setMethods = new Hashtable();
        }
        this.setMethods.put(name, info);
    }

    public JspBeanPropertyInfo getGetProperty(String name) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo info = this.checkCache(this.getMethods, name);
        if (info != null) {
            return info;
        }
        info = this.beanGetProperty(name);
        if (info != null) {
            return info;
        }
        info = this.findGetProperty(name);
        if (info == null) {
            return null;
        }
        this.addGet(name, info);
        return info;
    }

    public JspBeanPropertyInfo getSetProperty(String name) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo info = this.checkCache(this.setMethods, name);
        if (info != null) {
            return info;
        }
        boolean isOverloaded = this.determineSetPropertyOverloading(name);
        info = this.beanSetProperty(name);
        if (info != null) {
            info.overloaded = isOverloaded;
            return info;
        }
        info = this.findSetProperty(name);
        if (info == null) {
            return null;
        }
        info.overloaded = isOverloaded;
        this.addSet(name, info);
        return info;
    }

    private void getBeanInfo() {
        if (this.beanInfo == null) {
            if (this.bean == null) {
                this.beanInfo = null;
            } else {
                try {
                    this.beanInfo = Introspector.getBeanInfo(this.bean);
                }
                catch (IntrospectionException e) {
                    this.beanInfo = null;
                }
            }
        }
    }

    public JspBeanPropertyInfo getDefaultGetProperty(JspBeanDictionary beans, boolean allowField) {
        JspBeanPropertyInfo info;
        String defaultPropName;
        if (this.isPrimitive) {
            return null;
        }
        if (this.bean != null && (defaultPropName = beans.getDefaultProperty(this.bean.getName())) != null && (info = this.getGetProperty(defaultPropName, true)) != null) {
            return info;
        }
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        int idx = this.beanInfo.getDefaultPropertyIndex();
        if (idx < 0) {
            return null;
        }
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        if (props == null || idx >= props.length) {
            return null;
        }
        return this.createGetPropertyFromBean(props[idx]);
    }

    protected void removeCachedGet(String name) {
        if (this.getMethods == null) {
            return;
        }
        this.getMethods.remove(name);
    }

    public static int stringToScope(String scope) {
        if (scope.equals("page")) {
            return 1;
        }
        if (scope.equals("request")) {
            return 2;
        }
        if (scope.equals("session")) {
            return 3;
        }
        if (scope.equals("application")) {
            return 4;
        }
        return 0;
    }
}

