/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jsp.parse.Include;
import oracle.jsp.parse.Into;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.XMLUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GlobalInclude {
    public static final String GLOBAL_INCLUDE_FILE = "/WEB-INF/ojsp-global-include.xml";
    protected Vector includes = new Vector();
    private int includeNum = 0;

    public Vector getIncludes() {
        return this.includes;
    }

    public void loadIncludeData(JspParseState st, InputStream is) throws IOException, XMLParseException, SAXException, IllegalArgumentException {
        DOMParser parser = new DOMParser();
        DTD dtd = XMLUtil.getDTD("ojsp-global-include.dtd", "ojsp-global-include");
        parser.setDoctype(dtd);
        if (st.parms.validate) {
            parser.setValidationMode(2);
        } else {
            parser.setValidationMode(0);
        }
        parser.showWarnings(true);
        parser.parse(is);
        XMLDocument doc = parser.getDocument();
        Element elements = doc.getDocumentElement();
        NodeList nl = elements.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            if (nodeName.equals("include")) {
                this.loadInclude(e);
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(n instanceof Element) || !(nodeName = (e = (Element)child).getNodeName()).equals("into")) continue;
                Include include = (Include)this.includes.get(this.includeNum - 1);
                include.loadIntos(e);
            }
        }
    }

    private void loadInclude(Element e) throws IllegalArgumentException {
        Include include = new Include();
        include.addFileName(e.getAttribute("file"));
        include.addPosition(e.getAttribute("position"));
        this.includes.add(this.includeNum, include);
        ++this.includeNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream fixUpProcessingInstruction(JspParseState st) throws IOException {
        BufferedReader lnr = null;
        String s = null;
        String temp = null;
        try {
            InputStream is = XMLUtil.getFromStream(st, GLOBAL_INCLUDE_FILE);
            if (is == null || !st.parms.validate) {
                InputStream inputStream = is;
                return inputStream;
            }
            lnr = new LineNumberReader(st.parms.resourceProvider.fromReader(GLOBAL_INCLUDE_FILE, st.parms.encoding));
            s = ((LineNumberReader)lnr).readLine();
            int yesIndex = s.indexOf("yes");
            if (yesIndex == -1) {
                yesIndex = s.indexOf("YES");
            }
            if (yesIndex == -1) {
                InputStream inputStream = is;
                return inputStream;
            }
            s = s.substring(0, yesIndex) + "no" + s.substring(yesIndex + 3, s.length());
            while ((temp = ((LineNumberReader)lnr).readLine()) != null) {
                s = s + temp;
            }
            byte[] buf = new byte[s.length()];
            buf = s.getBytes(st.parms.encoding);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            return byteArrayInputStream;
        }
        catch (FileNotFoundException fnfe) {
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (lnr != null) {
                lnr.close();
            }
        }
    }

    public static GlobalInclude getGlobalInclude(JspParseState st) throws JspParseException, IOException {
        block12: {
            try {
                GlobalInclude giObj = null;
                if (st.parms.cachedConfigTable != null) {
                    giObj = (GlobalInclude)st.parms.cachedConfigTable.getConfigObject(GLOBAL_INCLUDE_FILE, GlobalInclude.class, st);
                }
                if (giObj == null) {
                    InputStream is = GlobalInclude.fixUpProcessingInstruction(st);
                    if (is == null) {
                        return null;
                    }
                    giObj = new GlobalInclude();
                    giObj.loadIncludeData(st, is);
                    if (st.parms.cachedConfigTable != null) {
                        st.parms.cachedConfigTable.setConfigObject(GLOBAL_INCLUDE_FILE, giObj, st);
                    }
                    return giObj;
                }
                return giObj;
            }
            catch (IOException jrre) {
                if (st.throwParseException(new JspParseException(st, jrre.toString()))) {
                    return null;
                }
            }
            catch (XMLParseException xpe) {
                if (st.throwParseException(new JspParseException(st, "/WEB-INF/ojsp-global-include.xml:" + xpe.toString()))) {
                    return null;
                }
            }
            catch (SAXException se) {
                if (st.throwParseException(new JspParseException(st, "/WEB-INF/ojsp-global-include.xml:" + se.toString()))) {
                    return null;
                }
            }
            catch (IllegalArgumentException iae) {
                if (!st.throwParseException(new JspParseException(st, "/WEB-INF/ojsp-global-include.xml:" + iae.toString()))) break block12;
                return null;
            }
        }
        return null;
    }

    protected static boolean equalFilePath(String f1, String f2) {
        if (File.separatorChar == '\\') {
            return f1.equalsIgnoreCase(f2);
        }
        return f1.equals(f2);
    }

    protected void matchGlobalInclude(int position, JspParseState st, JspParseTagFile srcRoot) throws JspParseException, IOException {
        Enumeration e = this.getIncludes().elements();
        while (e.hasMoreElements()) {
            Include iObj = (Include)e.nextElement();
            if (iObj.getPosition() != position) continue;
            Enumeration intoEnum = iObj.getIntos().elements();
            while (intoEnum.hasMoreElements()) {
                String srcFile = st.position.currentSourceFile;
                Into intoObj = (Into)intoEnum.nextElement();
                String dirPath = intoObj.getDirectory();
                if (!srcFile.startsWith(dirPath) || GlobalInclude.equalFilePath(srcFile, iObj.getFileName())) continue;
                if (intoObj.getSubdir()) {
                    srcRoot.addGlobalIncludeDirective(st, iObj.getFileName(), position);
                    continue;
                }
                if (srcFile.lastIndexOf("/") > dirPath.length()) continue;
                srcRoot.addGlobalIncludeDirective(st, iObj.getFileName(), position);
            }
        }
    }
}

