/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jsp.parse.CachedConfigEntry;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.XMLUtil;

public class CachedConfigTable {
    Hashtable table = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfigObject(String name, Class kl, JspParseState st) throws IOException {
        long cur;
        CachedConfigEntry entry = (CachedConfigEntry)this.table.get(kl.getName() + ":" + name);
        if (entry == null) {
            return null;
        }
        try {
            if (entry.overridingLocation != null) {
                if (!entry.direct) {
                    cur = XMLUtil.getLastModified(st, entry.overridingLocation);
                } else {
                    File f = new File(entry.overridingLocation);
                    if (!f.exists()) {
                        Hashtable hashtable = this.table;
                        synchronized (hashtable) {
                            this.table.remove(name);
                            return null;
                        }
                    }
                    cur = f.lastModified();
                }
            } else {
                cur = XMLUtil.getLastModified(st, name);
            }
        }
        catch (FileNotFoundException fnfe) {
            Hashtable hashtable = this.table;
            synchronized (hashtable) {
                this.table.remove(name);
                return null;
            }
        }
        if (cur != entry.timestamp) {
            Hashtable hashtable = this.table;
            synchronized (hashtable) {
                this.table.remove(name);
                return null;
            }
        }
        return entry.configObj;
    }

    public CachedConfigEntry getCachedConfigEntry(String name, Class kl, JspParseState st) throws IOException {
        CachedConfigEntry entry = (CachedConfigEntry)this.table.get(kl.getName() + ":" + name);
        return entry;
    }

    public void setConfigObject(String name, Object obj, JspParseState st) throws IOException, FileNotFoundException {
        this.setConfigObject(name, obj, null, false, st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigObject(String name, Object obj, String overridingLocation, boolean direct, JspParseState st) throws IOException, FileNotFoundException {
        long cur;
        if (overridingLocation != null) {
            cur = !direct ? XMLUtil.getLastModified(st, overridingLocation) : new File(overridingLocation).lastModified();
        } else if (name.startsWith("__tagdir:")) {
            String location = name.substring("__tagdir:".length());
            cur = XMLUtil.getLastModified(st, location);
        } else {
            cur = XMLUtil.getLastModified(st, name);
        }
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            CachedConfigEntry entry = new CachedConfigEntry();
            entry.timestamp = cur;
            entry.configObj = obj;
            entry.overridingLocation = overridingLocation;
            entry.direct = direct;
            this.table.put(obj.getClass().getName() + ":" + name, entry);
        }
    }

    public Enumeration getConfigObjectEnum() {
        return this.table.keys();
    }

    public boolean containsClass(String className) {
        Enumeration enumerator = this.table.keys();
        while (enumerator.hasMoreElements()) {
            String elem = (String)enumerator.nextElement();
            if (!elem.startsWith(className)) continue;
            return true;
        }
        return false;
    }
}

