/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.LoggingUtils;
import oracle.jsp.logger.JspMessageBundle;

public class JspMessages {
    private static Logger m_logger = Logger.getLogger("oracle.j2ee.jsp", JspMessageBundle.class.getName());

    public static void logException(Throwable t) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0001", t);
        }
    }

    public static void logException(String addmsg, Throwable t) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0001 " + addmsg, t);
        }
    }

    public static void logException(String msg) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0001 " + msg);
        }
    }

    public static void logParseException(Throwable t) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0002", t);
        }
    }

    public static void logParseException(String addmsg, Throwable t) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0002 " + addmsg, t);
        }
    }

    public static void logParseException(String msg) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0002 " + msg);
        }
    }

    public static void logTldCacheException(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0003", t.toString());
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void logTldCacheException(String addmsg, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0003 " + addmsg, t);
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void logTldCacheException(String msg) {
        if (JspMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JSP-0003 " + msg);
        }
    }

    public static void logWarning(String msg, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0004 " + msg, t);
        }
    }

    public static void logWarning(String msg) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0004 " + msg);
        }
    }

    public static void logWarning(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0004", t);
        }
    }

    static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void logFineStackTrace(Throwable t) {
        if (JspMessages.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            m_logger.finer(sw.toString());
        }
    }

    public static void warningSendErrorFailed(int responseCode, String message, Throwable cause) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, " J2EE JSP-0005", new Object[]{new Integer(responseCode), message});
            LoggingUtils.logWarningStackTrace((Logger)m_logger, (Throwable)cause);
        }
    }

    public static void warningErrorWritingFailed(String message, Throwable cause) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, " J2EE JSP-0009", new Object[]{message});
            LoggingUtils.logWarningStackTrace((Logger)m_logger, (Throwable)cause);
        }
    }

    public static void infoResourceFileNotFound(String message) {
        if (JspMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, " J2EE JSP-0007", new Object[]{message});
        }
    }

    public static void infoCannotDispatchJspPage(String message) {
        if (JspMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, " J2EE JSP-0008", new Object[]{message});
        }
    }

    public static void infoPrepareAuxObjFailed(String message, Throwable t) {
        if (JspMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, " J2EE JSP-0006", new Object[]{message, t.toString()});
        }
    }

    public static void fineBuildingTldCache(String cacheName) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0010", new Object[]{cacheName});
        }
    }

    public static void fineRefreshingTldCache(String cacheName) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0031", new Object[]{cacheName});
        }
    }

    public static void fineReadingTldCache(String cacheName) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0015", new Object[]{cacheName});
        }
    }

    public static void fineLookingForGlobalResource(String resourcePath) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0032", new Object[]{resourcePath});
        }
    }

    public static void fineGettingCurrentResourceDone() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0012");
        }
    }

    public static void fineInitializingTldCacheDone() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0013");
        }
    }

    public static void fineUpdatingTldCacheDone() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0016");
        }
    }

    public static void finePersistingTldCacheDone() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0019");
        }
    }

    public static void fineWritingTldCacheDone() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0020");
        }
    }

    public static void fineListenerSize(String size) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0014", new Object[]{size});
        }
    }

    public static void fineFoundListener(String listenerName) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0025", new Object[]{listenerName});
        }
    }

    public static void fineInsertingURL(String url) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0017", new Object[]{url});
        }
    }

    public static void fineUpdatingURL(String url) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0018", new Object[]{url});
        }
    }

    public static void fineURLForEntry(String url) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0021", new Object[]{url});
        }
    }

    public static void fineLoadingDirectTld(String name, String location) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0022", new Object[]{name, location});
        }
    }

    public static void fineLoadingIndirectTld(String name, String location) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0023", new Object[]{name, location});
        }
    }

    public static void fineLoadingTldFile(String name, String location) {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0024", new Object[]{name, location});
        }
    }

    public static void fineLoadingCacheConfigTable() {
        if (JspMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JSP-0034");
        }
    }

    public static void warningInvalidTldOrMissingURI(String uri) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0026", new Object[]{uri});
        }
    }

    public static void warningTldParseError(String url) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0027", new Object[]{url});
        }
    }

    public static void warningDuplicateURI(String uri, String loc1, String loc2) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0028", new Object[]{uri, loc1, loc2});
        }
    }

    public static void warningBadTldCacheKey(String uri) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0029", new Object[]{uri});
        }
    }

    public static void warningInvalidTaglibLoc(String location) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0011", new Object[]{location});
        }
    }

    public static void warningErrorGettingJSPParams() {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0030");
        }
    }

    public static void warningInvalidTldVersion(String version) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0033", new Object[]{version});
        }
    }

    public static void warningErrorWritingExternalResourceFile(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0035", t.getMessage());
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningErrorGettingTaglibListeners(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0036", t.getMessage());
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningCannotLoadTlibFromWebXML(String loc) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0037", loc);
        }
    }

    public static void warningErrorPreparingDependencyFileForTagFile(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0038");
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningInvalidTagFilePath(String path) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0039", path);
        }
    }

    public static void warningDuplicateTagNameInTld(String name, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0040", name);
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningInvalidMainModeValue(String name, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0041", name);
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningInvalidJsr45DebugValue(String name, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0042", name);
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningInvalidTagsReuseValue(String name, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP-0043", name);
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningAnnotationLifeCycleFailed(String method, Exception e) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.INFO, "J2EE JSP0044", new Object[]{method});
            JspMessages.logFineStackTrace(e);
        }
    }

    public static void warningAnnotationScanningFailureForTag(String tagName, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP0045", new Object[]{tagName, t.getMessage()});
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningAnnotationScanningFailure(Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JSP0048", new Object[]{t.getMessage()});
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningAnnotationTagNotFound(String tagName, Throwable t) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.INFO, "J2EE JSP0046", new Object[]{tagName});
            JspMessages.logFineStackTrace(t);
        }
    }

    public static void warningAnnotationNotATag(String tagName, Exception e) {
        if (JspMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.INFO, "J2EE JSP0047", new Object[]{tagName});
            JspMessages.logFineStackTrace(e);
        }
    }

    public static void infoProviderURIUsed(String message) {
        if (JspMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE JSP-0052", new Object[]{message});
        }
    }
}

