/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.el;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import oracle.jsp.el.OracleExpression;
import org.apache.commons.el.ArraySuffix;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.Constants;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PropertySuffix;

public class OracleExpressionEvaluator
extends ExpressionEvaluatorImpl {
    public OracleExpressionEvaluator() {
    }

    public OracleExpressionEvaluator(boolean byPassCache) {
        super(byPassCache);
    }

    public Object evaluate(String pExpressionString, Class pExpectedType, VariableResolver pResolver, FunctionMapper functions) throws ELException {
        return super.evaluate(pExpressionString, pExpectedType, pResolver, functions);
    }

    public Expression parseExpression(String expression, Class expectedType, FunctionMapper fMapper) throws ELException {
        this.parseExpressionString(expression);
        return new OracleExpression(this, expression, expectedType, fMapper);
    }

    public void setValue(String pExpressionString, VariableResolver pResolver, FunctionMapper functions, Object value) throws ELException {
        if (pExpressionString == null) {
            throw new ELException(Constants.NULL_EXPRESSION_STRING);
        }
        Object parsedValue = this.parseExpressionString(pExpressionString);
        if (parsedValue instanceof ComplexValue) {
            ComplexValue complex_value = (ComplexValue)parsedValue;
            this.complex_value_setValue(complex_value, pResolver, functions, null, value);
        } else {
            System.out.println("No compatible type found for setValue");
        }
    }

    private void complex_value_setValue(ComplexValue complex_value, VariableResolver pResolver, FunctionMapper functions, Logger pLogger, Object value) throws ELException {
        org.apache.commons.el.Expression prefix = complex_value.getPrefix();
        Object ret = prefix.evaluate(pResolver, functions, pLogger);
        List suffixes = complex_value.getSuffixes();
        for (int i = 0; suffixes != null && i < suffixes.size(); ++i) {
            if (!(suffixes.get(i) instanceof ArraySuffix)) continue;
            ArraySuffix suffix = (ArraySuffix)suffixes.get(i);
            if (i == suffixes.size() - 1) {
                this.array_suffix_setValue(suffix, ret, pResolver, functions, pLogger, value);
                continue;
            }
            ret = suffix.evaluate(ret, pResolver, functions, pLogger);
        }
    }

    private void array_suffix_setValue(ArraySuffix suffix, Object pValue, VariableResolver pResolver, FunctionMapper functions, Logger pLogger, Object value) throws ELException {
        block26: {
            if (pValue == null) {
                if (pLogger.isLoggingWarning()) {
                    pLogger.logWarning(Constants.CANT_GET_INDEXED_VALUE_OF_NULL, (Object)this.getOperatorSymbol(suffix));
                }
            } else {
                Object indexVal = this.evaluateIndex(suffix, pResolver, functions, pLogger);
                if (indexVal == null) {
                    if (pLogger.isLoggingWarning()) {
                        pLogger.logWarning(Constants.CANT_GET_NULL_INDEX, (Object)this.getOperatorSymbol(suffix));
                    }
                } else if (pValue instanceof Map) {
                    Map val = (Map)pValue;
                    val.put(indexVal, value);
                } else if (pValue instanceof List || pValue.getClass().isArray()) {
                    Integer indexObj = Coercions.coerceToInteger((Object)indexVal, (Logger)pLogger);
                    if (indexObj == null) {
                        if (pLogger.isLoggingError()) {
                            pLogger.logError(Constants.BAD_INDEX_VALUE, (Object)this.getOperatorSymbol(suffix), (Object)indexVal.getClass().getName());
                        }
                    } else {
                        if (pValue instanceof List) {
                            try {
                                ((List)pValue).set(indexObj, value);
                            }
                            catch (ArrayIndexOutOfBoundsException exc) {
                                if (pLogger.isLoggingWarning()) {
                                    pLogger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)exc, (Object)indexObj);
                                }
                                break block26;
                            }
                            catch (IndexOutOfBoundsException exc) {
                                if (pLogger.isLoggingWarning()) {
                                    pLogger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)exc, (Object)indexObj);
                                }
                                break block26;
                            }
                            catch (Exception exc) {
                                if (pLogger.isLoggingError()) {
                                    pLogger.logError(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)exc, (Object)indexObj);
                                }
                                break block26;
                            }
                        }
                        try {
                            Array.set(pValue, indexObj, value);
                        }
                        catch (ArrayIndexOutOfBoundsException exc) {
                            if (pLogger.isLoggingWarning()) {
                                pLogger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)exc, (Object)indexObj);
                            }
                        }
                        catch (IndexOutOfBoundsException exc) {
                            if (pLogger.isLoggingWarning()) {
                                pLogger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)exc, (Object)indexObj);
                            }
                        }
                        catch (Exception exc) {
                            if (!pLogger.isLoggingError()) break block26;
                            pLogger.logError(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)exc, (Object)indexObj);
                        }
                    }
                }
            }
        }
    }

    private Object evaluateIndex(ArraySuffix suffix, VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        if (suffix instanceof PropertySuffix) {
            return ((PropertySuffix)suffix).getName();
        }
        return suffix.getIndex().evaluate(pResolver, functions, pLogger);
    }

    private String getOperatorSymbol(ArraySuffix suffix) {
        if (suffix instanceof PropertySuffix) {
            return ".";
        }
        return "[]";
    }

    private Object escapeOutput(String input) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '<') {
                sbuf.append("&lt;");
                continue;
            }
            if (input.charAt(i) == '>') {
                sbuf.append("&gt;");
                continue;
            }
            if (input.charAt(i) == '&') {
                sbuf.append("&amp;");
                continue;
            }
            if (input.charAt(i) == '\'') {
                sbuf.append("&#039;");
                continue;
            }
            if (input.charAt(i) == '\"') {
                sbuf.append("&#034;");
                continue;
            }
            sbuf.append(input.charAt(i));
        }
        return sbuf.toString();
    }
}

