/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.app;

import com.evermind.compiler.CompilerFactory;
import com.evermind.compiler.LinkedCompiler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.jsp.app.JspExecUtil;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.LineInfoMapObj;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspCompiler;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.util.JspUtil;
import oracle.jsp.util.SystemPropertyAction;

public class JspJavacCompiler
implements JspCompiler {
    public static final String COMPILE_PATH = "classpath";
    private String classPath;
    private boolean needsInit = true;
    private static final String MESSAGE_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.app.LocalStrings");
    private String javacCmd = null;
    boolean use_old_compiler = false;
    private static String[] sysClassPathEnv = new String[]{"CLASSPATH=" + (String)AccessController.doPrivileged(new SystemPropertyAction("java.class.path"))};
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void init(Hashtable initParams) {
        if (this.needsInit) {
            this.classPath = (String)initParams.get(COMPILE_PATH);
            this.needsInit = false;
        }
    }

    public void setJavacCmd(String javacCmd) {
        this.javacCmd = javacCmd;
    }

    public void setUseOldCompiler(boolean val) {
        this.use_old_compiler = val;
    }

    public long compile(String source, int language, String encoding, JspResourceProvider provider, JspResourceProvider appClassProvider) throws JspCompileException {
        return this.compile(source, language, encoding, provider, appClassProvider, null);
    }

    public long compile(String source, int language, String encoding, JspResourceProvider provider, JspResourceProvider appClassProvider, Jsp2JavaParms parms) throws JspCompileException {
        boolean result;
        String[] argv;
        String appClassPath;
        ByteArrayOutputStream compileOut;
        int index;
        block15: {
            if (language != 0) {
                throw new JspCompileException(msgs.getString("bad_lang"));
            }
            index = 0;
            compileOut = new ByteArrayOutputStream();
            if ((source = provider.translateToAbsolutePath(source)) == null) {
                throw new JspCompileException(msgs.getString("no_files_rep"));
            }
            appClassPath = this.generateAppClassPath(appClassProvider);
            String tagFileRepositoryRoot = null;
            if (parms != null && parms.tagFileRepository != null) {
                tagFileRepositoryRoot = parms.tagFileRepository.getRepositoryRoot();
                appClassPath = appClassPath == null ? tagFileRepositoryRoot : appClassPath + File.pathSeparator + tagFileRepositoryRoot;
            }
            index = 0;
            argv = encoding == null ? new String[3] : new String[5];
            argv[index++] = source;
            if (encoding != null) {
                argv[index++] = "-encoding";
                argv[index++] = encoding;
            }
            argv[index++] = "-classpath";
            try {
                PolicyClassLoader contextLoader = (PolicyClassLoader)Thread.currentThread().getContextClassLoader();
                argv[index] = ClassLoaderQuery.getFullClassPath((PolicyClassLoader)contextLoader);
            }
            catch (Exception ex) {
                JspMessages.logException("Wrong classLoader set on thread, find classpath from java System property : ", ex);
                argv[index] = (String)AccessController.doPrivileged(new SystemPropertyAction("java.class.path"));
                if (this.classPath == null) break block15;
                argv[index] = argv[index] + File.pathSeparator + this.classPath;
            }
        }
        if (appClassPath != null) {
            argv[index] = argv[index] + File.pathSeparator + appClassPath;
        }
        try {
            Class.forName("com.evermind.compiler.CompilerFactory", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            this.use_old_compiler = true;
        }
        if (this.javacCmd == null && !this.use_old_compiler) {
            String classpath = argv[index];
            File target = new File(JspUtil.replaceTargetExtension(source, ".class"));
            long target_date = 0L;
            if (target.exists()) {
                target_date = target.lastModified();
            }
            CompilerFactory compiler_factory = CompilerFactory.instance();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            LinkedCompiler compiler = compiler_factory.create(loader);
            compiler.setOutputStream((OutputStream)compileOut);
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(source);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(COMPILE_PATH, classpath);
            properties.put("encoding", encoding);
            properties.put("source.is.class.name", "false");
            try {
                compiler.compile(sources, null, null, properties);
            }
            catch (Exception e) {
                boolean result2 = false;
                PrintWriter out = new PrintWriter(compileOut);
                out.println(e.getMessage());
            }
            result = target.exists() && target.lastModified() > target_date;
        } else {
            int code;
            result = this.javacCmd == null && this.use_old_compiler ? (Boolean)AccessController.doPrivileged(new CompileAction("javac", argv, compileOut)) : (code = JspExecUtil.executeWmsg(this.javacCmd, argv, sysClassPathEnv, compileOut)) == 0;
        }
        String cs = compileOut.toString();
        if (!result) {
            throw new JspCompileException(this.formatException(source, cs, parms));
        }
        return new File(this.stripExtension(source) + ".class").lastModified();
    }

    private String generateAppClassPath(JspResourceProvider provider) {
        String classPath = null;
        try {
            classPath = provider.getAbsolutePath("/WEB-INF/classes");
        }
        catch (Throwable t) {
            // empty catch block
        }
        String[] theJars = provider.listClassRepositories("/WEB-INF/lib");
        if (theJars == null) {
            return classPath;
        }
        for (int i = 0; i < theJars.length; ++i) {
            String jarPath = null;
            try {
                jarPath = provider.getAbsolutePath("/WEB-INF/lib/" + theJars[i]);
                if (classPath == null) {
                    classPath = jarPath;
                    continue;
                }
                classPath = classPath + File.pathSeparator + jarPath;
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return classPath;
    }

    private String formatException(String fName, String compilerOutput, Jsp2JavaParms parms) {
        String formattedString = null;
        boolean formatted = false;
        String deprecatedMsg1 = ": sun.tools.javac.Main";
        String deprecatedMsg2 = ":sun.tools.javac.Main";
        try {
            String firstLine;
            formattedString = new String("<H3>" + msgs.getString("compile_error_hdr") + fName + "</H3><TABLE BORDER=1 WIDTH=100%><TR><TH ALIGN=CENTER>Line #</TH><TH ALIGN=CENTER>Error</TH></TR>");
            boolean index = false;
            int currI = 0;
            int nextI = 0;
            int firstLineIdx = compilerOutput.indexOf(10);
            if (firstLineIdx > 0 && ((firstLine = compilerOutput.substring(0, firstLineIdx)).indexOf(deprecatedMsg1) >= 0 || firstLine.indexOf(deprecatedMsg2) >= 0)) {
                currI = firstLineIdx;
                nextI = firstLineIdx;
            }
            while ((nextI = compilerOutput.indexOf(94, currI)) != -1) {
                if (nextI != currI) {
                    int startL = compilerOutput.indexOf(58, currI);
                    if (File.separatorChar == '\\') {
                        startL = compilerOutput.indexOf(58, startL + 1);
                    }
                    int endL = 0;
                    if (startL != -1) {
                        endL = compilerOutput.indexOf(58, startL + 1);
                        String lineNum = compilerOutput.substring(startL + 1, endL);
                        String msg = compilerOutput.substring(endL + 1, nextI);
                        int javaLine = Integer.parseInt(lineNum);
                        formattedString = formattedString.concat("<TR><TD WIDTH=7% VALIGN=TOP><P ALIGN=CENTER>" + lineNum + "</TD><TD>" + JspJavacCompiler.getJspLineInfo(javaLine, parms) + msg + "</TD></TR>");
                        formatted = true;
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                currI = nextI + 1;
            }
            formattedString = formattedString.concat("</TABLE>");
        }
        catch (Exception e) {
            formatted = false;
        }
        if (!formatted) {
            formattedString = "<H3>" + msgs.getString("compile_error_hdr") + fName + "</H3>" + "<pre>" + compilerOutput + "</pre>";
        }
        return formattedString;
    }

    private static String getJspLineInfo(int javaLine, Jsp2JavaParms parms) {
        if (parms != null && parms.lineMap != null && javaLine > 0) {
            String extraLine = null;
            String topLevelFileName = parms.lineMap[0].jspFileName;
            LineInfoMapObj mapobj = LineInfoMapObj.matchMap(parms.lineMap, javaLine);
            if (mapobj != null) {
                if (!topLevelFileName.equals(mapobj.jspFileName)) {
                    extraLine = "[jsp src:" + mapobj.jspFileName;
                } else if (mapobj.lineType != 2) {
                    extraLine = "[jsp src";
                }
                switch (mapobj.lineType) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        extraLine = extraLine + ":line #:" + (mapobj.jspLineNum + (javaLine - mapobj.javaLineNum));
                        break;
                    }
                    case 3: {
                        extraLine = extraLine + ":line #:" + mapobj.jspLineNum;
                        break;
                    }
                    case 0: {
                        extraLine = extraLine + ":line #:" + mapobj.jspLineNum;
                    }
                }
            }
            if (extraLine != null) {
                return extraLine + "]<br>";
            }
            return "";
        }
        return "";
    }

    private String stripExtension(String s) {
        return s.substring(0, s.lastIndexOf(46));
    }

    class CompileAction
    implements PrivilegedAction {
        String[] argv;
        ByteArrayOutputStream compileOut;
        String main;

        public CompileAction(String main, String[] argv, ByteArrayOutputStream compileOut) {
            this.main = main;
            this.argv = argv;
            this.compileOut = compileOut;
        }

        public Object run() {
            if (this.main.equals("javac")) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> javac = Class.forName("sun.tools.javac.Main", true, loader);
                    Constructor<?> constructor = javac.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = JspJavacCompiler.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = JspJavacCompiler.class$("java.lang.String")) : class$java$lang$String);
                    Object javac_inst = constructor.newInstance(this.compileOut, "javac");
                    Method compile = javac.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JspJavacCompiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    return (Boolean)compile.invoke(javac_inst, new Object[]{this.argv});
                }
                catch (Throwable t) {
                    throw new RuntimeException(MessageFormat.format(msgs.getString("error_invoking"), t.getMessage()));
                }
            }
            return null;
        }
    }
}

