/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import oracle.jsp.provider.JspClassProvider;
import oracle.jsp.provider.JspResourceProvider;

public class JspClassLoader
extends JspClassProvider {
    static final String APPLICATION_CLASSES = "/WEB-INF/classes";
    static final String APPLICATION_JARS = "/WEB-INF/lib";
    private static int generationCounter = 0;
    private boolean needsInit = true;
    private int generation;
    private Hashtable cache;
    private Vector repository;
    private GetParentAction getparent = new GetParentAction();
    private static final String MSG_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.app.LocalStrings");
    private boolean verifyReflection = false;

    public static Vector classRepositoryFromString(String classRepository) {
        Vector<String> v = new Vector<String>();
        StringTokenizer toker = new StringTokenizer(classRepository, File.pathSeparator);
        while (toker.hasMoreTokens()) {
            v.addElement(toker.nextToken());
        }
        return v;
    }

    public JspClassLoader() {
        super(JspClassLoader.getCurrentThreadClassLoader());
    }

    public JspClassLoader(Vector classRepository) {
        super(JspClassLoader.getCurrentThreadClassLoader());
        this.init(classRepository);
    }

    public void init(Vector classRepository) throws IllegalArgumentException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        this.cache = new Hashtable();
        if (classRepository != null) {
            Enumeration e = classRepository.elements();
            while (e.hasMoreElements()) {
                this.verifyRepository(e.nextElement());
            }
        }
        this.repository = classRepository;
        this.generation = generationCounter++;
    }

    public synchronized void setVerifyReflection(boolean verifyReflection) {
        this.verifyReflection = verifyReflection;
    }

    public Vector getRepository() {
        return this.repository;
    }

    public synchronized void addClassPath(String classPath, boolean skipErrors) throws IllegalArgumentException {
        Vector<String> v = new Vector<String>();
        StringTokenizer toker = new StringTokenizer(classPath, File.pathSeparator);
        while (toker.hasMoreTokens()) {
            v.addElement(toker.nextToken());
        }
        if (v.isEmpty()) {
            throw new IllegalArgumentException(msgs.getString("no_clspath"));
        }
        if (this.repository == null) {
            this.repository = new Vector(v.size(), 5);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            try {
                this.repository.addElement(this.verifyPath(e.nextElement()));
            }
            catch (IllegalArgumentException ia) {
                if (skipErrors) continue;
                throw ia;
            }
        }
    }

    public synchronized void addClassPath(JspResourceProvider provider, String classPath, boolean skipErrors) throws IllegalArgumentException {
        throw new IllegalArgumentException(msgs.getString("pcp_not_impl"));
    }

    public synchronized void addApplicationPath(JspResourceProvider provider) {
        try {
            this.addClassPath(provider.getAbsolutePath(APPLICATION_CLASSES), true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String[] theJars = provider.listClassRepositories(APPLICATION_JARS);
        if (theJars == null) {
            return;
        }
        for (int i = 0; i < theJars.length; ++i) {
            try {
                this.addClassPath(provider.getAbsolutePath("/WEB-INF/lib/" + theJars[i]), true);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public synchronized void addProvider(JspResourceProvider provider) {
        throw new IllegalArgumentException(msgs.getString("racp_not_impl"));
    }

    public Vector makeRepository(Vector classPath, boolean skipErrors) throws IllegalArgumentException {
        Vector<File> classRepository = new Vector<File>(classPath.size(), 5);
        Enumeration e = classPath.elements();
        while (e.hasMoreElements()) {
            try {
                classRepository.addElement(this.verifyPath(e.nextElement()));
            }
            catch (IllegalArgumentException ia) {
                if (skipErrors) continue;
                throw ia;
            }
        }
        return classRepository;
    }

    private File verifyPath(Object o) throws IllegalArgumentException {
        String s;
        try {
            s = (String)o;
        }
        catch (ClassCastException objectIsNotString) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_string"), o));
        }
        return this.verifyRepository(new File(s));
    }

    private File verifyRepository(Object o) throws IllegalArgumentException {
        File file;
        try {
            file = (File)o;
        }
        catch (ClassCastException objectIsNotFile) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_file"), o));
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_rep"), file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("no_read"), file.getAbsolutePath()));
        }
        if (!file.isDirectory() && !this.isZipOrJarArchive(file)) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_jar"), file.getAbsolutePath()));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var6_4 = null;
        if (zipFile == null) return isArchive;
        try {
            zipFile.close();
            return isArchive;
        }
        catch (IOException ignored) {}
        return isArchive;
        {
            catch (ZipException zipCurrupted) {
                isArchive = false;
                Object var6_5 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
            catch (IOException anyIOError) {
                isArchive = false;
                Object var6_6 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean shouldReload(String classname) {
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(classname);
        if (entry == null) {
            return false;
        }
        if (entry.isSystemClass()) {
            return false;
        }
        boolean reload = entry.origin.lastModified() != entry.lastModified;
        return reload;
    }

    public synchronized boolean shouldReload() {
        Enumeration e = this.cache.elements();
        while (e.hasMoreElements()) {
            ClassCacheEntry entry = (ClassCacheEntry)e.nextElement();
            if (entry.isSystemClass()) continue;
            long msOrigin = entry.origin.lastModified();
            if (msOrigin == 0L) {
                return true;
            }
            if (msOrigin == entry.lastModified) continue;
            return true;
        }
        return false;
    }

    public JspClassProvider reinstantiate() {
        return (JspClassProvider)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new JspClassLoader(JspClassLoader.this.repository);
            }
        });
    }

    private void checkReflection(Class c) throws LinkageError {
        if (this.verifyReflection) {
            Method[] methodArray = c.getMethods();
        }
    }

    public synchronized Class loadClass(final String name, final boolean resolve) throws ClassNotFoundException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws ClassNotFoundException {
                return JspClassLoader.this.privilegedLoadClass(name, resolve);
            }
        };
        try {
            return (Class)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException ex) {
            Exception cause = ex.getException();
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            throw new RuntimeException("Internal error", ex);
        }
    }

    protected synchronized Class privilegedLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(this.getparent);
            if (cl != null) {
                c = cl.loadClass(name);
                this.checkReflection(c);
                return c;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (LinkageError le) {
            // empty catch block
        }
        try {
            c = Class.forName(name);
            this.checkReflection(c);
            return c;
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (LinkageError le) {
            // empty catch block
        }
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(name);
        if (entry != null) {
            c = entry.loadedClass;
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (!this.securityAllowsClass(name)) {
            c = this.loadSystemClass(name, resolve);
            this.checkReflection(c);
            return c;
        }
        try {
            c = this.loadSystemClass(name, resolve);
            this.checkReflection(c);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        catch (LinkageError le) {
            c = null;
        }
        if (this.repository == null) {
            throw new ClassNotFoundException();
        }
        Enumeration repEnum = this.repository.elements();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (repEnum.hasMoreElements()) {
            byte[] classData;
            File file = (File)repEnum.nextElement();
            File resFile = null;
            try {
                if (file.isDirectory()) {
                    classData = this.loadClassFromDirectory(file, name, classCache);
                    resFile = new File(file, name.replace('.', File.separatorChar) + ".class");
                } else {
                    classData = this.loadClassFromZipfile(file, name, classCache);
                    resFile = file;
                }
            }
            catch (IOException ioe) {
                classData = null;
            }
            if (classData == null) continue;
            CodeSource cs = null;
            try {
                cs = new CodeSource(this.makeURL(resFile), (Certificate[])null);
            }
            catch (MalformedURLException badurl) {
                throw new ClassNotFoundException(name);
            }
            classCache.loadedClass = c = this.defineClass(name, classData, 0, classData.length, cs);
            classCache.lastModified = classCache.origin.lastModified();
            this.cache.put(name, classCache);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    public static ClassLoader getCurrentThreadClassLoader() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl;
        }
        catch (Throwable th) {
            return null;
        }
    }

    private Class loadSystemClass(String name, boolean resolve) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> c = this.findSystemClass(name);
        ClassCacheEntry cacheEntry = new ClassCacheEntry();
        cacheEntry.origin = null;
        cacheEntry.loadedClass = c;
        cacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(name, cacheEntry);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private boolean securityAllowsClass(String className) {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security == null) {
                return true;
            }
            int lastDot = className.lastIndexOf(46);
            security.checkPackageDefinition(lastDot > -1 ? className.substring(0, lastDot) : "");
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File dir, String name, ClassCacheEntry cache) throws IOException {
        File classFile;
        String classFileName = name.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(classFileName.charAt(0))) {
            int start = 1;
            while (!Character.isJavaIdentifierStart(classFileName.charAt(start++))) {
            }
            classFileName = classFileName.substring(start);
        }
        if ((classFile = new File(dir, classFileName)).exists()) {
            cache.origin = classFile;
            FileInputStream in = new FileInputStream(classFile);
            try {
                byte[] byArray = this.loadBytesFromStream(in, (int)classFile.length());
                return byArray;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String name, ClassCacheEntry cache) throws IOException {
        String classFileName = name.replace('.', '/') + ".class";
        ZipFile zipfile = new ZipFile(file);
        try {
            ZipEntry entry = zipfile.getEntry(classFileName);
            if (entry != null) {
                cache.origin = file;
                byte[] byArray = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipfile.close();
        }
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream s;
        block2: {
            File file;
            InputStream is;
            ClassLoader cLoader = (ClassLoader)AccessController.doPrivileged(this.getparent);
            if (cLoader != null && (is = cLoader.getResourceAsStream(name)) != null) {
                return is;
            }
            s = JspClassLoader.getSystemResourceAsStream(name);
            if (s != null || this.repository == null) break block2;
            Enumeration repEnum = this.repository.elements();
            while (repEnum.hasMoreElements() && (s = (file = (File)repEnum.nextElement()).isDirectory() ? this.loadResourceFromDirectory(file, name) : this.loadResourceFromZipfile(file, name)) == null) {
            }
        }
        return s;
    }

    private InputStream loadResourceFromDirectory(File dir, String name) {
        String fileName = name.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return new FileInputStream(resFile);
            }
            catch (FileNotFoundException shouldnothappen) {
                return null;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String name) {
        try {
            ZipFile zipfile = new ZipFile(file);
            ZipEntry entry = zipfile.getEntry(name);
            if (entry != null) {
                return zipfile.getInputStream(entry);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL u;
        ClassLoader cLoader = (ClassLoader)AccessController.doPrivileged(this.getparent);
        if (cLoader != null && (u = cLoader.getResource(name)) != null) {
            return u;
        }
        u = JspClassLoader.getSystemResource(name);
        if (u != null || this.repository == null) {
            return u;
        }
        Enumeration repEnum = this.repository.elements();
        while (repEnum.hasMoreElements()) {
            String fileName;
            File resFile;
            File file = (File)repEnum.nextElement();
            if (!file.isDirectory() || !(resFile = new File(file, fileName = name.replace('/', File.separatorChar))).exists()) continue;
            try {
                return this.makeURL(resFile);
            }
            catch (MalformedURLException badurl) {
                return null;
            }
        }
        return null;
    }

    public URL makeURL(File resFile) throws MalformedURLException {
        if (File.separatorChar == '/') {
            return new URL("file://" + resFile.getAbsolutePath());
        }
        return new URL("file:/" + resFile.getAbsolutePath());
    }

    private class GetParentAction
    implements PrivilegedAction {
        private GetParentAction() {
        }

        public Object run() {
            return JspClassLoader.this.getParent();
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

