/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.boot;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.MainClass;
import oracle.classloader.util.XMLConfiguration;

public class XMLPlusClassPathBootConfiguration
extends XMLConfiguration {
    private static final boolean addClassPathToMain = ClassLoadEnvironment.setMainAsSystemLoader();
    private List classPath;
    private List oc4jClassPath;

    public XMLPlusClassPathBootConfiguration(String classPath, String oc4jClassPath, String[] commandLineArgs, InputStream stream, File homeDirectory, String origin, boolean replaceSystemLoader, Class[] transferClasses, String[] excludedTransferPackages) throws Exception {
        super(commandLineArgs, stream, homeDirectory, origin, replaceSystemLoader, transferClasses, excludedTransferPackages);
        this.classPath = this.parsePath(classPath);
        this.oc4jClassPath = this.parsePath(oc4jClassPath);
    }

    private List parsePath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path != null) {
            StringTokenizer stk = new StringTokenizer(path, File.pathSeparator);
            while (stk.hasMoreTokens()) {
                String pathElement = stk.nextToken();
                if (pathElement.length() <= 0 || !this.shouldAddToLoader(pathElement)) continue;
                list.add(pathElement);
            }
        }
        return list;
    }

    public MainClass configureLoaders() throws Exception {
        MainClass main = super.configureLoaders();
        if (!this.classPath.isEmpty()) {
            PolicyClassLoader loader = addClassPathToMain ? main.getLoader() : ClassLoaderQuery.getAPILoader();
            ConfigurationType type = addClassPathToMain ? ConfigurationType.MAIN_CLASS_PATH_ELEMENT : ConfigurationType.API_CLASS_PATH_ELEMENT;
            ConfigurationOrigin origin = new ConfigurationOrigin(type, "java.class.path");
            this.addClassPath(loader, origin, this.classPath);
        }
        if (!this.oc4jClassPath.isEmpty()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(ConfigurationType.MAIN_CLASS_PATH_ELEMENT, "oc4j.class.path");
            this.addClassPath(main.getLoader(), origin, this.oc4jClassPath);
        }
        return main;
    }

    private void addClassPath(PolicyClassLoader loader, ConfigurationOrigin origin, List classPath) throws Exception {
        Iterator iterator = classPath.iterator();
        while (iterator.hasNext()) {
            File codeSource = this.getFile((String)iterator.next());
            loader.addCodeSource(codeSource, origin);
        }
    }

    private File getFile(String path) throws Exception {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.getHomeDirectory(), path);
        }
        return file;
    }

    protected boolean shouldAddToLoader(String path) {
        if (path.equals("pcl.jar") || path.endsWith("/pcl.jar") || path.endsWith("\\pcl.jar")) {
            return false;
        }
        if (path.equals("oc4j.jar") || path.endsWith("/oc4j.jar") || path.endsWith("\\oc4j.jar")) {
            return false;
        }
        if (path.equals("oc4j-internal.jar") || path.endsWith("/oc4j-internal.jar") || path.endsWith("\\oc4j-internal.jar")) {
            return false;
        }
        if (path.equals("oc4j-api.jar") || path.endsWith("/oc4j-api.jar") || path.endsWith("\\oc4j-api.jar")) {
            return false;
        }
        return !path.equals("oc4j-unsupported-api.jar") && !path.endsWith("/oc4j-unsupported-api.jar") && !path.endsWith("\\oc4j-unsupported-api.jar");
    }
}

