/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.boot;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.FilteredAskParentSearchPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SearchPolicyToLogClassesLoadedByMainLoader;
import oracle.classloader.SearchSequence;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.PropertyUtils;
import oracle.classloader.util.URLParseUtil;
import oracle.classloader.util.VersionNumber;

public class OC4JClassLoadEnvironment
extends ClassLoadEnvironment {
    public static final String TRANSFER_QUERY_KEY = "oc4j.boot.query";
    public static final String START_QUERY_KEY = "oc4j.start.query";
    public static final String CLASS_PREPROCESSOR_KEY = "oracle.oc4j.class.preprocessor";
    public static final String SYSTEM_CLASS_PREPROCESSOR_KEY = "oracle.oc4j.system.class.preprocessor";
    public static final String ALLOW_CLASS_PREPROCESSOR_KEY = "oracle.allow.class.preprocessor";
    public static final String ORACLE_CONTAINERS_FOR_J2EE = "oracle.containers.for.j2ee";
    public static final String DEFAULT_EXTENSION_KEY = "oc4j.ext.dirs";
    public static final String FILE_EQUALITY_POLICY_KEY = "file.equality.policy";
    public static final String FILTER_INTERNAL_CODE_SOURCES_KEY = "filter.internal.code.sources";
    public static final String LOADER_LOG_DETECTING_CLASSES_FROM_MAIN_KEY = "enable.logging.main.loaded.classes";
    public static final String[] DEFAULT_QUERY_PACKAGES = new String[]{ClassLoadEnvironment.DEFAULT_QUERY_PACKAGES[0], "oracle.oc4j.query"};
    private static final String KNOWN_OC4J_QUERY_CLASS_NAME = "oracle.oc4j.query.Threads";
    private static final String APPLICATION_SERVER_CLASS_NAME = "com.evermind.server.ApplicationServer";
    private static final boolean FILTER_MAIN_CLASSES = "true".equals(System.getProperty("filter.main.classes"));
    private static boolean FILTER_INTERNAL_CODE_SOURCES = PropertyUtils.getBooleanProperty((String)"filter.internal.code.sources", (boolean)true);
    private static final String[] PROTECTED_INTERNAL_CLASS_NAMES = new String[]{"oracle.oc4j.security.OC4JSecurity", "oracle.oc4j.security.DelegatingSecurityManager", "oracle.classloader.PolicyClassLoader", "com.evermind.server.ejb.EJBPrivileged", "oracle.j2ee.connector.proxy.BCELProxyClassLoader"};
    private static final String[] FILTER_APP_CODE_SOURCE_FILE_NAMES = new String[]{"oc4j-internal.jar", "oc4jclient.jar"};
    private String ORACLE_HOME;
    private String J2EE_HOME;
    private int ORACLE_HOME_LENGTH;
    private int J2EE_HOME_LENGTH;
    private SearchPolicy internalClassesFilter;
    private boolean checkedSetMain;
    private boolean setMainAsSystem;
    private boolean checkedFileEquality;
    private int fileEqualityOverride;

    protected void init() {
        super.init();
        System.setProperty(ORACLE_CONTAINERS_FOR_J2EE, "true");
        if (System.getProperty("code.source.policy") == null) {
            System.setProperty("code.source.policy", "linear");
        }
    }

    protected boolean doActivateApplicationLogManager() {
        return PropertyUtils.getBooleanProperty((String)"use.application.log.manager", (boolean)true);
    }

    protected boolean doActivateLoggingForClassesLoadedByMainLoader() {
        return PropertyUtils.getBooleanProperty((String)LOADER_LOG_DETECTING_CLASSES_FROM_MAIN_KEY, (boolean)false);
    }

    protected boolean doEncodeResourceURLs() {
        return PropertyUtils.getBooleanProperty((String)"encode.loader.urls", (boolean)false);
    }

    protected String doGetTransferQueryKey() {
        return TRANSFER_QUERY_KEY;
    }

    protected String doGetStartQueryKey() {
        return START_QUERY_KEY;
    }

    protected String doGetDisplayPath(String path) {
        if (this.ORACLE_HOME == null) {
            this.ORACLE_HOME = OC4JClassLoadEnvironment.convertHomePath(OC4JClassLoadEnvironment.getProperty((String)"oracle.home"));
            this.ORACLE_HOME_LENGTH = this.ORACLE_HOME.length();
            this.J2EE_HOME = OC4JClassLoadEnvironment.convertHomePath(ClassLoaderQuery.getHomeDirectory().getAbsolutePath());
            this.J2EE_HOME_LENGTH = this.J2EE_HOME.length();
        }
        if (path.startsWith(this.ORACLE_HOME)) {
            return "${oracle.home}" + path.substring(this.ORACLE_HOME_LENGTH);
        }
        if (path.startsWith(this.J2EE_HOME)) {
            return "${j2ee.home}" + path.substring(this.J2EE_HOME_LENGTH);
        }
        return path;
    }

    private static String convertHomePath(String path) {
        if (!(path = path.replace('\\', '/')).startsWith("/")) {
            path = "/" + path;
        }
        return URLParseUtil.encodePath((String)path);
    }

    protected boolean doSetMainAsSystemLoader() {
        if (!this.checkedSetMain) {
            this.setMainAsSystem = PropertyUtils.getBooleanProperty((String)"set.main.as.system.loader", (boolean)true);
            this.checkedSetMain = true;
        }
        return this.setMainAsSystem;
    }

    protected String doGetMainLoaderName() {
        return "oc4j";
    }

    protected VersionNumber doGetAPIVersionNumber() {
        return new VersionNumber(1, 4, 0);
    }

    protected VersionNumber doGetMainVersionNumber() {
        return new VersionNumber(10, 1, 3);
    }

    protected String doGetCustomManifestClassPathAtttribute() {
        return "OC4J-Class-Path";
    }

    protected String doGetClassPreprocessorKey() {
        return CLASS_PREPROCESSOR_KEY;
    }

    protected String doGetSystemClassPreprocessorKey() {
        return SYSTEM_CLASS_PREPROCESSOR_KEY;
    }

    protected boolean doAllowClassPreprocessing() {
        return PropertyUtils.getBooleanProperty((String)ALLOW_CLASS_PREPROCESSOR_KEY, (boolean)true);
    }

    protected String doGetDefaultExtensionKey() {
        return DEFAULT_EXTENSION_KEY;
    }

    protected boolean doAutoInstallURLHandlerFactory() {
        return false;
    }

    protected SearchPolicy doFilterSearchPolicy(SearchPolicy policy, PolicyClassLoader loader) {
        SearchPolicy returnPolicy = null;
        if (FILTER_MAIN_CLASSES) {
            returnPolicy = this.getSearchPolicyWithFilteringTurnedOn(policy, loader);
        }
        if (returnPolicy == null) {
            returnPolicy = policy;
        }
        if (this.doActivateLoggingForClassesLoadedByMainLoader() && loader.isApplicationLoader() && !loader.isSharedLoader()) {
            SearchPolicy[] policies = null;
            if (returnPolicy != null) {
                policies = returnPolicy instanceof SearchSequence ? ((SearchSequence)returnPolicy).getPolicies() : new SearchPolicy[]{returnPolicy};
            }
            returnPolicy = new SearchPolicyToLogClassesLoadedByMainLoader("SearchPolicyToDetectClassesLoadedByMainLoaderForApplicationLoader", policies);
        }
        return returnPolicy;
    }

    protected SearchPolicy getSearchPolicyWithFilteringTurnedOn(SearchPolicy policy, PolicyClassLoader loader) {
        PolicyClassLoader parent;
        if (System.getSecurityManager() != null && (parent = loader.parent()) != null && parent == ClassLoaderQuery.getMainLoader()) {
            try {
                int i;
                if (this.internalClassesFilter == null) {
                    int count = PROTECTED_INTERNAL_CLASS_NAMES.length;
                    Class[] classes = new Class[count];
                    for (i = 0; i < count; ++i) {
                        classes[i] = parent.loadClass(PROTECTED_INTERNAL_CLASS_NAMES[i]);
                    }
                    this.internalClassesFilter = new FilteredAskParentSearchPolicy(classes);
                }
                boolean replaced = false;
                SearchPolicy[] steps = ((SearchSequence)policy).getPolicies();
                for (i = 0; i < steps.length; ++i) {
                    if (steps[i] != SearchPolicy.ASK_PARENT) continue;
                    steps[i] = this.internalClassesFilter;
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    throw new IllegalStateException("Could not insert filter policy.");
                }
                policy = new SearchSequence("SecureStandard", steps);
            }
            catch (ClassNotFoundException e) {
                IllegalStateException failure = new IllegalStateException("Could not construct filter policy.");
                failure.initCause(e);
                throw failure;
            }
        }
        return policy;
    }

    protected String doGetApplicationName(PolicyClassLoader loader) {
        String result = loader.getName();
        while (loader != null && loader.getScope() != ClassLoaderScope.APPLICATION) {
            loader = loader.parent();
        }
        if (loader != null && (result = loader.getName()).endsWith(".root")) {
            result = result.substring(0, result.length() - 5);
        }
        return result;
    }

    protected String doGetDefaultSharedCodeSourceOrigin() {
        return "server.xml";
    }

    protected String doGetDefaultInitialLoadersConfigurationOrigin() {
        return "META-INF/boot.xml";
    }

    protected String doGetDefaultInheritedSharedLibrariesOrigin() {
        return "orion-application.xml";
    }

    protected boolean doAllowCodeSource(SharedCodeSource cs, PolicyClassLoader pcl) {
        if (FILTER_INTERNAL_CODE_SOURCES && cs != null && pcl.isApplicationLoader() && !pcl.isSharedLoader()) {
            for (int i = 0; i < FILTER_APP_CODE_SOURCE_FILE_NAMES.length; ++i) {
                String fileName = FILTER_APP_CODE_SOURCE_FILE_NAMES[i];
                if (!cs.getLocation().getPath().endsWith(fileName)) continue;
                ClassLoadLogger.log((Level)Level.WARNING, (String)("Application loader " + pcl.getDisplayName() + " may not use " + cs));
                return false;
            }
        }
        return true;
    }

    protected String[] doGetDefaultQueryPackageNames() {
        return DEFAULT_QUERY_PACKAGES;
    }

    protected void doAddQueryCodeSources(List codeSources) {
        super.doAddQueryCodeSources(codeSources);
        try {
            PolicyClassLoader main = ClassLoaderQuery.getMainLoader();
            Class clz = main.loadClass(KNOWN_OC4J_QUERY_CLASS_NAME);
            SharedCodeSource cs = ClassLoaderQuery.getCodeSourceFor((Class)clz);
            codeSources.add(cs);
        }
        catch (Exception e) {
            ClassLoadLogger.log((Level)Level.INFO, (String)("Could find OC4J query code-source: " + e));
        }
    }

    protected boolean doActivateLoaderLeakDetection() {
        return PropertyUtils.getBooleanProperty((String)"detect.loader.leaks", (boolean)true);
    }

    protected void doExit(boolean force) {
        if (force) {
            System.exit(1);
        }
        try {
            PolicyClassLoader main = ClassLoaderQuery.getMainLoader();
            Class clz = main.loadClass(APPLICATION_SERVER_CLASS_NAME);
            Method instanceMethod = clz.getDeclaredMethod("getInstance", new Class[0]);
            Method stopMethod = clz.getDeclaredMethod("stop", new Class[0]);
            Object instance = instanceMethod.invoke(null, new Object[0]);
            stopMethod.invoke(instance, new Object[0]);
        }
        catch (Throwable e) {
            System.exit(1);
        }
    }

    protected int doGetFileEqualityPolicyFor(File canonicalFile, SharedCodeSource existing, PolicyClassLoader subscriber, int defaultPolicy) {
        if (canonicalFile != null && canonicalFile.getPath().endsWith("deployment-cache.jar")) {
            return 5;
        }
        if (!this.checkedFileEquality) {
            int overrideValue = -1;
            String value = OC4JClassLoadEnvironment.getProperty((String)FILE_EQUALITY_POLICY_KEY);
            if (value != null) {
                if (value.equalsIgnoreCase("never")) {
                    overrideValue = 5;
                } else if (value.equalsIgnoreCase("bitwise")) {
                    overrideValue = 4;
                }
            }
            this.fileEqualityOverride = overrideValue;
            this.checkedFileEquality = true;
        }
        if (this.fileEqualityOverride > defaultPolicy) {
            return this.fileEqualityOverride;
        }
        return defaultPolicy;
    }
}

