/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.classloader.SharedCodeSource;
import oracle.oc4j.loader.boot.XMLPlusClassPathBootConfiguration;
import org.xml.sax.SAXException;

public class DevTestBootConfiguration
extends XMLPlusClassPathBootConfiguration {
    private String apiClasses;
    private String unsupportedApiClasses;
    private String serverClasses;
    private String commonClasses;
    private String concurrentClasses;
    private String commonJdk5Classes;
    private String generatedClasses;

    public DevTestBootConfiguration(String classPath, String oc4jClassPath, String[] commandLineArgs, InputStream stream, File homeDirectory, String origin, boolean replaceSystemLoader, Class[] transferClasses, String[] excludedTransferPackages) throws Exception {
        super(classPath, oc4jClassPath, commandLineArgs, stream, homeDirectory, origin, replaceSystemLoader, transferClasses, excludedTransferPackages);
        if (this.apiClasses == null) {
            throw new RuntimeException("api classes directory not defined.");
        }
        if (this.unsupportedApiClasses == null) {
            throw new RuntimeException("unsupported-api classes directory not defined.");
        }
        if (this.serverClasses == null) {
            throw new RuntimeException("server classes directory not defined.");
        }
        if (this.commonClasses == null) {
            throw new RuntimeException("common classes directory not defined.");
        }
        if (this.commonJdk5Classes == null) {
            throw new RuntimeException("common jdk5 classes directory not defined.");
        }
        if (this.generatedClasses == null) {
            throw new RuntimeException("generated classes directory not defined.");
        }
        if (System.getProperty("j2ee.home.dir") == null) {
            throw new RuntimeException("The j2ee.home.dir system property must be set in this boot configuration.");
        }
    }

    protected boolean shouldAddToLoader(String path) {
        if (path.endsWith("/boot") || path.endsWith("\\boot")) {
            return false;
        }
        if (path.endsWith("/classloader") || path.endsWith("\\classloader")) {
            return false;
        }
        if (path.endsWith("/api") || path.endsWith("\\api")) {
            this.apiClasses = path;
            return false;
        }
        if (path.endsWith("/unsupported-api") || path.endsWith("\\unsupported-api")) {
            this.unsupportedApiClasses = path;
            return false;
        }
        if (path.endsWith("/server") || path.endsWith("\\server")) {
            this.serverClasses = path;
            return false;
        }
        if (path.endsWith("/jdk5/common") || path.endsWith("\\jdk5\\common")) {
            this.commonJdk5Classes = path;
            return false;
        }
        if (path.endsWith("/common") || path.endsWith("\\common")) {
            this.commonClasses = path;
            return false;
        }
        if (path.endsWith("/concurrent") || path.endsWith("\\concurrent")) {
            this.concurrentClasses = path;
            return false;
        }
        if (path.endsWith("/generated") || path.endsWith("\\generated")) {
            this.generatedClasses = path;
            return false;
        }
        return true;
    }

    protected SharedCodeSource addCodeSource(int elementType, String path, boolean includeManifest, boolean hasExternals) throws IOException, SAXException {
        SharedCodeSource result = null;
        if (path.endsWith("oc4j-api.jar")) {
            result = super.addCodeSource(elementType, this.apiClasses, includeManifest, hasExternals);
        } else if (path.endsWith("oc4j-unsupported-api.jar")) {
            result = super.addCodeSource(elementType, this.unsupportedApiClasses, includeManifest, hasExternals);
        } else if (path.endsWith("oc4j-internal.jar")) {
            this.registerExternalsFromPackageNames(super.addCodeSource(elementType, this.serverClasses, includeManifest, hasExternals));
            this.registerExternalsFromPackageNames(super.addCodeSource(elementType, this.commonClasses, includeManifest, hasExternals));
            this.registerExternalsFromPackageNames(super.addCodeSource(elementType, this.concurrentClasses, includeManifest, hasExternals));
            this.registerExternalsFromPackageNames(super.addCodeSource(elementType, this.commonJdk5Classes, includeManifest, hasExternals));
            this.registerExternalsFromPackageNames(super.addCodeSource(elementType, this.generatedClasses, includeManifest, hasExternals));
        } else {
            result = super.addCodeSource(elementType, path, includeManifest, hasExternals);
        }
        return result;
    }
}

