/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.InitialLoadersConfiguration;
import oracle.classloader.util.PropertyUtils;
import oracle.classloader.util.XMLConfiguration;
import oracle.oc4j.loader.boot.BootStrap;
import oracle.oc4j.loader.boot.DevTestBootConfiguration;
import oracle.oc4j.loader.boot.XMLPlusClassPathBootConfiguration;
import oracle.oc4j.util.ClassPreprocessor;

public class BootConfigurationFactory {
    private static final String BOOT_XML_FILE_KEY = "boot.xml.file";
    private static final String RELATIVE_CONFIG_PATH = "config";
    private static final String DEFAULT_CONFIG_FILE_NAME = "boot.xml";
    private static final String META_INF_LOC = "META-INF/boot.xml";
    private static final Class[] TRANSFER_CLASSES = new Class[]{ClassPreprocessor.class};
    private static final String[] EXCLUDED_TRANSFER_PACKAGES = new String[]{BootStrap.class.getPackage().getName()};
    private String[] args;
    private File homeDirectory;
    private File configDirectory;
    private File configFile;
    private String origin;
    private InputStream stream;
    private File ourCodeSourceFile;
    private boolean replaceSystemLoader;

    static InitialLoadersConfiguration create(String[] commandLineArgs) throws Exception {
        boolean replaceSystemLoader = PropertyUtils.getBooleanProperty((String)"replace.system.loader", (boolean)true);
        BootConfigurationFactory factory = new BootConfigurationFactory(commandLineArgs, replaceSystemLoader);
        return factory.getConfiguration();
    }

    BootConfigurationFactory(String[] commandLineArgs, boolean replaceSystemLoader) throws Exception {
        this.args = commandLineArgs;
        this.ourCodeSourceFile = ClassLoaderQuery.getCodeSourceFileFor((Class)BootConfigurationFactory.class);
        this.replaceSystemLoader = replaceSystemLoader;
        this.initHomeDirectory();
        this.initConfigDirectory();
        this.initConfigFile();
    }

    InitialLoadersConfiguration getConfiguration() throws Exception {
        XMLConfiguration result = null;
        String classPath = ClassLoadEnvironment.getProperty((String)"java.class.path");
        boolean containsOC4JJar = this.classPathContains(classPath, "oc4j.jar");
        boolean extraClassPath = classPath.indexOf(File.pathSeparatorChar) >= 0;
        String oc4jClassPath = ClassLoadEnvironment.getProperty((String)"oc4j.class.path");
        if (!extraClassPath && oc4jClassPath != null) {
            extraClassPath = true;
        }
        result = containsOC4JJar ? (extraClassPath ? new XMLPlusClassPathBootConfiguration(classPath, oc4jClassPath, this.args, this.stream, this.homeDirectory, this.origin, this.replaceSystemLoader, TRANSFER_CLASSES, EXCLUDED_TRANSFER_PACKAGES) : new XMLConfiguration(this.args, this.stream, this.homeDirectory, this.origin, this.replaceSystemLoader, TRANSFER_CLASSES, EXCLUDED_TRANSFER_PACKAGES)) : new DevTestBootConfiguration(classPath, oc4jClassPath, this.args, this.stream, this.homeDirectory, this.origin, this.replaceSystemLoader, TRANSFER_CLASSES, EXCLUDED_TRANSFER_PACKAGES);
        return result;
    }

    private boolean classPathContains(String classPath, String entry) {
        int classPathLen = classPath.length();
        int entryLen = entry.length();
        int index = classPath.indexOf(entry);
        while (index >= 0) {
            int followingIndex;
            if ((index == 0 || BootConfigurationFactory.isLeadingSeparator(classPath.charAt(index - 1))) && ((followingIndex = index + entryLen) >= classPathLen || BootConfigurationFactory.isTrailingSeparator(classPath.charAt(followingIndex)))) {
                return true;
            }
            index = classPath.indexOf(entry, index + entryLen);
        }
        return false;
    }

    private static boolean isLeadingSeparator(char c) {
        return c == ':' || c == ';' || c == '/' || c == '\\' || Character.isSpaceChar(c);
    }

    private static boolean isTrailingSeparator(char c) {
        return c == ':' || c == ';' || Character.isSpaceChar(c);
    }

    private void initConfigFile() throws Exception {
        String propValue = System.getProperty(BOOT_XML_FILE_KEY);
        this.configFile = propValue != null ? new File(propValue) : new File(this.configDirectory, DEFAULT_CONFIG_FILE_NAME);
        if (this.configFile.exists() && this.configFile.isFile()) {
            this.origin = this.configFile.getAbsolutePath();
            this.stream = new FileInputStream(this.configFile);
            this.configDirectory = this.configFile.getParentFile();
        } else {
            this.origin = "META-INF/boot.xml in " + this.ourCodeSourceFile;
            this.stream = XMLConfiguration.class.getClassLoader().getResourceAsStream(META_INF_LOC);
        }
    }

    private void initHomeDirectory() {
        File ourRoot = null;
        String homeDirProp = System.getProperty("j2ee.home.dir");
        ourRoot = homeDirProp != null ? new File(homeDirProp) : this.ourCodeSourceFile.getParentFile();
        try {
            this.homeDirectory = ourRoot.getCanonicalFile();
        }
        catch (IOException e) {
            this.homeDirectory = ourRoot.getAbsoluteFile();
        }
        System.setProperty("j2ee.home", this.homeDirectory.toString());
    }

    private void initConfigDirectory() throws IOException {
        if (this.configDirectory == null) {
            String path = null;
            for (int i = 0; i < this.args.length; ++i) {
                if (!this.args[i].equals("-config")) continue;
                if (i + 1 >= this.args.length) {
                    throw new Error("Must specify file with -config option.");
                }
                path = this.args[i + 1];
                break;
            }
            if (path == null) {
                this.configDirectory = new File(this.homeDirectory, RELATIVE_CONFIG_PATH);
            } else {
                File serverXML = new File(path);
                if (!serverXML.exists()) {
                    throw new IOException("File " + serverXML.getAbsolutePath() + " does not exist.");
                }
                this.configDirectory = serverXML.getCanonicalFile().getParentFile();
            }
            ClassLoadEnvironment.setConfigurationDirectory((File)this.configDirectory);
        }
    }
}

