/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import com.threedgraphics.math.CurveFitIF;
import com.threedgraphics.math.SVD;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import tdg.Assert;
import tdg.AssertionException;
import tdg.Axis2DObj;
import tdg.AxisDescriptor;
import tdg.AxisSplits;
import tdg.AxisTemplate;
import tdg.CategoryIF;
import tdg.DataFormat;
import tdg.DataItem;
import tdg.DataTextPosition;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D;
import tdg.Line;
import tdg.MarkerObj;
import tdg.MarkerTemplate;
import tdg.MarkerTemplateArray;
import tdg.MinMaxObj;
import tdg.Perspective;
import tdg.Point2d;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.TDGNumberFormat;
import tdg.ZoomState;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetLine;
import tdg.draw.DetPolygon;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;
import tdg.draw.Polyline;
import tdg.draw.SimpleBlackBoxObj;
import tdg.draw.TextStyleObj;

public abstract class JChart_2D_Standard
extends JChart_2D {
    static final CategoryIF LOG = Perspective.getInstance("ENGINE.JChart.2D_Standard");
    public static final int NO_PREVIOUS_SERIES = -2;
    static final int TWOD_MARKER_FIXUP = 3;
    RelativeAxisObj m_O1Axis;
    RelativeAxisObj m_X1Axis;
    RelativeAxisObj m_Y1Axis;
    RelativeAxisObj m_Y2Axis;
    RelativeAxisObj m_Z1Axis;
    RelativeAxisObj m_Y3Axis;
    RelativeAxisObj m_Y4Axis;
    RelativeAxisObj m_Y5Axis;
    int m_scaling;
    int[][] m_ordCoords;
    int m_barThickCoord;
    int[][] m_numXCoords;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    String[][] m_DataLabel;
    boolean m_bDataTextDisplay;
    boolean m_bHorz;
    boolean m_bExtendToFrameEdge;
    boolean m_bIsThisAComboWithBar;
    boolean m_bSquareMarkers;
    boolean m_bMarkerDisplay;
    boolean m_bAllMarkersSameSize;
    int m_nMarkerSizeDefault;
    double[][] m_fStackedCumulativeValues;
    double[][] m_fPercentCumulativeValues;
    SeriesEnumerator m_sEnumReverseForPrev;
    int[][] m_nParetoYCoordsVC;
    int[][] m_nParetoCoordsVC;
    int[] m_nMaxParetoYCoords;
    int[] m_nPercentParetoValues;
    double[] m_fMaxParetoActuals;
    double[] m_fMinParetoActuals;
    double[][] m_fParetoYCoords;
    ArrayList m_bubbleMarkerInfo;
    private static Comparator m_bubbleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int ySize2;
            int xSize2;
            int area2;
            int ySize1;
            Object[] obj1 = (Object[])o1;
            Object[] obj2 = (Object[])o2;
            int xSize1 = (Integer)obj1[4];
            int area1 = xSize1 * (ySize1 = ((Integer)obj1[5]).intValue());
            if (area1 > (area2 = (xSize2 = ((Integer)obj2[4]).intValue()) * (ySize2 = ((Integer)obj2[5]).intValue()))) {
                return -1;
            }
            if (area1 == area2) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            return false;
        }
    };

    public void calc() {
        super.calc();
        this.m_positiveValY1 = false;
        this.m_negativeValY1 = false;
        this.m_zeroValY1 = false;
        this.m_nullValY1 = false;
        this.m_positiveValY2 = false;
        this.m_negativeValY2 = false;
        this.m_zeroValY2 = false;
        this.m_nullValY2 = false;
        this.m_positiveValX1 = false;
        this.m_negativeValX1 = false;
        this.m_zeroValX1 = false;
        this.m_nullValX1 = false;
        this.m_dualY = false;
        this.m_XY = false;
        this.m_dualYX = false;
        this.createAxes();
        int nBorderWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getFrame());
        if (this.m_Frame != null && this.m_Perspective.getFrameDisplay()) {
            this.m_Frame.drawFrameBorders(nBorderWidth);
        }
        this.drawAxisBody();
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        } else if (this.m_gt.isScalingWaterfall()) {
            this.calcDataWaterfall();
        }
        if (this.m_Perspective.getGraphType() != 102) {
            this.fireInapropriateDataEvent();
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        int axisOffset = 0;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int sRel = 0;
        while (sRel < this.m_nSeries) {
            int s = sEnum.seriesAt(sRel);
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            int axis = this.getAxisAssignment(s);
            axisOffset = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && axis == 1) {
                axisOffset = 1;
            }
            int gRel = 0;
            while (gRel < this.m_nGroups) {
                int g = gEnum.groupAt(gRel);
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                this.m_ordCoords[s][g] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(sRel, gRel) : (this.m_nTotalSeries > 1 ? (int)this.m_O1Axis.getLowCoord(axisOffset, gRel) : (int)this.m_O1Axis.getLowCoord(sRel, gRel));
                ++gRel;
            }
            ++sRel;
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        RelativeAxisObj axisObj = null;
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        boolean bScatter = this.m_gt.isScatter();
        boolean bBubble = this.m_gt.isBubble();
        boolean bScatterLabels = this.m_gt.isScatterWithLabel();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        String sDataTextTemplate = "";
        String[] dataItemStringArray = new String[nItems];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseXAxis) {
            this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bScatterLabels || this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
            sDataTextTemplate = bBubble ? this.m_Perspective.getDataTextTemplateBubble() : this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                DatumObj dObj;
                DataItem item;
                int i;
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                boolean bDataLabelDecided = false;
                if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
                    i = 0;
                    while (i < nItems) {
                        item = df.getDataItem(i);
                        dObj = this.getDataValue(s, g, item);
                        fValue = dObj.m_fValue;
                        if (bNumberFormatCallBackActive) {
                            int nAxisID = this.axisAssignedToSeries(s, item);
                            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                            dataItemStringArray[i] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                        } else {
                            dataItemStringArray[i] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                        }
                        ++i;
                    }
                    this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                    bDataLabelDecided = true;
                }
                i = 0;
                while (i < nItems) {
                    block29: {
                        item = df.getDataItem(i);
                        try {
                            if (item.isLabel()) {
                                if (this.m_Access.isCellNumeric(s, g, item)) {
                                    fValue = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
                                    if (bNumberFormatCallBackActive) {
                                        int nAxisID = this.axisAssignedToSeries(s, item);
                                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                                    } else {
                                        this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                                    }
                                } else {
                                    this.m_DataLabel[s][g] = this.m_Access.getDataAsString(s, g, item);
                                }
                            } else {
                                axisObj = this.whichAxisForSeries(s, item);
                                if (axisObj != null) {
                                    dObj = this.getDataValue(s, g, item);
                                    fValue = dObj.m_fValue;
                                    if (!dObj.m_bOK) {
                                        this.m_dataOK[s][g] = dObj.m_bOK;
                                    }
                                    if (fValue <= 0.0 && this.isBadValueInLogscale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                    if (this.isIgnoredOffScale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                }
                            }
                        }
                        catch (AssertionException e) {
                            if (!item.isRequired()) break block29;
                            this.m_dataOK[s][g] = false;
                            fValue = 0.0;
                        }
                    }
                    if (!item.isLabel() && axisObj != null) {
                        if (item.getAssocAxis() == 0) {
                            this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                        } else if (item.getAssocAxis() == 7) {
                            this.m_numXCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                        }
                        if (this.m_bDataTextDisplay && !bDataLabelDecided) {
                            if (bNumberFormatCallBackActive) {
                                int nAxisID = this.axisAssignedToSeries(s, item);
                                this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                            } else {
                                this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void calcDataPercent() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nDataFormat = 2;
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            double fValue;
            int s;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            double fPosTotal = 0.0;
            double fNegTotal = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue >= 0.0) {
                    fPosTotal += fValue;
                    continue;
                }
                fNegTotal += fValue;
            }
            fNegTotal = -fNegTotal;
            double fTotTotal = fPosTotal + fNegTotal;
            double fPosRatio = fPosTotal / fTotTotal;
            double fNegRatio = fNegTotal / fTotTotal;
            double fPosSum = 0.0;
            double fNegSum = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (fValue >= 0.0 && fPosTotal > 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fPosRatio * (fPosSum += fValue) / fPosTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fPosRatio * fPosSum / fPosTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fPosRatio * fValue / fPosTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fPosRatio * fValue / fPosTotal, "");
                    continue;
                }
                if (fValue < 0.0 && fNegTotal < 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fNegRatio * (fNegSum += fValue) / fNegTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNegRatio * fNegSum / fNegTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNegRatio * fValue / fNegTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNegRatio * fValue / fNegTotal, "");
                    continue;
                }
                this.m_dataOK[s][g] = false;
            }
        }
    }

    protected void calcParetoData() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double fAccum = 0.0;
        double fValue = 0.0;
        int nTotalZeroCount = 0;
        this.m_nParetoYCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nParetoCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nMaxParetoYCoords = new int[this.m_nTotalSeries];
        this.m_fParetoYCoords = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            this.m_nMaxParetoYCoords[s] = 0;
            fAccum = 0.0;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                fAccum += Math.abs(fValue);
                if (fValue <= 0.0) {
                    ++nTotalZeroCount;
                }
                this.m_nParetoYCoordsVC[s][g] = (int)axisObj.getValueCoord(fAccum);
                this.m_fParetoYCoords[s][g] = fAccum;
                this.m_nParetoCoordsVC[s][g] = (int)this.m_O1Axis.getLowCoord(s, g);
                int n = s;
                this.m_nMaxParetoYCoords[n] = this.m_nMaxParetoYCoords[n] + this.m_nParetoYCoordsVC[s][g];
            }
        }
    }

    public double getParetoValue(int nSeries, int nGroup) {
        return this.m_fParetoYCoords[nSeries][nGroup];
    }

    public double getPercentCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fPercentCumulativeValues != null) {
            fValue = this.m_fPercentCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcDataStacked() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g);
                double fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                int nRiser = this.m_seriesTypes[s];
                this.m_fStackedCumulativeValues[s][g] = sumObj.getSum(bPos, bY2, nRiser);
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    protected void calcDataWaterfall() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int gFirst = gEnum.getFirstGroup();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                double fEndOfPreviousStack;
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g);
                double fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (this.m_gt.isWaterfall() && !sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                    fValue = -fValue;
                }
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                double fNewSum = this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                if (this.m_gt.isWaterfall() && g != gFirst) {
                    int gPrev = gEnum.peekAtGroupBefore(g);
                    Assert.assert(gPrev != -1);
                    int sLast = sEnum.getLastSeries();
                    fEndOfPreviousStack = this.m_fStackedCumulativeValues[sLast][gPrev];
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNewSum += fEndOfPreviousStack);
                } else {
                    fEndOfPreviousStack = 0.0;
                }
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                int nRiser = this.m_seriesTypes[s];
                this.m_fStackedCumulativeValues[s][g] = sumObj.getSum(bPos, bY2, nRiser) + fEndOfPreviousStack;
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    protected SumObj getGroupTotals(int g) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        SumObj totalObj = new SumObj();
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
            if (yAxisObj == null) continue;
            DatumObj dObj = this.getDataValue(s, g);
            double fValue = dObj.m_fValue;
            this.m_dataOK[s][g] = dObj.m_bOK;
            if (this.m_gt.isWaterfall() && !totalObj.m_bFirstTime && totalObj.m_bFirstSetIsPositive == fValue < 0.0) {
                fValue = -fValue;
            }
            if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                fValue = 0.0;
                this.m_dataOK[s][g] = false;
            }
            this.processOneStackedValue(s, g, yAxisObj, fValue, totalObj);
        }
        return totalObj;
    }

    private void calcDataLabel(boolean bPos, boolean bY2, int s, int g, int nRiser, double fValue, SumObj sumObj, SumObj totalObj) {
        String szDataFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        double fNewSum = sumObj.getSum(bPos, bY2, nRiser);
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (TDGNumberFormat.isPercentFormat(nDataFormat)) {
                double fTotal = totalObj.getSum(bPos, bY2, nRiser);
                fNewSum /= fTotal;
            }
            if (this.m_gt.isWaterfall()) {
                fNewSum = this.m_fStackedCumulativeValues[s][g];
            }
        } else {
            fNewSum = fValue;
        }
        if (bNumberFormatCallBackActive) {
            int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
            this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNewSum);
        } else {
            this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNewSum, szDataFormatPattern);
        }
    }

    public double getStackedCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fStackedCumulativeValues != null) {
            fValue = this.m_fStackedCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcOrdinalCoords() {
        Assert.assert(this.m_O1Axis != null);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int gRel = 0;
        while (gRel < this.m_nGroups) {
            int g = gEnum.groupAt(gRel);
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                this.m_ordCoords[s][g] = nOrdCoord;
            }
            ++gRel;
        }
    }

    protected int calcRisersPerPixel() {
        if (this.m_gt.getIntegerGraphType() != 17) {
            if (this.m_gt.getIntegerGraphType() != 24) {
                return 1;
            }
        }
        if (this.isComboWithNonBar() || this.m_Frame == null) {
            return 1;
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        int nPixels = this.m_bHorz ? this.m_Perspective.m_VC.virtToDestHeight(rFrame.height) : this.m_Perspective.m_VC.virtToDestWidth(rFrame.width);
        int nRisersPerPixel = this.m_nSeries * this.m_nGroups / nPixels;
        if (nRisersPerPixel < 1) {
            nRisersPerPixel = 1;
        }
        return nRisersPerPixel;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_sEnumReverseForPrev = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_bExtendToFrameEdge = this.m_gt.isParetoType() ? false : this.m_Perspective.getExtendToFrameEdge();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bSquareMarkers = this.m_Perspective.getSquareMarkers();
        this.m_bMarkerDisplay = this.m_Perspective.getMarkerDisplay();
        this.m_nMarkerSizeDefault = this.m_Perspective.getMarkerSizeDefault();
    }

    protected void createAxes() {
        boolean bVerticalChart;
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] offsetArray = axisSplits.getAxisOffsets();
        int[] sizeArray = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_scaling = this.m_gt.getScalingMethod();
        int ordType = this.whichOrdType();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bl = bVerticalChart = this.m_gt.getOrientation() == 2;
        if (axisDescriptor.hasZ1()) {
            this.createZ1Axis(!bVerticalChart, true);
            this.calcAxis(this.m_Z1Axis);
        }
        if (axisDescriptor.hasO1()) {
            this.createOrdinalAxis(ordType, !bVerticalChart, bVerticalChart);
            this.calcAxis(this.m_O1Axis);
        } else if (axisDescriptor.hasX1()) {
            this.createX1Axis(!bVerticalChart, !this.m_Perspective.getX1AxisDescending());
            this.calcAxis(this.m_X1Axis);
        }
        if (axisDescriptor.hasY2()) {
            int y1Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y1_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y1_AXIS.getMajor())) {
                ++y1Auto;
            }
            int y2Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y2_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y2_AXIS.getMajor())) {
                ++y2Auto;
            }
            if (y1Auto <= y2Auto || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
                this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.calcAxis(this.m_Y1Axis);
                }
                this.createY2Axis(bVerticalChart, !this.m_Perspective.getY2AxisDescending(), offsetArray[1], sizeArray[1]);
                this.m_Y2Axis.m_requiredSteps = this.m_Y1Axis.m_numberOfSteps;
                this.calcAxis(this.m_Y2Axis);
            } else {
                this.createY2Axis(bVerticalChart, !this.m_Perspective.getY2AxisDescending(), offsetArray[1], sizeArray[1]);
                this.calcAxis(this.m_Y2Axis);
                this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.m_Y1Axis.m_requiredSteps = this.m_Y2Axis.m_numberOfSteps;
                    this.calcAxis(this.m_Y1Axis);
                }
            }
        } else {
            this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
            if (this.m_Y1Axis != null) {
                this.calcAxis(this.m_Y1Axis);
            }
        }
        if (axisDescriptor.hasY3()) {
            this.createY3Axis(bVerticalChart, !this.m_Perspective.getY3AxisDescending(), offsetArray[2], sizeArray[2]);
            this.calcAxis(this.m_Y3Axis);
        }
        if (axisDescriptor.hasY4()) {
            this.createY4Axis(bVerticalChart, !this.m_Perspective.getY4AxisDescending(), offsetArray[3], sizeArray[3]);
            this.calcAxis(this.m_Y4Axis);
        }
        if (axisDescriptor.hasY5()) {
            this.createY5Axis(bVerticalChart, !this.m_Perspective.getY5AxisDescending(), offsetArray[4], sizeArray[4]);
            this.calcAxis(this.m_Y5Axis);
        }
        this.m_Perspective.setAxisTextAutofitMode(nSaveMode);
        this.m_Perspective.setTestLabelCalc(false);
        if (this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void calcAxis(RelativeAxisObj relAxis) {
        if (relAxis != null) {
            relAxis.calc();
            if (relAxis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(relAxis.getAxisTextLabelSizeVC());
            }
        }
    }

    protected MinMaxObj createMinMaxZoom(RelativeAxisObj axis) {
        MinMaxObj minMaxZoom = null;
        if (axis == null) {
            return null;
        }
        Assert.assert(this.isZoomingArmed());
        Assert.assert(axis.isNumericAxis());
        ZoomState z = this.m_Perspective.getZoomList().getZoomState();
        if (z == null || !z.isZoomed()) {
            return null;
        }
        if (axis.isNumericAxis()) {
            minMaxZoom = z.getScaleMinMax(axis.getAxisObjID());
        }
        return minMaxZoom;
    }

    protected void createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, ordType, bVerticalAxis, bAscending);
    }

    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero() && !this.m_Perspective.getX1LogScale();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        if (this.isZoomingArmed() && (x1MinMaxZoom = this.createMinMaxZoom(this.m_X1Axis)) != null) {
            this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxZoom, bVerticalAxis, bAscending, 0, 100);
        }
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y2MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bVerticalAxis) {
            bAscending = !bAscending;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y2MinMaxZoom = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createZ1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bZ1LogScale = false;
        boolean bZ1MustIncludeZero = false;
        boolean bDisplayOnCalc = false;
        boolean bMustIncludeZero = bZ1MustIncludeZero && !bZ1LogScale;
        MinMaxObj z1MinMaxObj = this.findLimits(8, this.m_scaling, bMustIncludeZero, null);
        this.m_Z1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Z1_AXIS, z1MinMaxObj, bVerticalAxis, bAscending, 0, 100, bDisplayOnCalc);
    }

    protected void createY3Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y3_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y3Axis)) != null) {
            this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY4Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y4_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY5Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y5_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    private void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calcAxisBody();
        }
        if (this.m_Y3Axis != null) {
            this.m_Y3Axis.calcAxisBody();
        }
        if (this.m_Y4Axis != null) {
            this.m_Y4Axis.calcAxisBody();
        }
        if (this.m_Y5Axis != null) {
            this.m_Y5Axis.calcAxisBody();
        }
    }

    protected void drawDataValues() {
        int s;
        int g;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        Vector<String> szLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(5000, 1600);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                szLabels.addElement(this.m_DataLabel[s][g]);
            }
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                Rectangle rLabel;
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null || (rLabel = this.calcDataValuePosition(s, g, labelDim)) == null) continue;
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                new DetLabel(this.m_Detectiv, newID, this.m_DataLabel[s][g], rLabel, textStyle, (BlackBoxIF)blackBox, false, null);
            }
        }
    }

    Rectangle calcDataValuePosition(int s, int g, Dimension dimLabel) {
        Rectangle rDataTextPos = null;
        int nValueCoord = this.m_numYCoords[s][g];
        Axis2DObj yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            int nPrevCoord = 0;
            boolean bPrevCoordValid = false;
            if (sPrev != -2) {
                bPrevCoordValid = true;
                nPrevCoord = this.m_numYCoords[sPrev][g];
            }
            boolean nonZeroBaseline = this.m_Perspective.getNonZeroBaseline(yAxisObj.getAxisIdentObj());
            double fBaseLine = this.m_Perspective.getNonZeroBaselineValue(yAxisObj.getAxisIdentObj());
            if (nonZeroBaseline && this.m_bAbsolute && !this.m_gt.isStockType() && !this.m_gt.isParetoType() && yAxisObj.isLogScale() && fBaseLine <= 0.0) {
                nonZeroBaseline = false;
            }
            int baseLineYCoord = 0;
            if (nonZeroBaseline) {
                baseLineYCoord = fBaseLine <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseLine) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
            }
            int nDataTextPosition = this.m_Perspective.getDataTextPosition();
            int nGraphType = this.m_Perspective.getGraphType();
            Point ptTwoHalfDOffset = this.m_Frame.getDepthOffset(1.0);
            Point ptCenterTop = this.getCoords(s, g);
            double fDataValue = this.getDataValue((int)s, (int)g).m_fValue;
            int nBaseCoord = this.getBaseCoord(s);
            double fStackedCumVal = this.getStackedCumulativeValue(s, g);
            double fPercentCumVal = this.getPercentCumulativeValue(s, g);
            double fAngle = this.m_Perspective.getDataTextAngle(s, g);
            double fDist = this.m_Perspective.getDataTextRadius(s, g);
            boolean bIsCombo = this.isComboWithNonBar();
            DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nGraphType, ptTwoHalfDOffset, nBaseCoord, ptCenterTop, dimLabel, fDataValue, fStackedCumVal, fPercentCumVal, this.m_bHorz, this.isAxisAscending(s), fAngle, fDist, bIsCombo, nPrevCoord, bPrevCoordValid, nonZeroBaseline, baseLineYCoord, fBaseLine);
            rDataTextPos = dataTextPos.calcPosition();
        }
        return rDataTextPos;
    }

    protected void drawEquationText(CurveFitIF curve, double[] a, int s, double dCorr) {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getCurveFitEquationText();
        IdentObj idSeries = this.m_Perspective.getCurveFitEquationText(s);
        Dimension labelDim = new Dimension(5000, 1600);
        int nCoeffs = curve.numCoeffs();
        String[] strCoeffs = new String[nCoeffs + 1];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataTextFormat = this.m_Perspective.getDataTextFormat();
        String sDataTextFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        boolean bDrawCorrelation = false;
        int i = 1;
        while (i <= nCoeffs) {
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCoeffs[i] = this.m_Perspective.getNumberFormatCallBack().toString(a[i]);
            } else {
                strCoeffs[i] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, a[i], sDataTextFormatPattern);
            }
            ++i;
        }
        TextStyleObj tsEquation = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        if (this.m_Perspective.getFontSizeAbsolute()) {
            int nFontSizeVC = this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id));
        } else {
            int nFontSizeVC = this.m_Perspective.getFontSizeVC(id);
        }
        BlackBoxObj bbEquation = new BlackBoxObj(this.m_Perspective, idSeries);
        Rectangle rEquation = this.m_Perspective.getRect(idSeries);
        IdentObj newID = new IdentObj(idSeries);
        String strEquation = curve.createEquation(strCoeffs, this.m_Perspective.getCurveFitHighOrderFirst());
        if (bDrawCorrelation) {
            String strCorr;
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCorr = this.m_Perspective.getNumberFormatCallBack().toString(dCorr);
            } else {
                strCorr = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, dCorr, sDataTextFormatPattern);
            }
            strEquation = strEquation + ", " + strCorr;
        }
        new DetLabel(this.m_Detectiv, newID, strEquation, rEquation, tsEquation, (BlackBoxIF)bbEquation, true, null);
    }

    protected void drawFitLines() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            CurveFitIF curveObj = this.m_Perspective.getCurveObj(s);
            if (curveObj == null) continue;
            this.drawOneFitLine(s, curveObj);
        }
    }

    protected void drawOneFitLine(int s, CurveFitIF curveObj) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nCoeffs = curveObj.numCoeffs();
        int nPoints = 0;
        int gFirst = gEnum.getFirstGroup();
        double[] chisq = new double[1];
        double[] xPoints = new double[this.m_nTotalGroups + 1];
        double[] yPoints = new double[this.m_nTotalGroups + 1];
        int g = 0;
        while (g < this.m_nTotalGroups) {
            try {
                Point2d ptData = this.getDataValuesXY(s, g);
                xPoints[++nPoints] = ptData.x;
                yPoints[nPoints] = ptData.y;
            }
            catch (Exception e) {
                // empty catch block
            }
            ++g;
        }
        if (nPoints < nCoeffs) {
            return;
        }
        double[] a = new double[nCoeffs + 1];
        try {
            SVD.fit(curveObj, xPoints, yPoints, null, nPoints, a, chisq);
        }
        catch (Exception e) {
            return;
        }
        IdentObj id = this.m_Perspective.getCurveFitLineRiser(s);
        int nPixelWidth = this.m_Perspective.getLineWidth(id);
        if (nPixelWidth < 1) {
            nPixelWidth = 1;
        }
        int nWidth = this.m_Perspective.m_VC.destToVirtHeight(nPixelWidth);
        int nPlottedPoints = this.m_Perspective.getCurveFitNumSegments();
        if (nPlottedPoints > this.m_nTotalGroups) {
            switch (this.m_Perspective.getCurveFitType(s)) {
                case 4: 
                case 5: 
                case 9: {
                    nPlottedPoints = this.m_nTotalGroups + 1;
                    break;
                }
                default: {
                    nPlottedPoints = this.m_nTotalGroups;
                }
            }
        }
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        int nViewablePoints = 0;
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            try {
                Point2d ptData = this.getDataValuesXY(s, g);
                if (ptData.x < xMin) {
                    xMin = ptData.x;
                }
                if (ptData.x > xMax) {
                    xMax = ptData.x;
                }
                ++nViewablePoints;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (nViewablePoints < 2) {
            return;
        }
        double xIncr = (xMax - xMin) / (double)(nPlottedPoints - 1);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        Polygon plottedPoly = new Polygon();
        int i = 0;
        while (i < nPlottedPoints) {
            try {
                double x = xMin + (double)i * xIncr;
                double y = curveObj.compute(x, a);
                Point pt0 = this.getVCPositionsXY(s, x - (double)gFirst, y);
                plottedPoly.addPoint(pt0.x, pt0.y);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        Polyline polyline = new Polyline(plottedPoly.xpoints, plottedPoly.ypoints, plottedPoly.npoints, nWidth);
        new DetPolygon(this.m_Detectiv, id, polyline.m_polygon, (BlackBoxIF)blackBox, null);
        if (this.m_Perspective.getCurveFitEquationDisplay()) {
            this.drawEquationText(curveObj, a, s, chisq[0]);
        }
    }

    protected void drawLines(boolean bCircular) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        int nWidth = 0;
        int nStyle = Perspective.SOLID;
        boolean bCloseCircularLines = false;
        while (sEnum.hasMoreElements()) {
            Point pt2;
            Point pt1;
            BlackBoxIF blackBox;
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2) continue;
            IdentObj idSeries = new IdentObj(-3, s);
            gEnum.reset();
            if (gEnum.hasMoreElements()) {
                bCloseCircularLines = true;
            }
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                Assert.assert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                blackBox = this.assignSeriesColor(s, g);
                blackBox.setTransparentBorderColor(false);
                if (blackBox.getFillColor() != null) {
                    blackBox.setBorderColor(blackBox.getFillColor());
                }
                pt1 = this.getCoords(s, g);
                pt2 = this.getCoords(s, gNext);
                nWidth = this.m_Perspective.getLineWidth(idSeries);
                nStyle = this.m_Perspective.getLineStyle(idSeries);
                boolean bDrawNormal = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                    int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                    if (bFilledMissingData && nNumSegments != 0) {
                        this.drawMissingLineData(nNumSegments, pt1, pt2, s, g, blackBox, nWidth, nStyle);
                        bDrawNormal = false;
                    }
                }
                if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
                new DetLine(this.m_Detectiv, new IdentObj(258, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
            }
            if (!bCircular || !this.m_dataOK[s][0] || !this.m_dataOK[s][g] || !bCloseCircularLines) continue;
            pt1 = this.getCoords(s, g);
            pt2 = this.getCoords(s, 0);
            blackBox = this.assignSeriesColor(s, g);
            if (blackBox.getFillColor() != null) {
                blackBox.setBorderColor(blackBox.getFillColor());
            }
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            nStyle = this.m_Perspective.getLineStyle(idSeries);
            if (blackBox.getTransparentFillColor()) continue;
            new DetLine(this.m_Detectiv, new IdentObj(258, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
        }
    }

    private void drawMissingLineData(int nNumMissingSegments, Point ptIn1, Point ptIn2, int nSeries, int nGroup, BlackBoxIF blackBox, int nLineWidth, int nLineStyle) {
        Line theLine = new Line(ptIn1, ptIn2);
        int nDenominator = nNumMissingSegments * 2 + 1;
        int nIdx = 1;
        while (nIdx < nDenominator) {
            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
            IdentObj idObj = new IdentObj(258, nSeries, nGroup);
            new DetLine(this.m_Detectiv, idObj, ptOne.x, ptOne.y, ptTwo.x, ptTwo.y, blackBox, null, nLineWidth, nLineStyle);
            ++nIdx;
            ++nIdx;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawMarkers() {
        sEnum = this.getResetSeriesEnumerator();
        gEnum = this.getResetGroupsEnumerator();
        if (this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isScatter() || this.m_gt.isBubble()) ** GOTO lbl34
        return;
lbl-1000:
        // 1 sources

        {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2) continue;
            idSeries = new IdentObj(-3, s);
            nMarkerSeriesID = s % this.m_nSeriesLooping;
            idMarkerSeries = new IdentObj(-3, nMarkerSeriesID);
            markerTemplate = this.getMarkerShape(idMarkerSeries);
            if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
                markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                center = this.getCoords(s, g);
                markerSizeX = markerSizeY = this.getMarkerSize(s, g);
                if (this.m_bSquareMarkers) {
                    destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                    if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                        markerSizeX = (int)((double)markerSizeX * destY / destX);
                    } else {
                        markerSizeY = (int)((double)markerSizeY * destX / destY);
                    }
                }
                blackBox = this.assignSeriesColor(s, g);
                if (this.m_gt.isBubble()) {
                    this._addBubbleMarker(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, markerSizeX, markerSizeY, blackBox, this.m_rClip, true);
                    continue;
                }
                new MarkerObj(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, markerSizeX, markerSizeY, blackBox, null, true);
            }
lbl34:
            // 3 sources

            ** while (sEnum.hasMoreElements())
        }
lbl35:
        // 1 sources

        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjs();
        }
    }

    private void _addBubbleMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, new Integer(markerSizeX), new Integer(markerSizeY), blackBox, rClip, new Boolean(bLimitSize)};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjs() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            Iterator iterator = ((AbstractList)this.m_bubbleMarkerInfo).iterator();
            while (iterator.hasNext()) {
                Object[] bubbleInfo = (Object[])iterator.next();
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                new MarkerObj(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkers(int nSeriesType) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != nSeriesType) continue;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                Point ptCenter = this.getCoords(s, g);
                new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptCenter, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true);
            }
        }
    }

    private Dimension getTransparentMarkerDimension() {
        double destY;
        int nMarkerHeight;
        int nMarkerSize = this.m_Perspective.getTransparentMarkerSize();
        int nMarkerWidth = nMarkerSize == 0 ? (nMarkerHeight = this.m_Perspective.getMarkerSizeDefault()) : (nMarkerHeight = nMarkerSize);
        double destX = this.m_Perspective.m_VC.virtToDestWidth((double)nMarkerWidth);
        if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)nMarkerHeight))) {
            nMarkerWidth = (int)((double)nMarkerWidth * destY / destX);
        } else {
            nMarkerHeight = (int)((double)nMarkerHeight * destX / destY);
        }
        Dimension dimMarker = new Dimension(nMarkerWidth, nMarkerHeight);
        return dimMarker;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawAllMarkersWithDepth() {
        sEnum = this.getResetSeriesEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame != null) ** GOTO lbl10
        throw new AssertionException("Can't draw 2.5D markers without m_Frame");
lbl-1000:
        // 1 sources

        {
            s = sEnum.nextSeries();
            this.drawMarkersWithDepth(s);
lbl10:
            // 2 sources

            ** while (sEnum.hasMoreElements())
        }
lbl11:
        // 1 sources

    }

    protected void drawMarkersWithDepth(int s) {
        int nYDepth;
        int nXDepth;
        Point ptBackOffset;
        Point ptFrontOffset;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
        if (this.m_seriesTypes[s] != 2) {
            return;
        }
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = this.m_Perspective.getSeries(nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
            nXDepth = ptFrontOffset.x - ptBackOffset.x;
            nYDepth = ptFrontOffset.y - ptBackOffset.y;
            nXDepth = 3 * nXDepth;
            nYDepth = 3 * nYDepth;
        } else {
            ptFrontOffset = new Point();
            ptBackOffset = new Point();
            nXDepth = 0;
            nYDepth = 0;
        }
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            int markerSizeY;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            Point ptCenter = this.getCoords(s, g);
            Point ptFront = new Point(ptCenter.x - ptFrontOffset.x, ptCenter.y - ptFrontOffset.y);
            int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
            if (this.m_bSquareMarkers) {
                double destY;
                double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                    markerSizeX = (int)((double)markerSizeX * destY / destX);
                } else {
                    markerSizeY = (int)((double)markerSizeY * destX / destY);
                }
            }
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            IdentObj identObjLineMarker = new IdentObj(259, s, g);
            identObjLineMarker.setMiscID(0);
            if (this.m_gt.isBubble()) {
                this._addBubbleMarkerWithDepth(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, blackBox, this.m_rClip, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
                continue;
            }
            new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, blackBox, null, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
        }
        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjsWithDepth();
        }
    }

    private void _addBubbleMarkerWithDepth(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, new Integer(markerSizeX), new Integer(markerSizeY), blackBox, rClip, new Boolean(bLimitSize), new Boolean(threed), new Integer(nXDepth), new Integer(nYDepth), new Integer(nDepthAngle)};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjsWithDepth() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            Iterator iterator = ((AbstractList)this.m_bubbleMarkerInfo).iterator();
            while (iterator.hasNext()) {
                Object[] bubbleInfo = (Object[])iterator.next();
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                boolean threed = (Boolean)bubbleInfo[9];
                int nXDepth = (Integer)bubbleInfo[10];
                int nYDepth = (Integer)bubbleInfo[11];
                int nDepthAngle = (Integer)bubbleInfo[12];
                new MarkerObj(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nXDepth, nYDepth, nDepthAngle);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkersWithDepth(int s, int nSeriesType) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        if (this.m_seriesTypes[s] == nSeriesType) {
            int nYDepth;
            int nXDepth;
            Point ptBackOffset;
            Point ptFrontOffset;
            if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
                double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
                double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
                nXDepth = ptFrontOffset.x - ptBackOffset.x;
                nYDepth = ptFrontOffset.y - ptBackOffset.y;
                nXDepth = 3 * nXDepth;
                nYDepth = 3 * nYDepth;
            } else {
                ptFrontOffset = new Point();
                ptBackOffset = new Point();
                nXDepth = 0;
                nYDepth = 0;
            }
            nYDepth = 0;
            nXDepth = 0;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                Point ptCenter = this.getCoords(s, g);
                ptFront.x = ptCenter.x - ptFrontOffset.x;
                ptFront.y = ptCenter.y - ptFrontOffset.y;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                identObjLineMarker.setMiscID(0);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
            }
        }
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        MinMaxObj minMaxObj;
        block100: {
            int s;
            int[] axisAssignments;
            int nItems;
            DataFormat df;
            int nZeroValue;
            double fEndOfPreviousStack;
            block101: {
                block93: {
                    fEndOfPreviousStack = 0.0;
                    nZeroValue = 0;
                    minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
                    if (minMaxObj != null) {
                        return minMaxObj;
                    }
                    minMaxObj = new MinMaxObj(bMustIncludeZero);
                    df = this.m_Access.getDataFormat();
                    nItems = df.getNumDataItems();
                    axisAssignments = new int[this.m_nTotalSeries];
                    s = 0;
                    while (s < this.m_nTotalSeries) {
                        axisAssignments[s] = this.getAxisAssignment(s);
                        ++s;
                    }
                    this.setNonDataLimits(minMaxObj);
                    if (scaling != 1) break block93;
                    s = 0;
                    while (s < this.m_nTotalSeries) {
                        block94: {
                            if ((axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) break block94;
                            if (axis == 1) {
                                this.m_dualY = true;
                            }
                            if (axis == 7) {
                                this.m_XY = true;
                            }
                            if (this.m_dualY && this.m_XY) {
                                this.m_dualYX = true;
                                this.m_dualY = false;
                                this.m_XY = false;
                            }
                            int g = 0;
                            while (g < this.m_nTotalGroups) {
                                int i = 0;
                                while (i < nItems) {
                                    block95: {
                                        double fValue;
                                        block99: {
                                            block96: {
                                                DatumObj dObj;
                                                block98: {
                                                    block97: {
                                                        DataItem item = df.getDataItem(i);
                                                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) break block95;
                                                        dObj = this.getDataValue(s, g, item);
                                                        fValue = dObj.m_fValue;
                                                        if (fValue == 0.0 && !dObj.m_bOK) {
                                                            if (axis == 0) {
                                                                this.m_nullValY1 = true;
                                                            } else if (axis == 1) {
                                                                this.m_nullValY2 = true;
                                                            } else if (axis == 7) {
                                                                this.m_nullValX1 = true;
                                                            }
                                                        }
                                                        if (!dObj.m_bOK) break block95;
                                                        if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) break block96;
                                                        if (axis != 0) break block97;
                                                        if (fValue == 0.0 && dObj.m_bOK) {
                                                            this.m_zeroValY1 = true;
                                                        } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                            this.m_nullValY1 = true;
                                                        } else {
                                                            this.m_negativeValY1 = true;
                                                        }
                                                        break block95;
                                                    }
                                                    if (axis != 1) break block98;
                                                    if (fValue == 0.0 && dObj.m_bOK) {
                                                        this.m_zeroValY2 = true;
                                                    } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                        this.m_nullValY2 = true;
                                                    } else {
                                                        this.m_negativeValY2 = true;
                                                    }
                                                    break block95;
                                                }
                                                if (axis != 7) break block99;
                                                if (fValue == 0.0 && dObj.m_bOK) {
                                                    this.m_zeroValX1 = true;
                                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                    this.m_nullValX1 = true;
                                                } else {
                                                    this.m_negativeValX1 = true;
                                                }
                                                break block95;
                                            }
                                            if (axis == 0) {
                                                this.m_positiveValY1 = true;
                                            } else if (axis == 1) {
                                                this.m_positiveValY2 = true;
                                            } else if (axis == 7) {
                                                this.m_positiveValX1 = true;
                                            }
                                        }
                                        if (mmZoom == null || !(fValue < mmZoom.getAdjMin()) && !(fValue > mmZoom.getAdjMax())) {
                                            minMaxObj.testRawValue(fValue);
                                        }
                                    }
                                    ++i;
                                }
                                ++g;
                            }
                        }
                        ++s;
                    }
                    break block100;
                }
                if (scaling != 2) break block101;
                SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
                GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    SumObj sumObj = new SumObj();
                    sEnum.reset();
                    while (sEnum.hasMoreElements()) {
                        s = sEnum.nextSeries();
                        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                        if ((axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                        if (axis == 1) {
                            this.m_dualY = true;
                        }
                        if (axis == 7) {
                            this.m_XY = true;
                        }
                        if (this.m_dualY && this.m_XY) {
                            this.m_dualYX = true;
                            this.m_dualY = false;
                            this.m_XY = false;
                        }
                        int i = 0;
                        while (i < nItems) {
                            block102: {
                                double fValue;
                                block106: {
                                    block103: {
                                        DatumObj dObj;
                                        block105: {
                                            block104: {
                                                DataItem item = df.getDataItem(i);
                                                if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) break block102;
                                                dObj = this.getDataValue(s, g, item);
                                                fValue = dObj.m_fValue;
                                                if (fValue == 0.0 && !dObj.m_bOK) {
                                                    if (axis == 0) {
                                                        this.m_nullValY1 = true;
                                                    } else if (axis == 1) {
                                                        this.m_nullValY2 = true;
                                                    } else if (axis == 7) {
                                                        this.m_nullValX1 = true;
                                                    }
                                                }
                                                if (!dObj.m_bOK) break block102;
                                                if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) break block103;
                                                if (axis != 0) break block104;
                                                if (fValue == 0.0 && dObj.m_bOK) {
                                                    this.m_zeroValY1 = true;
                                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                    this.m_nullValY1 = true;
                                                } else {
                                                    this.m_negativeValY1 = true;
                                                }
                                                break block102;
                                            }
                                            if (axis != 1) break block105;
                                            if (fValue == 0.0 && dObj.m_bOK) {
                                                this.m_zeroValY2 = true;
                                            } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                this.m_nullValY2 = true;
                                            } else {
                                                this.m_negativeValY2 = true;
                                            }
                                            break block102;
                                        }
                                        if (axis != 7) break block106;
                                        if (fValue == 0.0 && dObj.m_bOK) {
                                            this.m_zeroValX1 = true;
                                        } else if (fValue == 0.0 && !dObj.m_bOK) {
                                            this.m_nullValX1 = true;
                                        } else {
                                            this.m_negativeValX1 = true;
                                        }
                                        break block102;
                                    }
                                    if (axis == 0) {
                                        this.m_positiveValY1 = true;
                                    } else if (axis == 1) {
                                        this.m_positiveValY2 = true;
                                    } else if (axis == 7) {
                                        this.m_positiveValX1 = true;
                                    }
                                }
                                boolean bPos = fValue >= 0.0;
                                boolean bY2 = axis == 1;
                                int nRiser = this.m_seriesTypes[s];
                                double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                                sumObj.setSum(bPos, bY2, nRiser, fSum);
                                minMaxObj.testRawValue(fSum);
                            }
                            ++i;
                        }
                    }
                }
                break block100;
            }
            if (scaling == 5) {
                SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
                GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    SumObj sumObj = new SumObj();
                    sEnum.reset();
                    while (sEnum.hasMoreElements()) {
                        s = sEnum.nextSeries();
                        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                        if ((axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                        int i = 0;
                        while (i < nItems) {
                            DataItem item = df.getDataItem(i);
                            if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                                DatumObj dObj = this.getDataValue(s, g, item);
                                double fValue = dObj.m_fValue;
                                if (dObj.m_bOK) {
                                    if (!sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                                        fValue = -fValue;
                                    }
                                    if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) {
                                        boolean bPos = fValue >= 0.0;
                                        boolean bY2 = axis == 1;
                                        int nRiser = this.m_seriesTypes[s];
                                        double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                                        sumObj.setSum(bPos, bY2, nRiser, fSum);
                                        minMaxObj.testRawValue(fSum += fEndOfPreviousStack);
                                        if (s == sEnum.getLastSeries()) {
                                            fEndOfPreviousStack = fSum;
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            } else if (scaling == 3) {
                boolean bHasNegValues = false;
                s = 0;
                block10: while (s < this.m_nTotalSeries) {
                    if (axis != 0 && axis != 1 && axis != 2 && axis != 3 && axis != 4 || axisAssignments[s] == axis) {
                        int g = 0;
                        while (g < this.m_nTotalGroups) {
                            int i = 0;
                            while (i < nItems) {
                                DataItem item = df.getDataItem(i);
                                if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                                    DatumObj dObj = this.getDataValue(s, g, item);
                                    double fValue = dObj.m_fValue;
                                    if (dObj.m_bOK) {
                                        if (fValue < 0.0) {
                                            this.m_negativeVal = true;
                                            bHasNegValues = true;
                                            break block10;
                                        }
                                        if (fValue == 0.0 && dObj.m_bOK) {
                                            this.m_zeroVal = true;
                                            ++nZeroValue;
                                        }
                                        if (fValue > 0.0) {
                                            this.m_positiveVal = true;
                                        }
                                    }
                                }
                                ++i;
                            }
                            ++g;
                        }
                    }
                    ++s;
                }
                minMaxObj.testRawValue(1.0);
                if (bHasNegValues) {
                    minMaxObj.testRawValue(-1.0);
                } else {
                    minMaxObj.testRawValue(0.0);
                }
            } else if (scaling == 4) {
                s = 0;
                while (s < this.m_nTotalSeries) {
                    int g = 0;
                    while (g < this.m_nTotalGroups) {
                        if (axis == 7) {
                            int i = 0;
                            while (i < nItems) {
                                DataItem item = df.getDataItem(i);
                                if (!item.ignoreInScaling()) {
                                    DatumObj dObj = this.getDataValue(s, g, item);
                                    double fValue = dObj.m_fValue;
                                    if (!(!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue))) {
                                        minMaxObj.testRawValue(fValue);
                                    }
                                }
                                ++i;
                            }
                        } else {
                            throw new AssertionException("FindLimit should not be called for Y1 axis");
                        }
                        ++g;
                    }
                    ++s;
                }
            } else {
                throw new AssertionException(1, 5, scaling);
            }
        }
        return minMaxObj;
    }

    public int getBaseCoord(int s) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        boolean bFromZero = this.m_Perspective.getScaleFromZero() || yAxisObj.hasNegData() && !this.m_bAbsolute;
        int baseCoord = bFromZero ? (int)yAxisObj.getValueCoord(0.0) : (int)yAxisObj.getBaseCoord();
        return baseCoord;
    }

    public int getDataCoord(int s, int g) {
        return this.getDataCoord(s, g, DataItem.DI_GENERAL, false);
    }

    public int getDataCoord(int s, int g, DataItem item, boolean bCumulative) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        double val = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
        if (bCumulative) {
            return this.getDataCoordCum(s, g, item);
        }
        return (int)axisObj.getValueCoord(val);
    }

    public int getDataCoordCum(int s, int g, DataItem item) {
        return this.m_numYCoords[s][g];
    }

    public double getDataFromCoord(int s, int g, int nCoord) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
        return yAxisObj.getValueFromCoord(nCoord);
    }

    public double getDataFromCoord(int s, int g, DataItem item, int nCoord) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        return axisObj.getValueFromCoord(nCoord);
    }

    public DatumObj getDataValue(int s, int g, DataItem item) {
        DatumObj dObj = super.getDataValue(s, g, item);
        double fValue = dObj.m_fValue;
        boolean bOK = dObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && fValue < 0.0) {
            dObj = new DatumObj(-fValue, bOK);
        }
        return dObj;
    }

    public double getAutoLowerSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoLowerSplitValue();
        }
        return Double.NaN;
    }

    public double getAutoHigherSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoHigherSplitValue();
        }
        return Double.NaN;
    }

    public int getMarkerSize(int s, int g) {
        return this.m_Perspective.getMarkerSize(s, g);
    }

    public MarkerTemplate getMarkerShape(IdentObj idMarkerSeries) {
        MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(idMarkerSeries);
        return markerTemplate;
    }

    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).m_fValue;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            Vector dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            Assert.assert(nLabels > 1);
            boolean bFound = false;
            int i = 1;
            while (i < nLabels && !bFound) {
                double fCurr;
                double fPrev = (Double)dLabels.elementAt(i - 1);
                double fMid = (fPrev + (fCurr = ((Double)dLabels.elementAt(i)).doubleValue())) / 2.0;
                if (fValue < fMid) {
                    fValue = fPrev;
                    bFound = true;
                }
                ++i;
            }
            if (!bFound) {
                fValue = (Double)dLabels.elementAt(nLabels - 1);
            }
        }
        return fValue;
    }

    public RelativeAxisObj getX1Axis() {
        return this.m_X1Axis;
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public RelativeAxisObj getY2Axis() {
        return this.m_Y2Axis;
    }

    public RelativeAxisObj getO1Axis() {
        return this.m_O1Axis;
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        this.m_Z1Axis = null;
    }

    protected boolean isAxisAscending(int nSeries) {
        RelativeAxisObj axis = this.whichAxisForSeries(nSeries, DataItem.DI_GENERAL);
        return axis.isAscending();
    }

    public boolean isComboWithBar() {
        boolean bIsCombo = false;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isComboWithNonBar() {
        boolean bIsCombo = false;
        if (this.m_Perspective.getGraphType() == 102) {
            return false;
        }
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] == 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isZoomingArmed() {
        boolean bEnabled = this.m_Perspective.getZoomList().isCurrentlyZoomed();
        return bEnabled;
    }

    protected int prevSeriesForAxis(int sCurrent, int axisCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, int axisCurrent, boolean bNegCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        int nRiserCurrent = this.m_seriesTypes[sCurrent];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nRiserType;
            boolean bNegPrev;
            RelativeAxisObj axisObj;
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent || !this.m_dataOK[s][gCurrent]) continue;
            switch (axis) {
                case 7: {
                    axisObj = this.m_X1Axis;
                    break;
                }
                case 0: {
                    axisObj = this.m_Y1Axis;
                    break;
                }
                case 1: {
                    axisObj = this.m_Y2Axis;
                    break;
                }
                case 2: {
                    axisObj = this.m_Y3Axis;
                    break;
                }
                case 3: {
                    axisObj = this.m_Y4Axis;
                    break;
                }
                case 4: {
                    axisObj = this.m_Y5Axis;
                    break;
                }
                case 8: {
                    axisObj = this.m_Z1Axis;
                    break;
                }
                default: {
                    throw new AssertionException("Invalid axis = " + axis);
                }
            }
            int zeroCoord = (int)axisObj.getValueCoord(0.0);
            boolean bl = bNegPrev = this.m_numYCoords[s][gCurrent] < zeroCoord;
            if (bNegPrev != bNegCurrent || (nRiserType = this.m_seriesTypes[s]) != nRiserCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, RelativeAxisObj axisObjDesired, boolean bNegValue) {
        return this.prevSeriesForAxis(sCurrent, gCurrent, axisObjDesired.getAxisObjID(), bNegValue);
    }

    protected int prevSeriesForAxis(int sCurrent, RelativeAxisObj axisObjDesired) {
        return this.prevSeriesForAxis(sCurrent, axisObjDesired.getAxisObjID());
    }

    protected double processOneStackedValue(int s, int g, RelativeAxisObj yAxisObj, double fValue, SumObj sumObj) {
        int nRiser;
        boolean bY2;
        boolean bPos = fValue >= 0.0;
        double fNewSum = sumObj.getSum(bPos, bY2 = yAxisObj == this.m_Y2Axis, nRiser = this.m_seriesTypes[s]) + fValue;
        if (this.isIgnoredOffScale(yAxisObj, fNewSum)) {
            this.m_dataOK[s][g] = false;
        } else {
            sumObj.setSum(bPos, bY2, nRiser, fNewSum);
            this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNewSum);
        }
        return fNewSum;
    }

    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.releaseReferences();
        }
        if (this.m_Z1Axis != null) {
            this.m_Z1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public boolean seriesAssignedToBothAxes() {
        boolean bAssignedToY1 = false;
        boolean bAssignedToOtherY = false;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            int assignedAxis = this.getAxisAssignment(s);
            if ((bAssignedToY1 |= assignedAxis == 0) && (bAssignedToOtherY |= assignedAxis != 0)) break;
        }
        return bAssignedToY1 && bAssignedToOtherY;
    }

    public void setNonDataLimits(MinMaxObj mm) {
    }

    protected RelativeAxisObj whichAxisForSeries(int s, DataItem item) {
        RelativeAxisObj axisObj;
        int axis = this.axisAssignedToSeries(s, item);
        switch (axis) {
            case 7: {
                axisObj = this.m_X1Axis;
                break;
            }
            case 0: {
                axisObj = this.m_Y1Axis;
                break;
            }
            case 1: {
                axisObj = this.m_Y2Axis;
                break;
            }
            case 2: {
                axisObj = this.m_Y3Axis;
                break;
            }
            case 3: {
                axisObj = this.m_Y4Axis;
                break;
            }
            case 4: {
                axisObj = this.m_Y5Axis;
                break;
            }
            case 8: {
                axisObj = this.m_Z1Axis;
                break;
            }
            default: {
                axisObj = null;
            }
        }
        return axisObj;
    }

    public int axisAssignedToSeries(int s, DataItem item) {
        int nAxis;
        if (this.m_gt.isMultiY()) {
            nAxis = this.getAxisAssignment(s);
        } else {
            nAxis = item == null ? 0 : item.getAssocAxis();
            if (nAxis == 0) {
                nAxis = this.getAxisAssignment(s);
            }
        }
        return nAxis;
    }

    protected int whichOrdType() {
        int nOrdType = 1;
        if (this.m_bExtendToFrameEdge && !this.m_bIsThisAComboWithBar) {
            nOrdType = 6;
        } else if (this.m_gt.isRiserBar()) {
            if (this.m_bAbsolute) {
                nOrdType = 0;
            } else if (this.m_bStacked && this.m_gt.isDualY() && !this.m_gt.isBipolar() && this.seriesAssignedToBothAxes()) {
                nOrdType = 3;
            }
        } else if (this.m_gt.isRiserArea() || this.m_gt.isRiserMarker()) {
            nOrdType = 2;
        } else if (this.m_gt.isParetoType()) {
            nOrdType = 10;
        }
        return nOrdType;
    }

    /*
     * WARNING - void declaration
     */
    String ReplaceMacro(String SourceString, String aMacro, String Replacement) {
        int aPosition;
        String aProcessedString = "";
        aProcessedString = SourceString;
        while ((aPosition = aProcessedString.indexOf(aMacro)) != -1) {
            void var6_6;
            String testString = aProcessedString.substring(0, (int)var6_6);
            testString = testString + Replacement;
            aPosition = var6_6 + aMacro.length();
            aProcessedString = testString = testString + aProcessedString.substring(aPosition, aProcessedString.length());
        }
        return aProcessedString;
    }

    protected abstract Point getCoords(int var1, int var2);

    protected abstract String processDataTextTemplate(String[] var1, String var2);

    class SumObj {
        double[] m_sumPosY1 = new double[3];
        double[] m_sumPosY2 = new double[3];
        double[] m_sumNegY1 = new double[3];
        double[] m_sumNegY2 = new double[3];
        boolean m_bFirstSetIsPositive;
        boolean m_bFirstTime = true;

        public double getSum(boolean bPositive, boolean bY2, int nRiserType) {
            int i;
            switch (nRiserType) {
                case 2: {
                    i = 1;
                    break;
                }
                case 3: {
                    i = 2;
                    break;
                }
                default: {
                    i = 0;
                }
            }
            if (bPositive) {
                if (bY2) {
                    return this.m_sumPosY2[i];
                }
                return this.m_sumPosY1[i];
            }
            if (bY2) {
                return this.m_sumNegY2[i];
            }
            return this.m_sumNegY1[i];
        }

        public void setSum(boolean bPositive, boolean bY2, int nRiserType, double newValue) {
            switch (nRiserType) {
                case 2: {
                    int i = 1;
                    break;
                }
                case 3: {
                    int i = 2;
                    break;
                }
                default: {
                    int i = 0;
                }
            }
            if (bPositive) {
                if (bY2) {
                    this.m_sumPosY2[i] = newValue;
                } else {
                    this.m_sumPosY1[i] = newValue;
                }
            } else if (bY2) {
                this.m_sumNegY2[i] = newValue;
            } else {
                this.m_sumNegY1[i] = newValue;
            }
            if (this.m_bFirstTime) {
                this.m_bFirstSetIsPositive = bPositive;
                this.m_bFirstTime = false;
            }
        }
    }
}

