/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Point;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.AxisHistObj;
import tdg.AxisTemplate;
import tdg.DataFormat;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.MinMaxObj;
import tdg.SeriesEnumerator;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;

public class JChart_2D_Hist
extends JChart_2D_Standard {
    private int[] m_buckets;

    public void calc() {
        super.calc();
        this.drawRisers();
    }

    private void calcBuckets() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        DataFormat df = this.m_Access.getDataFormat();
        double fValue = 0.0;
        int nBuckets = this.m_X1Axis.getNumIntervals();
        this.m_buckets = new int[nBuckets];
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            block1: while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                boolean bDataOK = true;
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.m_fValue;
                bDataOK = dObj.m_bOK;
                if (!bDataOK) continue;
                int nInterval = 0;
                while (nInterval < this.m_X1Axis.getNumIntervals()) {
                    if (fValue >= this.m_X1Axis.getIntervalStart(nInterval) && fValue <= this.m_X1Axis.getIntervalStop(nInterval)) {
                        int n = nInterval;
                        this.m_buckets[n] = this.m_buckets[n] + 1;
                        continue block1;
                    }
                    ++nInterval;
                }
            }
        }
    }

    protected Point getCoords(int s, int g) {
        Point center = this.m_bHorz ? new Point(this.m_numYCoords[s][g], this.m_numXCoords[s][g]) : new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]);
        return center;
    }

    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, false, null);
        this.m_X1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        this.calcBuckets();
        MinMaxObj y1MinMaxObj = this.findHistLimits();
        this.m_Y1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
    }

    private void drawRisers() {
        int nBuckets = this.m_X1Axis.getNumIntervals();
        IdentObj id = new IdentObj(311);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        boolean bDescendingX1 = this.m_X1Axis.isDescending();
        boolean bDescendingY1 = this.m_Y1Axis.isDescending();
        int bucket = 0;
        while (bucket < nBuckets) {
            int top;
            int bottom;
            int right;
            int left;
            int low = ((AxisHistObj)this.m_X1Axis).getLowIntervalCoord(bucket);
            int high = ((AxisHistObj)this.m_X1Axis).getHighIntervalCoord(bucket);
            if (this.m_gt.isOrientHorz()) {
                left = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                right = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                bottom = bDescendingX1 ? high : low;
                top = bDescendingX1 ? low : high;
            } else {
                bottom = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                top = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                left = bDescendingX1 ? high : low;
                right = bDescendingX1 ? low : high;
            }
            Rectangle rVirt = new Rectangle(left, bottom, Math.abs(right - left), Math.abs(top - bottom));
            new DetRect(this.m_Detectiv, new IdentObj(311, -3, -3, -3, bucket), rVirt, blackBox, this.m_rClip);
            ++bucket;
        }
    }

    private MinMaxObj findHistLimits() {
        int max = 0;
        int i = 0;
        while (i < this.m_X1Axis.getNumIntervals()) {
            if (this.m_buckets[i] > max) {
                max = this.m_buckets[i];
            }
            ++i;
        }
        return new MinMaxObj(0.0, max);
    }

    public boolean wantLegend() {
        return false;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }
}

