/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import com.threedgraphics.math.FP;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import tdg.DataScroller;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLine;
import tdg.draw.DetPolygon;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;

public class FrameObj
implements Serializable {
    static final int SIDE_OFFSET = 100;
    static final int BOTTOM_OFFSET = 200;
    public static final int XDEPTH_OFFSET_RATIO = 3;
    protected Perspective m_Perspective;
    protected IdentObj m_id;
    protected Rectangle m_rect;
    protected boolean m_bLooseBounds;
    protected Polygon m_polySide;
    protected Polygon m_polyBottom;
    protected int m_depthAngle;
    protected int m_depthRadius;
    protected double m_dx;
    protected double m_dy;
    protected DataScroller m_dsGroup;

    public FrameObj(Perspective perspective) {
        this(perspective, false);
    }

    public FrameObj(Perspective perspective, boolean bLooseBounds) {
        this.m_Perspective = perspective;
        this.m_id = new IdentObj(2);
        this.m_rect = null;
        this.m_polySide = null;
        this.m_polyBottom = null;
        this.m_bLooseBounds = bLooseBounds;
        this.m_dsGroup = null;
    }

    public void calc() {
        boolean bDrawWithDepth;
        JGraphType gt = this.m_Perspective.getJGraphType();
        this.m_rect = this.m_Perspective.getRect(this.m_id);
        this.m_depthAngle = this.m_Perspective.getDepthAngle();
        this.m_depthRadius = this.m_Perspective.getDepthRadius();
        if (this.m_depthAngle < 0 || this.m_depthAngle > 180 || this.m_depthRadius < 0 || this.m_depthRadius > 100) {
            this.m_depthRadius = 0;
        }
        if (!(gt.isBLAType() || gt.isScatter() || gt.isBubble() || gt.isPolar())) {
            this.m_depthRadius = 0;
        }
        boolean bl = bDrawWithDepth = this.m_depthRadius > 0;
        if (bDrawWithDepth) {
            double rMax = this.m_rect.width / 3;
            double r = rMax * (double)this.m_depthRadius / 100.0;
            this.m_dx = r * Math.cos((double)this.m_depthAngle * (Math.PI / 180));
            this.m_dy = r * Math.sin((double)this.m_depthAngle * (Math.PI / 180));
            if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
                int xFrame = this.m_depthAngle < 90 ? this.m_rect.x : this.m_rect.x + this.m_rect.width;
                this.m_polySide = new Polygon();
                this.m_polySide.addPoint(xFrame, this.m_rect.y);
                this.m_polySide.addPoint(xFrame, this.m_rect.y + this.m_rect.height);
                this.m_polySide.addPoint(xFrame - (int)this.m_dx, this.m_rect.y + this.m_rect.height - (int)this.m_dy);
                this.m_polySide.addPoint(xFrame - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polySide.addPoint(xFrame, this.m_rect.y);
            }
            if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
                this.m_polyBottom = new Polygon();
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
            }
        }
        if (this.m_Perspective.getFrameDisplay()) {
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
            new DetRect(this.m_Perspective.getDetectiv(), this.m_id, this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height, blackBox, null, true, true, this.m_bLooseBounds);
            if (bDrawWithDepth) {
                if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
                    IdentObj idSide = new IdentObj(15);
                    BlackBoxObj blackBoxSide = new BlackBoxObj(this.m_Perspective, idSide);
                    new DetPolygon(this.m_Perspective.getDetectiv(), idSide, this.m_polySide, (BlackBoxIF)blackBoxSide, 1.0);
                }
                if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
                    IdentObj idBottom = new IdentObj(16);
                    BlackBoxObj blackBoxBottom = new BlackBoxObj(this.m_Perspective, idBottom);
                    new DetPolygon(this.m_Perspective.getDetectiv(), idBottom, this.m_polyBottom, (BlackBoxIF)blackBoxBottom, 1.0);
                }
            }
            this.m_dsGroup = new DataScroller(this.m_Perspective, this.getFrontWallBounds(), gt.isOrientHorz(), true);
        }
    }

    public void calcDataScrollers() {
        if (this.m_dsGroup != null) {
            this.m_dsGroup.calc();
            if (this.m_depthRadius > 0) {
                // empty if block
            }
        }
    }

    public void drawSeparator(boolean bHorz, double fSplit) {
        if (fSplit < 0.0 || fSplit > 1.0) {
            return;
        }
        IdentObj idSep = new IdentObj(17);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idSep);
        int nLineWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getFrameSeparator());
        Rectangle rFrame = new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
        if (bHorz) {
            if (this.m_Perspective.isGroupScrollerPresent()) {
                int nWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
                rFrame.x += nWidth;
                rFrame.width -= nWidth;
            }
            int x0 = (int)((double)rFrame.x + fSplit * (double)rFrame.width);
            int y0 = rFrame.y;
            if (this.m_depthRadius > 0) {
                Polygon polyVC = new Polygon();
                polyVC.addPoint(x0, y0);
                polyVC.addPoint(x0, y0 + rFrame.height);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 + rFrame.height - (int)this.m_dy);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0, y0);
                new DetPolygon(this.m_Perspective.getDetectiv(), idSep, polyVC, (BlackBoxIF)blackBox, 1.0);
            } else {
                new DetLine(this.m_Perspective.getDetectiv(), idSep, x0, y0, x0, y0 + rFrame.height, blackBox, null, nLineWidth);
            }
        } else {
            if (this.m_Perspective.isGroupScrollerPresent()) {
                int nHeight = this.m_Perspective.m_VC.destToVirtHeight(8);
                rFrame.y += nHeight;
                rFrame.height -= nHeight;
            }
            int x0 = rFrame.x;
            int y0 = (int)((double)rFrame.y + fSplit * (double)rFrame.height);
            if (this.m_depthRadius > 0) {
                Polygon polyVC = new Polygon();
                polyVC.addPoint(x0, y0);
                polyVC.addPoint(x0 + rFrame.width, y0);
                polyVC.addPoint(x0 + rFrame.width - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0, y0);
                new DetPolygon(this.m_Perspective.getDetectiv(), idSep, polyVC, (BlackBoxIF)blackBox, 1.0);
            } else {
                new DetLine(this.m_Perspective.getDetectiv(), idSep, x0, y0, x0 + rFrame.width, y0, blackBox, null, nLineWidth);
            }
        }
    }

    public Rectangle getBackWallBounds() {
        return new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    public Rectangle getFrontWallBounds() {
        return new Rectangle(this.m_rect.x - (int)this.m_dx, this.m_rect.y - (int)this.m_dy, this.m_rect.width, this.m_rect.height);
    }

    public Point getDepthOffset(double z) {
        if (z < 0.0) {
            z = 0.0;
        } else if (z > 1.0) {
            z = 1.0;
        }
        double dx = z * this.m_dx;
        double dy = z * this.m_dy;
        Point pt = new Point((int)dx, (int)dy);
        return pt;
    }

    public Rectangle getBottomEdge() {
        Rectangle r = this.m_rect.getBounds();
        if (this.m_depthRadius > 0 && this.m_polyBottom != null) {
            int x = r.x;
            int width = r.width;
            r = this.m_polyBottom.getBounds();
            if (this.m_depthAngle > 90) {
                r.x = r.x + r.width - width;
            }
            r.width = width;
        }
        return r;
    }

    public Rectangle getLeftEdge() {
        Rectangle r = this.m_depthRadius > 0 && this.m_depthAngle < 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return r;
    }

    public Rectangle getRightEdge() {
        Rectangle r = this.m_depthRadius > 0 && this.m_depthAngle > 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return r;
    }

    public void drawFrameBorders(int nWidth) {
        int i;
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
        IdentObj newID = new IdentObj(this.m_id);
        newID.setMiscID(1);
        new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_rect.x, this.m_rect.y, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBox, null, false, false, nWidth);
        newID = new IdentObj(this.m_id);
        newID.setMiscID(2);
        new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBox, null, false, false, nWidth);
        newID = new IdentObj(this.m_id);
        newID.setMiscID(3);
        new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_rect.x, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, blackBox, null, false, false, nWidth);
        newID = new IdentObj(this.m_id);
        newID.setMiscID(4);
        new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_rect.x, this.m_rect.y, this.m_rect.x, this.m_rect.y + this.m_rect.height, blackBox, null, false, false, nWidth);
        if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
            i = 0;
            while (i < this.m_polySide.npoints - 2) {
                newID = new IdentObj(this.m_id);
                newID.setMiscID(100 + i);
                new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_polySide.xpoints[i], this.m_polySide.ypoints[i], this.m_polySide.xpoints[i + 1], this.m_polySide.ypoints[i + 1], (BlackBoxIF)blackBox, null, false, false);
                ++i;
            }
        }
        if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
            i = 0;
            while (i < this.m_polyBottom.npoints - 2) {
                newID = new IdentObj(this.m_id);
                newID.setMiscID(200 + i);
                new DetLine(this.m_Perspective.getDetectiv(), newID, this.m_polyBottom.xpoints[i], this.m_polyBottom.ypoints[i], this.m_polyBottom.xpoints[i + 1], this.m_polyBottom.ypoints[i + 1], (BlackBoxIF)blackBox, null, false, false);
                ++i;
            }
        }
    }

    public boolean isGroupScrollerPresent() {
        boolean bGroupScrollerPresent = this.m_dsGroup != null && this.m_dsGroup.isPresent();
        return bGroupScrollerPresent;
    }

    public void releaseReferences() {
        if (this.m_dsGroup != null) {
            this.m_dsGroup.releaseReferences();
        }
        this.m_Perspective = null;
    }
}

