/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import ice.util.security.jdk11.URLClassLoader_jdk11;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

public class SecurityManager_jdk11
extends SecurityManager {
    private final Class RuntimeClass = class$java$lang$Runtime == null ? (class$java$lang$Runtime = SecurityManager_jdk11.class$("java.lang.Runtime")) : class$java$lang$Runtime;
    private final Class SystemClass = class$java$lang$System == null ? (class$java$lang$System = SecurityManager_jdk11.class$("java.lang.System")) : class$java$lang$System;
    private final Class ThreadClass = class$java$lang$Thread == null ? (class$java$lang$Thread = SecurityManager_jdk11.class$("java.lang.Thread")) : class$java$lang$Thread;
    private final Class ThreadGroupClass = class$java$lang$ThreadGroup == null ? (class$java$lang$ThreadGroup = SecurityManager_jdk11.class$("java.lang.ThreadGroup")) : class$java$lang$ThreadGroup;
    private final String PRIVILEGED_PROXY_NAME = (class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy == null ? (class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy = SecurityManager_jdk11.class$("ice.util.security.jdk11.SecurityManager_jdk11$PrivilegedProxy")) : class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy).getName();
    private final String UNTRUSTED_PROXY_NAME = (class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy == null ? (class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy = SecurityManager_jdk11.class$("ice.util.security.jdk11.SecurityManager_jdk11$UntrustedProxy")) : class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy).getName();
    private final Object lock = new Object();
    private ThreadGroup _unprivilegedGroupsRoot;
    private int _maxUnprivilegedPriority = Thread.currentThread().getPriority();
    private boolean _inGroupInit;
    static /* synthetic */ Class class$java$lang$Runtime;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ThreadGroup;
    static /* synthetic */ Class class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy;
    static /* synthetic */ Class class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy;

    private SecurityException securityException() {
        if (Debug.trace) {
            Debug.traceStack("constructing SecurityException");
        }
        return new SecurityException();
    }

    private boolean isTrusted() {
        return this.getUntrustedDepth() < 0;
    }

    private int getUntrustedDepth() {
        int n;
        int n2 = this.classDepth(this.UNTRUSTED_PROXY_NAME);
        int n3 = this.classLoaderDepth();
        if (n2 >= 0) {
            if (0 <= n3 && n3 < n2) {
                n2 = n3;
            }
        } else {
            n2 = n3;
        }
        if (n2 >= 0 && 0 <= (n = this.classDepth(this.PRIVILEGED_PROXY_NAME)) && n < n2) {
            n2 = -1;
        }
        return n2;
    }

    Object doPrivileged(BoxedCode boxedCode) {
        int n;
        if (2 != this.classDepth("ice.util.security.SecurityKit")) {
            Debug.bug();
        }
        if (0 <= (n = this.classLoaderDepth()) && n <= 4) {
            throw this.securityException();
        }
        return PrivilegedProxy.callPrivileged(boxedCode);
    }

    Object doUntrusted(BoxedCode boxedCode) {
        return UntrustedProxy.callUntrusted(boxedCode);
    }

    private URLClassLoader_jdk11 currentURLClassLoader() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof URLClassLoader_jdk11) {
            return (URLClassLoader_jdk11)classLoader;
        }
        return null;
    }

    public Object getSecurityContext() {
        URLClassLoader_jdk11 uRLClassLoader_jdk11 = this.currentURLClassLoader();
        if (uRLClassLoader_jdk11 != null) {
            return uRLClassLoader_jdk11.getSecurityContext();
        }
        return null;
    }

    public void checkCreateClassLoader() {
        if (this.isTrusted()) {
            return;
        }
        throw this.securityException();
    }

    public void checkAccess(Thread thread) {
        if (this.isTrusted()) {
            return;
        }
        String string = thread.getClass().getName();
        if (!string.equals("java.awt.EventDispatchThread")) {
            return;
        }
        throw this.securityException();
    }

    public ThreadGroup getThreadGroup() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (this.isTrusted()) {
            return threadGroup;
        }
        URLClassLoader_jdk11 uRLClassLoader_jdk11 = this.currentURLClassLoader();
        if (uRLClassLoader_jdk11 != null) {
            Object object = this.lock;
            synchronized (object) {
                this._inGroupInit = true;
                try {
                    threadGroup = this.getUnprivilegedGroup(uRLClassLoader_jdk11);
                    Object var6_5 = null;
                    this._inGroupInit = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this._inGroupInit = false;
                    throw throwable;
                }
            }
            return threadGroup;
        }
        throw this.securityException();
    }

    private ThreadGroup getUnprivilegedGroup(URLClassLoader_jdk11 uRLClassLoader_jdk11) {
        ThreadGroup threadGroup = uRLClassLoader_jdk11._threadGroup;
        if (threadGroup == null) {
            if (this._unprivilegedGroupsRoot == null) {
                this._unprivilegedGroupsRoot = new ThreadGroup("Untrusted threads root");
            }
            if ((threadGroup = new UnprivilegedGroup(this._unprivilegedGroupsRoot)).getMaxPriority() > this._maxUnprivilegedPriority) {
                threadGroup.setMaxPriority(this._maxUnprivilegedPriority);
            }
            uRLClassLoader_jdk11._threadGroup = threadGroup;
        }
        return threadGroup;
    }

    public void checkAccess(ThreadGroup threadGroup) {
        Class<?>[] classArray;
        int n = this.getUntrustedDepth();
        if (n < 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this._inGroupInit) {
                return;
            }
        }
        if (threadGroup instanceof UnprivilegedGroup && (classArray = this.getClassContext())[1] == this.ThreadGroupClass && classArray[2] == this.ThreadClass) {
            return;
        }
        int n2 = this.classDepth("sun.awt.image.ImageFetcher");
        if (0 <= n2 && n2 < n) {
            return;
        }
        throw this.securityException();
    }

    public void checkExit(int n) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkExec(String string) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkLink(String string) {
        int n = this.getUntrustedDepth();
        if (n < 0) {
            return;
        }
        Class<?>[] classArray = this.getClassContext();
        if (classArray[1] == this.RuntimeClass) {
            int n2 = 2;
            if (classArray[n2] == this.SystemClass) {
                ++n2;
            }
            if (n2 < n) {
                String string2;
                if (classArray[n2].getClassLoader() != null) {
                    Debug.bug();
                }
                if ((string2 = classArray[n2].getName()).startsWith("java.")) {
                    return;
                }
            }
        }
        throw this.securityException();
    }

    public void checkPropertiesAccess() {
        if (this.isTrusted()) {
            return;
        }
    }

    public void checkPropertyAccess(String string) {
        if (this.isTrusted()) {
            return;
        }
        if (string.equals("java.home") || string.equals("java.class.path") || string.startsWith("user.")) {
            throw this.securityException();
        }
    }

    public void checkRead(String string) {
        this.checkReadImpl(string, null);
    }

    public void checkRead(String string, Object object) {
        this.checkReadImpl(string, object);
    }

    private void checkReadImpl(String string, Object object) {
        int n = this.getUntrustedDepth();
        if (n < 0) {
            return;
        }
        int n2 = this.classDepth("java.util.ResourceBundle");
        if (0 <= n2 && n2 < n) {
            return;
        }
        throw this.securityException();
    }

    public void checkWrite(String string) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkDelete(String string) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor.valid()) {
            int n = this.getUntrustedDepth();
            if (n < 0) {
                return;
            }
            int n2 = this.classDepth("java.net.SocketInputStream");
            if (0 <= n2 && n2 < n) {
                return;
            }
        }
        throw this.securityException();
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor.valid()) {
            int n = this.getUntrustedDepth();
            if (n < 0) {
                return;
            }
            int n2 = this.classDepth("java.net.SocketOutputStream");
            if (0 <= n2 && n2 < n) {
                return;
            }
        }
        throw this.securityException();
    }

    public void checkListen(int n) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkAccept(String string, int n) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkConnect(String string, int n) {
        this.checkConnect(string, n, this.getSecurityContext());
    }

    public void checkConnect(String string, int n, Object object) {
        URL uRL;
        String string2;
        if (this.isTrusted()) {
            return;
        }
        if (object instanceof URL && this.canConnect(string2 = (uRL = (URL)object).getHost(), string)) {
            return;
        }
        throw this.securityException();
    }

    private boolean canConnect(String string, String string2) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.inCheck = true;
                bl = SecurityManager_jdk11.sameHosts(string, string2);
                Object var6_5 = null;
                this.inCheck = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.inCheck = false;
                throw throwable;
            }
        }
        return bl;
    }

    private static boolean sameHosts(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string2.length() == 0) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            InetAddress inetAddress2 = InetAddress.getByName(string);
            if (inetAddress2.equals(inetAddress)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public boolean checkTopLevelWindow(Object object) {
        return this.isTrusted();
    }

    public void checkPackageAccess(String string) {
        if (this.isTrusted()) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("ice.util.security")) {
            bl = true;
        } else {
            String string2;
            int n = -1;
            do {
                string2 = (n = string.indexOf(46, n + 1)) < 0 ? string : string.substring(0, n);
                if (!Defs.sysPropertyBoolean("package.restrict.access." + string2)) continue;
                bl = true;
                break;
            } while (string2 != string);
        }
        if (bl) {
            throw this.securityException();
        }
    }

    public void checkPackageDefinition(String string) {
        if (this.isTrusted()) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("ice.util.security")) {
            bl = true;
        } else if (string.startsWith("java.")) {
            bl = true;
        } else {
            String string2;
            int n = -1;
            do {
                string2 = (n = string.indexOf(46, n + 1)) < 0 ? string : string.substring(0, n);
                if (!Defs.sysPropertyBoolean("package.restrict.definition." + string2)) continue;
                bl = true;
                break;
            } while (string2 != string);
        }
        if (bl) {
            throw this.securityException();
        }
    }

    public void checkSetFactory() {
        if (this.isTrusted()) {
            return;
        }
        throw this.securityException();
    }

    public void checkPrintJobAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkSystemClipboardAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        boolean bl = false;
        String string = clazz.getName();
        if (string.startsWith("ice.util.security.")) {
            bl = true;
        }
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && classLoader != clazz.getClassLoader()) {
            bl = true;
        }
        if (bl) {
            throw this.securityException();
        }
    }

    public void checkSecurityAccess(String string) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UntrustedProxy {
        private UntrustedProxy() {
        }

        static Object callUntrusted(BoxedCode boxedCode) {
            return boxedCode.run();
        }
    }

    private static class PrivilegedProxy {
        private PrivilegedProxy() {
        }

        static Object callPrivileged(BoxedCode boxedCode) {
            return boxedCode.run();
        }
    }

    private static class UnprivilegedGroup
    extends ThreadGroup {
        UnprivilegedGroup(ThreadGroup threadGroup) {
            super(threadGroup, "");
        }
    }
}

