/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.ImageConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class ImageInputStream
extends InputStream {
    private ImageConnection ic;
    private String realUrl;
    private InputStream realIn;
    private URLConnection realUC;

    ImageInputStream(ImageConnection imageConnection, String string) {
        this.ic = imageConnection;
        this.realUrl = string;
    }

    private void checkRealIn() throws IOException {
        if (this.realIn == null && this.realUrl != null) {
            if (this.ic.isStopRequested()) {
                return;
            }
            URL uRL = new URL(this.realUrl);
            this.realUC = uRL.openConnection();
            this.realIn = this.realUC.getInputStream();
        }
    }

    private void closeRealIn() throws IOException {
        if (this.realIn != null) {
            this.realIn.close();
            this.realIn = null;
        }
        this.realUC = null;
    }

    String getContentType() {
        try {
            this.checkRealIn();
            if (this.realUC != null) {
                return this.realUC.getContentType();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void close() throws IOException {
        this.closeRealIn();
        this.ic.inputStreamDone();
    }

    public int read() throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.read(byArray, n, n2);
        }
        return -1;
    }

    public long skip(long l) throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1L;
        }
        if (this.realIn != null) {
            return this.realIn.skip(l);
        }
        return 0L;
    }

    public int available() throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.available();
        }
        return 0;
    }

    public boolean markSupported() {
        try {
            this.checkRealIn();
            if (this.realIn == null) {
                return false;
            }
            return this.realIn.markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void mark(int n) {
        try {
            this.checkRealIn();
            if (this.realIn == null) {
                return;
            }
            this.realIn.mark(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        this.checkRealIn();
        if (this.realIn == null) {
            return;
        }
        this.realIn.reset();
    }
}

