/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.Cache;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.Scripter;
import ice.storm.ScripterFactory;
import ice.storm.ScripterInfo;
import ice.storm.URLClassLoaderFactory;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class DefaultFactory
implements PilotFactory,
ScripterFactory,
URLClassLoaderFactory {
    private static final String propFileName = "storm";
    protected Cache cache = new Cache();

    void loadDefaultResources() {
        boolean bl;
        block13: {
            Object object;
            block12: {
                String string = Defs.sysProperty("ice.storm.storm");
                bl = false;
                if (string != null) {
                    try {
                        object = new URL(string);
                        InputStream inputStream = ((URL)object).openStream();
                        try {
                            this.cache.loadInfos(inputStream);
                            bl = true;
                            Object var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        if (Debug.ex) {
                            Debug.ex(iOException);
                        }
                        if (!Debug.trace) break block12;
                        Debug.trace("ERROR: failed to load properties from " + string + ", trying built-in.");
                    }
                }
            }
            if (!bl && (object = this.getClass().getResourceAsStream(propFileName)) != null) {
                try {
                    try {
                        this.cache.loadInfos((InputStream)object);
                        bl = true;
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    ((InputStream)object).close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block13;
                    Debug.ex(iOException);
                }
            }
        }
        if (!bl && Debug.trace) {
            Debug.trace("ERROR: Could not load default storm properties file");
        }
    }

    public void addPilotInfo(PilotInfo pilotInfo) {
        this.cache.addPilotInfo(pilotInfo);
    }

    public void removePilotInfo(PilotInfo pilotInfo) {
        this.cache.removePilotInfo(pilotInfo);
    }

    public void addScripterInfo(ScripterInfo scripterInfo) {
        this.cache.addScripterInfo(scripterInfo);
    }

    public void removeScripterInfo(ScripterInfo scripterInfo) {
        this.cache.removeScripterInfo(scripterInfo);
    }

    public Enumeration getAllPilotInfos() {
        return this.cache.getAllPilotInfos();
    }

    public Enumeration getAllScripterInfos() {
        return this.cache.getAllScripterInfos();
    }

    public Scripter createScripter(String string) {
        Scripter scripter;
        block8: {
            ScripterInfo scripterInfo = this.cache.getScripterInfo(string);
            if (scripterInfo == null) {
                return null;
            }
            scripter = null;
            try {
                Class clazz = this.getScripterClass(scripterInfo);
                if (clazz == null) break block8;
                try {
                    scripter = (Scripter)clazz.newInstance();
                    scripterInfo.loaded = true;
                }
                catch (InstantiationException instantiationException) {
                    if (Debug.ex) {
                        Debug.ex(instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (Debug.ex) {
                        Debug.ex(illegalAccessException);
                    }
                }
            }
            catch (SecurityException securityException) {
                if (!Debug.ex) break block8;
                Debug.ex(securityException);
            }
        }
        return scripter;
    }

    private Class getScripterClass(ScripterInfo scripterInfo) {
        Object object;
        block3: {
            if (scripterInfo.cl == null && (object = scripterInfo.codeBaseURLs) != null && ((URL[])object).length != 0) {
                scripterInfo.cl = this.createURLClassLoader((URL[])object);
            }
            object = null;
            try {
                object = scripterInfo.cl != null ? scripterInfo.cl.loadClass(scripterInfo.className) : Class.forName(scripterInfo.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Debug.ex) break block3;
                Debug.ex(classNotFoundException);
            }
        }
        return object;
    }

    public ScripterInfo getScripterInfo(String string) {
        return this.cache.getScripterInfo(string);
    }

    public Pilot createPilot(String string) {
        PilotInfo[] pilotInfoArray = this.cache.getPilotInfos(string);
        if (pilotInfoArray.length == 0) {
            return null;
        }
        return this.createPilot(pilotInfoArray);
    }

    public Pilot createPilot(ContentLoader contentLoader) {
        PilotInfo[] pilotInfoArray = this.cache.getPilotInfos(contentLoader);
        if (pilotInfoArray.length == 0) {
            return null;
        }
        return this.createPilot(pilotInfoArray);
    }

    private Pilot createPilot(PilotInfo[] pilotInfoArray) {
        Pilot pilot = null;
        int n = 0;
        while (n < pilotInfoArray.length && pilot == null) {
            PilotInfo pilotInfo = pilotInfoArray[n];
            Throwable throwable = null;
            try {
                if (pilotInfo.cl == null && pilotInfo.codeBaseURLs != null && pilotInfo.codeBaseURLs.length > 0) {
                    pilotInfo.cl = this.createURLClassLoader(pilotInfo.codeBaseURLs);
                }
                pilot = pilotInfo.cl != null ? (Pilot)pilotInfo.cl.loadClass(pilotInfo.className).newInstance() : (Pilot)Class.forName(pilotInfo.className).newInstance();
                pilotInfo.loaded = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable != null) {
                if (Debug.ex) {
                    Debug.ex(throwable);
                }
                if (Debug.trace) {
                    Debug.trace("Could not load " + pilotInfo.className);
                }
                this.cache.removePilotInfo(pilotInfo);
            }
            ++n;
        }
        return pilot;
    }

    public boolean isContentTypeSupported(Pilot pilot, ContentLoader contentLoader, String string) {
        return this.cache.isContentTypeSupported(pilot, contentLoader, string);
    }

    public ClassLoader createURLClassLoader(URL[] uRLArray) {
        return SecurityKit.newURLClassLoader(uRLArray);
    }
}

