/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.mathml;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.LPilot;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import webeq.app.Handler;
import webeq.app.PEquation;
import webeq.fonts.FontBroker;
import webeq.parser.Parser;
import webeq.util.ErrorHandler;

public class ThePilot
extends LPilot {
    private PEquation eq = null;
    private Handler handler = new Handler();
    private ErrorHandler err = new ErrorHandler();
    private String macros = null;
    private String math_parser = "mathml";
    private int font_height = 10;
    private int eqWidth = 0;
    private int eqHeight = 0;

    public void parse(ContentLoader contentLoader) throws IOException {
        this.handler.setParameters((Component)this.getViewportContainer(), null);
        this.eq = new PEquation(this.handler);
        this.eq.initBG();
        this.eq.setSize(this.handler.size().width, this.handler.size().height);
        this.font_height = 18;
        this.eq.setPointSize(this.font_height + 1);
        this.eq.use_controls = false;
        try {
            Parser parser = (Parser)Class.forName("webeq.parser." + this.math_parser + "." + this.math_parser).newInstance();
            parser.init(this.handler);
            parser.parse(this.loadData(contentLoader.getInputStream()), this.macros, this.eq.root, this.err);
            this.layout();
        }
        catch (Exception exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            this.eq = null;
        }
    }

    private void layout() {
        try {
            this.eq.root.layout();
            this.eqWidth = this.eq.root.getWidth() + 2;
            this.eqHeight = this.eq.root.getHeight();
            this.eq.setSize(this.eqWidth, this.eqHeight);
            this.eq.directRedraw();
        }
        catch (Exception exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            this.eq = null;
        }
    }

    public int getWidth() {
        return this.eqWidth;
    }

    public int getHeight() {
        return this.eqHeight;
    }

    public void paint(Graphics graphics) {
        if (this.eq != null && this.eq.getImage() != null) {
            this.eq.paint(graphics);
        }
    }

    private final String loadData(InputStream inputStream) throws IOException {
        Object[] objectArray;
        boolean bl = false;
        int n = 0;
        Object[] objectArray2 = new byte[2048];
        int n2 = inputStream.read((byte[])objectArray2, n, objectArray2.length - n);
        while (n2 > 0) {
            if ((n += n2) == objectArray2.length) {
                objectArray = new byte[objectArray2.length * 2];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                objectArray2 = objectArray;
            }
            n2 = inputStream.read((byte[])objectArray2, n, objectArray2.length - n);
        }
        inputStream.close();
        objectArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            objectArray[n3] = (char)objectArray2[n3];
            ++n3;
        }
        return new String((char[])objectArray);
    }

    static {
        FontBroker.initialize((boolean)true);
    }
}

