/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends JTextField
implements EventListener,
ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    int maxLength = 10000;
    private String startValue;

    FormInputText(DocView docView, DElement dElement) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        this.checkAttributes();
        int n = dElement.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.setColumns(n + 1);
        this.setFont(new Font("Monospaced", 0, 12));
        this.setOpaque(true);
        this.getDocument().addDocumentListener(this);
        this.addCaretListener(this);
    }

    private void checkAttributes() {
        String string;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int n = this.element.getMaxLength();
        if (n > 0) {
            this.maxLength = n;
        }
        if ((string = this.element.getValue()) != null && !string.equals(this.getText())) {
            this.setText(string);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n;
        int n2 = caretEvent.getDot();
        if (n2 != (n = caretEvent.getMark())) {
            int n3;
            int n4;
            if (n2 < n) {
                n4 = n2;
                n3 = n;
            } else {
                n3 = n2;
                n4 = n;
            }
            this.element.dispatchSelection(n4, n3);
        }
    }

    private void textValueChanged() {
        this.docView.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                String string = FormInputText.this.getText();
                if (string.length() > FormInputText.this.maxLength) {
                    int n = FormInputText.this.getCaretPosition();
                    if (n > FormInputText.this.maxLength) {
                        n = FormInputText.this.maxLength;
                    }
                    string = string.substring(0, FormInputText.this.maxLength);
                    FormInputText.this.setText(string);
                    FormInputText.this.setCaretPosition(n);
                }
            }
        }, 0L);
        this.element.setValue(this.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        int n;
        FormInputText formInputText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = (keyEvent = (KeyEvent)aWTEvent).getKeyCode()) != 38 && n != 40 && n != 39 && n != 37)) {
            formInputText = this;
        }
        if (this.docView.onComponentEvent(this, aWTEvent, formInputText)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.processFocusGained(focusEvent);
        } else if (n == 1005) {
            this.processFocusLost(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void processFocusGained(FocusEvent focusEvent) {
        if (this.startValue == null) {
            this.startValue = this.getText();
        }
    }

    private void processFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.getText();
        if (!string.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        super.processEvent((AWTEvent)dOMEvent.getSystemEvent());
        dOMEvent.setDefaultDone();
    }
}

