/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputPasswordText
extends JPasswordField
implements EventListener,
ObjectPainter,
DocumentListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    int maxLength = 10000;
    private String startValue;

    FormInputPasswordText(DocView docView, DElement dElement) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        this.setFont(new Font("Monospaced", 0, 12));
        int n = dElement.getAttributeAsInt("size");
        if (n < 0) {
            n = 20;
        }
        this.setColumns(n + 1);
        this.setOpaque(true);
        this.checkAttributes();
        this.getDocument().addDocumentListener(this);
    }

    private void checkAttributes() {
        String string;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int n = this.element.getMaxLength();
        if (n > 0) {
            this.maxLength = n;
        }
        if ((string = this.element.getValue()) != null && !string.equals(this.getText())) {
            ((JTextComponent)this).setText(string);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    private void textValueChanged() {
        this.docView.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                String string = FormInputPasswordText.this.getText();
                if (string.length() > FormInputPasswordText.this.maxLength) {
                    int n = FormInputPasswordText.this.getCaretPosition();
                    if (n > FormInputPasswordText.this.maxLength) {
                        n = FormInputPasswordText.this.maxLength;
                    }
                    string = string.substring(0, FormInputPasswordText.this.maxLength);
                    ((JTextComponent)FormInputPasswordText.this).setText(string);
                    FormInputPasswordText.this.setCaretPosition(n);
                }
            }
        }, 0L);
        this.element.setValue(this.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        int n;
        FormInputPasswordText formInputPasswordText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = (keyEvent = (KeyEvent)aWTEvent).getKeyCode()) != 38 && n != 40 && n != 39 && n != 37)) {
            formInputPasswordText = this;
        }
        if (this.docView.onComponentEvent(this, aWTEvent, formInputPasswordText)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.processFocusGained(focusEvent);
        } else if (n == 1005) {
            this.processFocusLost(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void processFocusGained(FocusEvent focusEvent) {
        if (this.startValue == null) {
            this.startValue = this.getText();
        }
    }

    private void processFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.getText();
        if (!string.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        super.processEvent((AWTEvent)dOMEvent.getSystemEvent());
        dOMEvent.setDefaultDone();
    }
}

